/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.performance.measure;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import org.sonarsource.performance.measure.DurationMeasure;
import org.sonarsource.performance.measure.DurationMeasureFiles;
import org.sonarsource.performance.measure.log.Logger;

public final class PerformanceMeasure {
    private static final Logger LOG = Logger.get(PerformanceMeasure.class);
    private static final ThreadLocal<DurationMeasure> THREAD_LOCAL_CURRENT_MEASURE = new ThreadLocal();
    private static boolean globalDeactivation = true;
    private static Supplier<Long> nanoTimeSupplier = System::nanoTime;

    private PerformanceMeasure() {
    }

    private static void setGlobalDeactivation(boolean value) {
        globalDeactivation = value;
    }

    public static Builder reportBuilder() {
        return new Builder();
    }

    public static Duration start(Object object) {
        if (globalDeactivation) {
            return IgnoredDuration.INSTANCE;
        }
        return PerformanceMeasure.start(object.getClass().getSimpleName());
    }

    public static Duration start(String name) {
        if (globalDeactivation) {
            return IgnoredDuration.INSTANCE;
        }
        DurationMeasure parentMeasure = THREAD_LOCAL_CURRENT_MEASURE.get();
        if (parentMeasure == null) {
            return IgnoredDuration.INSTANCE;
        }
        DurationMeasure currentMeasure = parentMeasure.getOrCreateChild(name);
        THREAD_LOCAL_CURRENT_MEASURE.set(currentMeasure);
        return new RecordedDuration(parentMeasure, currentMeasure);
    }

    static void ensureParentDirectoryExists(Path path) throws IOException {
        Path parentDirectory = path.getParent();
        if (parentDirectory != null && !Files.isDirectory(parentDirectory, new LinkOption[0])) {
            Files.createDirectory(parentDirectory, new FileAttribute[0]);
        }
    }

    static void overrideTimeSupplierForTest(Supplier<Long> nanoTimeSupplier) {
        PerformanceMeasure.nanoTimeSupplier = nanoTimeSupplier;
    }

    static void deactivateAndClearCurrentMeasureForTest() {
        PerformanceMeasure.setGlobalDeactivation(true);
        THREAD_LOCAL_CURRENT_MEASURE.remove();
    }

    public static final class IgnoredDuration
    implements Duration {
        public static final IgnoredDuration INSTANCE = new IgnoredDuration();

        @Override
        public void stop() {
        }
    }

    @FunctionalInterface
    public static interface Duration {
        public void stop();
    }

    private static class RecordedDurationReport
    implements Duration {
        private static final String PARENT_OF_THROWAWAY_MEASURES_TO_COMPUTE_OBSERVATION_COST = "#measures to compute observation cost";
        private static final int SAMPLING_COUNT_TO_EVALUATE_OBSERVATION_COST = 99;
        private static final Supplier<IntStream> SAMPLES = () -> IntStream.range(0, 99);
        private final RecordedDuration duration;
        @Nullable
        private final Path performanceMeasureFile;
        private final boolean appendMeasurementCost;

        public RecordedDurationReport(@Nullable DurationMeasure parentMeasure, DurationMeasure measure, @Nullable Path performanceMeasureFile, boolean appendMeasurementCost) {
            this.duration = new RecordedDuration(parentMeasure, measure);
            this.performanceMeasureFile = performanceMeasureFile;
            this.appendMeasurementCost = appendMeasurementCost;
        }

        @Override
        public void stop() {
            if (this.appendMeasurementCost) {
                THREAD_LOCAL_CURRENT_MEASURE.set(this.duration.measure);
                RecordedDurationReport.appendMeasurementCost();
            }
            this.duration.stop();
            LOG.debug(() -> "Performance Measures:\n" + DurationMeasureFiles.toJson(this.duration.measure));
            if (this.performanceMeasureFile != null) {
                RecordedDurationReport.saveToFile(this.duration.measure, this.performanceMeasureFile);
            }
        }

        private static void appendMeasurementCost() {
            String[] sampleNames = (String[])SAMPLES.get().mapToObj(i -> "m" + i).toArray(String[]::new);
            RecordedDuration totalDuration = (RecordedDuration)PerformanceMeasure.start("#MeasurementCost_v1");
            DurationMeasure measurementCost = totalDuration.measure;
            RecordedDuration temporaryDuration = (RecordedDuration)PerformanceMeasure.start(PARENT_OF_THROWAWAY_MEASURES_TO_COMPUTE_OBSERVATION_COST);
            measurementCost.getOrCreateChild("nanoTime").addCalls(1L, RecordedDurationReport.median(SAMPLES.get().mapToLong(i -> {
                long start = (Long)nanoTimeSupplier.get();
                return (Long)nanoTimeSupplier.get() - start;
            })));
            measurementCost.getOrCreateChild("createChild").addCalls(1L, RecordedDurationReport.median(SAMPLES.get().mapToLong(i -> {
                long start = (Long)nanoTimeSupplier.get();
                PerformanceMeasure.start(sampleNames[i]).stop();
                return (Long)nanoTimeSupplier.get() - start;
            })));
            measurementCost.getOrCreateChild("observationCost").addCalls(1L, RecordedDurationReport.median(Arrays.stream(sampleNames).map(temporaryDuration.measure::get).mapToLong(DurationMeasure::durationNanos)));
            PerformanceMeasure.start("measure").stop();
            measurementCost.getOrCreateChild("incrementChild").addCalls(1L, RecordedDurationReport.median(SAMPLES.get().mapToLong(i -> {
                long start = (Long)nanoTimeSupplier.get();
                PerformanceMeasure.start("measure").stop();
                return (Long)nanoTimeSupplier.get() - start;
            })));
            temporaryDuration.stop();
            measurementCost.remove(PARENT_OF_THROWAWAY_MEASURES_TO_COMPUTE_OBSERVATION_COST);
            totalDuration.stop();
        }

        private static long median(LongStream measures) {
            long[] sortedMeasures = measures.sorted().toArray();
            return sortedMeasures[(sortedMeasures.length - 1) / 2];
        }

        private static void saveToFile(DurationMeasure measure, Path performanceFile) {
            try {
                DurationMeasure allMeasures;
                if (Files.exists(performanceFile, new LinkOption[0])) {
                    LOG.info(() -> "Adding performance measures into: " + performanceFile);
                    DurationMeasure existingMeasure = DurationMeasureFiles.fromJson(performanceFile);
                    allMeasures = existingMeasure.merge(measure);
                } else {
                    LOG.info(() -> "Saving performance measures into: " + performanceFile);
                    allMeasures = measure;
                    PerformanceMeasure.ensureParentDirectoryExists(performanceFile);
                }
                Files.write(performanceFile, DurationMeasureFiles.toJson(allMeasures).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException | IllegalStateException e) {
                LOG.error(() -> "Can't save performance measure: " + e.getMessage());
            }
        }
    }

    private static class RecordedDuration
    implements Duration {
        @Nullable
        protected final DurationMeasure parentMeasure;
        protected final DurationMeasure measure;
        private long startNanos;

        public RecordedDuration(@Nullable DurationMeasure parentMeasure, DurationMeasure measure) {
            this.parentMeasure = parentMeasure;
            this.measure = measure;
            this.startNanos = (Long)nanoTimeSupplier.get();
        }

        @Override
        public void stop() {
            if (this.startNanos != -1L) {
                this.measure.addCalls(1L, (Long)nanoTimeSupplier.get() - this.startNanos);
                this.startNanos = -1L;
                if (this.parentMeasure == null) {
                    THREAD_LOCAL_CURRENT_MEASURE.remove();
                } else {
                    THREAD_LOCAL_CURRENT_MEASURE.set(this.parentMeasure);
                }
            }
        }
    }

    public static class Builder {
        private boolean active = false;
        @Nullable
        private String performanceFile = null;
        boolean appendMeasurementCost = false;

        public Builder activate(boolean active) {
            this.active = active;
            return this;
        }

        public Builder appendMeasurementCost() {
            this.appendMeasurementCost = true;
            return this;
        }

        public Builder toFile(@Nullable String performanceFile) {
            this.performanceFile = performanceFile;
            return this;
        }

        public Duration start(String name) {
            if (!this.active) {
                return IgnoredDuration.INSTANCE;
            }
            PerformanceMeasure.setGlobalDeactivation(false);
            Path performanceMeasureFile = null;
            if (this.performanceFile != null && !this.performanceFile.isEmpty()) {
                performanceMeasureFile = Paths.get(this.performanceFile.replace('\\', File.separatorChar).replace('/', File.separatorChar), new String[0]);
            }
            DurationMeasure parentMeasure = (DurationMeasure)THREAD_LOCAL_CURRENT_MEASURE.get();
            DurationMeasure currentMeasure = new DurationMeasure(name);
            THREAD_LOCAL_CURRENT_MEASURE.set(currentMeasure);
            return new RecordedDurationReport(parentMeasure, currentMeasure, performanceMeasureFile, this.appendMeasurementCost);
        }
    }
}

