/*
 * Decompiled with CFR 0.152.
 */
package org.sol4k.tweetnacl;

import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicLong;

public final class TweetNacl {
    private static final String TAG = "TweetNacl";
    private static final byte[] _0;
    private static final byte[] _9;
    private static final long[] gf0;
    private static final long[] gf1;
    private static final long[] _121665;
    private static final long[] D;
    private static final long[] D2;
    private static final long[] X;
    private static final long[] Y;
    private static final long[] I;
    private static final byte[] sigma;
    private static final long[] K;
    private static final byte[] iv;
    private static final long[] L;
    private static final SecureRandom jrandom;

    private static int L32(int x, int c) {
        return x << c | (x & 0xFFFFFFFF) >>> 32 - c;
    }

    private static int ld32(byte[] x, int xoff, int xlen) {
        int u = x[3 + xoff] & 0xFF;
        u = u << 8 | x[2 + xoff] & 0xFF;
        u = u << 8 | x[1 + xoff] & 0xFF;
        return u << 8 | x[0 + xoff] & 0xFF;
    }

    private static long dl64(byte[] x, int xoff, int xlen) {
        long u = 0L;
        for (int i = 0; i < 8; ++i) {
            u = u << 8 | (long)(x[i + xoff] & 0xFF);
        }
        return u;
    }

    private static void st32(byte[] x, int xoff, int xlen, int u) {
        for (int i = 0; i < 4; ++i) {
            x[i + xoff] = (byte)(u & 0xFF);
            u >>>= 8;
        }
    }

    private static void ts64(byte[] x, int xoff, int xlen, long u) {
        for (int i = 7; i >= 0; --i) {
            x[i + xoff] = (byte)(u & 0xFFL);
            u >>>= 8;
        }
    }

    private static int vn(byte[] x, int xoff, int xlen, byte[] y, int yoff, int ylen, int n) {
        int d = 0;
        for (int i = 0; i < n; ++i) {
            d |= (x[i + xoff] ^ y[i + yoff]) & 0xFF;
        }
        return (1 & d - 1 >>> 8) - 1;
    }

    private static int crypto_verify_16(byte[] x, int xoff, int xlen, byte[] y, int yoff, int ylen) {
        return TweetNacl.vn(x, xoff, xlen, y, yoff, ylen, 16);
    }

    public static int crypto_verify_16(byte[] x, byte[] y) {
        return TweetNacl.crypto_verify_16(x, 0, x.length, y, 0, y.length);
    }

    private static int crypto_verify_32(byte[] x, int xoff, int xlen, byte[] y, int yoff, int ylen) {
        return TweetNacl.vn(x, xoff, xlen, y, yoff, ylen, 32);
    }

    public static int crypto_verify_32(byte[] x, byte[] y) {
        return TweetNacl.crypto_verify_32(x, 0, x.length, y, 0, y.length);
    }

    private static void core(byte[] out, byte[] in, byte[] k, byte[] c, int h) {
        int i;
        int[] w = new int[16];
        int[] x = new int[16];
        int[] y = new int[16];
        int[] t = new int[4];
        for (i = 0; i < 4; ++i) {
            x[5 * i] = TweetNacl.ld32(c, 4 * i, 4);
            x[1 + i] = TweetNacl.ld32(k, 4 * i, 4);
            x[6 + i] = TweetNacl.ld32(in, 4 * i, 4);
            x[11 + i] = TweetNacl.ld32(k, 16 + 4 * i, 4);
        }
        for (i = 0; i < 16; ++i) {
            y[i] = x[i];
        }
        for (i = 0; i < 20; ++i) {
            int m;
            for (int j = 0; j < 4; ++j) {
                for (m = 0; m < 4; ++m) {
                    t[m] = x[(5 * j + 4 * m) % 16];
                }
                t[1] = t[1] ^ TweetNacl.L32(t[0] + t[3], 7);
                t[2] = t[2] ^ TweetNacl.L32(t[1] + t[0], 9);
                t[3] = t[3] ^ TweetNacl.L32(t[2] + t[1], 13);
                t[0] = t[0] ^ TweetNacl.L32(t[3] + t[2], 18);
                for (m = 0; m < 4; ++m) {
                    w[4 * j + (j + m) % 4] = t[m];
                }
            }
            for (m = 0; m < 16; ++m) {
                x[m] = w[m];
            }
        }
        if (h != 0) {
            for (i = 0; i < 16; ++i) {
                int n = i;
                x[n] = x[n] + y[i];
            }
            for (i = 0; i < 4; ++i) {
                int n = 5 * i;
                x[n] = x[n] - TweetNacl.ld32(c, 4 * i, 4);
                int n2 = 6 + i;
                x[n2] = x[n2] - TweetNacl.ld32(in, 4 * i, 4);
            }
            for (i = 0; i < 4; ++i) {
                TweetNacl.st32(out, 4 * i, 4, x[5 * i]);
                TweetNacl.st32(out, 16 + 4 * i, 4, x[6 + i]);
            }
        } else {
            for (i = 0; i < 16; ++i) {
                TweetNacl.st32(out, 4 * i, 4, x[i] + y[i]);
            }
        }
    }

    public static int crypto_core_salsa20(byte[] out, byte[] in, byte[] k, byte[] c) {
        TweetNacl.core(out, in, k, c, 0);
        return 0;
    }

    public static int crypto_core_hsalsa20(byte[] out, byte[] in, byte[] k, byte[] c) {
        TweetNacl.core(out, in, k, c, 1);
        return 0;
    }

    private static int crypto_stream_salsa20_xor(byte[] c, byte[] m, long b, byte[] n, int noff, int nlen, byte[] k) {
        int i;
        byte[] z = new byte[16];
        byte[] x = new byte[64];
        if (0L == b) {
            return 0;
        }
        for (i = 0; i < 16; ++i) {
            z[i] = 0;
        }
        for (i = 0; i < 8; ++i) {
            z[i] = n[i + noff];
        }
        int coffset = 0;
        int moffset = 0;
        while (b >= 64L) {
            TweetNacl.crypto_core_salsa20(x, z, k, sigma);
            for (i = 0; i < 64; ++i) {
                c[i + coffset] = (byte)(((m != null ? m[i + moffset] : (byte)0) ^ x[i]) & 0xFF);
            }
            int u = 1;
            for (i = 8; i < 16; ++i) {
                z[i] = (byte)((u += z[i] & 0xFF) & 0xFF);
                u >>>= 8;
            }
            b -= 64L;
            coffset += 64;
            if (m == null) continue;
            moffset += 64;
        }
        if (b != 0L) {
            TweetNacl.crypto_core_salsa20(x, z, k, sigma);
            i = 0;
            while ((long)i < b) {
                c[i + coffset] = (byte)(((m != null ? m[i + moffset] : (byte)0) ^ x[i]) & 0xFF);
                ++i;
            }
        }
        return 0;
    }

    public static int crypto_stream_salsa20_xor(byte[] c, byte[] m, long b, byte[] n, byte[] k) {
        return TweetNacl.crypto_stream_salsa20_xor(c, m, b, n, 0, n.length, k);
    }

    private static int crypto_stream_salsa20(byte[] c, long d, byte[] n, int noff, int nlen, byte[] k) {
        return TweetNacl.crypto_stream_salsa20_xor(c, null, d, n, noff, nlen, k);
    }

    public static int crypto_stream_salsa20(byte[] c, long d, byte[] n, byte[] k) {
        return TweetNacl.crypto_stream_salsa20(c, d, n, 0, n.length, k);
    }

    public static int crypto_stream(byte[] c, long d, byte[] n, byte[] k) {
        byte[] s = new byte[32];
        TweetNacl.crypto_core_hsalsa20(s, n, k, sigma);
        return TweetNacl.crypto_stream_salsa20(c, d, n, 16, n.length - 16, s);
    }

    public static int crypto_stream_xor(byte[] c, byte[] m, long d, byte[] n, byte[] k) {
        byte[] s = new byte[32];
        TweetNacl.crypto_core_hsalsa20(s, n, k, sigma);
        return TweetNacl.crypto_stream_salsa20_xor(c, m, d, n, 16, n.length - 16, s);
    }

    private static int crypto_onetimeauth(byte[] out, int outpos, int outlen, byte[] m, int mpos, int mlen, int n, byte[] k) {
        poly1305 s = new poly1305(k);
        s.update(m, mpos, n);
        s.finish(out, outpos);
        return 0;
    }

    public static int crypto_onetimeauth(byte[] out, byte[] m, int n, byte[] k) {
        return TweetNacl.crypto_onetimeauth(out, 0, out.length, m, 0, m.length, n, k);
    }

    private static int crypto_onetimeauth_verify(byte[] h, int hoff, int hlen, byte[] m, int moff, int mlen, int n, byte[] k) {
        byte[] x = new byte[16];
        TweetNacl.crypto_onetimeauth(x, 0, x.length, m, moff, mlen, n, k);
        return TweetNacl.crypto_verify_16(h, hoff, hlen, x, 0, x.length);
    }

    public static int crypto_onetimeauth_verify(byte[] h, byte[] m, int n, byte[] k) {
        return TweetNacl.crypto_onetimeauth_verify(h, 0, h.length, m, 0, m.length, n, k);
    }

    public static int crypto_onetimeauth_verify(byte[] h, byte[] m, byte[] k) {
        return TweetNacl.crypto_onetimeauth_verify(h, m, m != null ? m.length : 0, k);
    }

    public static int crypto_secretbox(byte[] c, byte[] m, int d, byte[] n, byte[] k) {
        if (d < 32) {
            return -1;
        }
        TweetNacl.crypto_stream_xor(c, m, d, n, k);
        TweetNacl.crypto_onetimeauth(c, 16, c.length - 16, c, 32, c.length - 32, d - 32, c);
        return 0;
    }

    public static int crypto_secretbox_open(byte[] m, byte[] c, int d, byte[] n, byte[] k) {
        byte[] x = new byte[32];
        if (d < 32) {
            return -1;
        }
        TweetNacl.crypto_stream(x, 32L, n, k);
        if (TweetNacl.crypto_onetimeauth_verify(c, 16, 16, c, 32, c.length - 32, d - 32, x) != 0) {
            return -1;
        }
        TweetNacl.crypto_stream_xor(m, c, d, n, k);
        return 0;
    }

    private static void set25519(long[] r, long[] a) {
        for (int i = 0; i < 16; ++i) {
            r[i] = a[i];
        }
    }

    private static void car25519(long[] o, int ooff, int olen) {
        for (int i = 0; i < 16; ++i) {
            int n = i + ooff;
            o[n] = o[n] + 65536L;
            long c = o[i + ooff] >> 16;
            int n2 = (i + 1) * (i < 15 ? 1 : 0) + ooff;
            o[n2] = o[n2] + (c - 1L + 37L * (c - 1L) * (long)(i == 15 ? 1 : 0));
            int n3 = i + ooff;
            o[n3] = o[n3] - (c << 16);
        }
    }

    private static void sel25519(long[] p, int poff, int plen, long[] q, int qoff, int qlen, int b) {
        long c = ~(b - 1);
        for (int i = 0; i < 16; ++i) {
            long t = c & (p[i + poff] ^ q[i + qoff]);
            int n = i + poff;
            p[n] = p[n] ^ t;
            int n2 = i + qoff;
            q[n2] = q[n2] ^ t;
        }
    }

    private static void pack25519(byte[] o, long[] n, int noff, int nlen) {
        int i;
        long[] m = new long[16];
        long[] t = new long[16];
        for (i = 0; i < 16; ++i) {
            t[i] = n[i + noff];
        }
        TweetNacl.car25519(t, 0, t.length);
        TweetNacl.car25519(t, 0, t.length);
        TweetNacl.car25519(t, 0, t.length);
        for (int j = 0; j < 2; ++j) {
            m[0] = t[0] - 65517L;
            for (i = 1; i < 15; ++i) {
                m[i] = t[i] - 65535L - (m[i - 1] >> 16 & 1L);
                int n2 = i - 1;
                m[n2] = m[n2] & 0xFFFFL;
            }
            m[15] = t[15] - 32767L - (m[14] >> 16 & 1L);
            int b = (int)(m[15] >> 16 & 1L);
            m[14] = m[14] & 0xFFFFL;
            TweetNacl.sel25519(t, 0, t.length, m, 0, m.length, 1 - b);
        }
        for (i = 0; i < 16; ++i) {
            o[2 * i] = (byte)(t[i] & 0xFFL);
            o[2 * i + 1] = (byte)(t[i] >> 8);
        }
    }

    private static int neq25519(long[] a, long[] b) {
        byte[] c = new byte[32];
        byte[] d = new byte[32];
        TweetNacl.pack25519(c, a, 0, a.length);
        TweetNacl.pack25519(d, b, 0, b.length);
        return TweetNacl.crypto_verify_32(c, 0, c.length, d, 0, d.length);
    }

    private static byte par25519(long[] a) {
        byte[] d = new byte[32];
        TweetNacl.pack25519(d, a, 0, a.length);
        return (byte)(d[0] & 1);
    }

    private static void unpack25519(long[] o, byte[] n) {
        for (int i = 0; i < 16; ++i) {
            o[i] = (long)(n[2 * i] & 0xFF) + (long)(n[2 * i + 1] << 8 & 0xFFFF);
        }
        o[15] = o[15] & 0x7FFFL;
    }

    private static void A(long[] o, int ooff, int olen, long[] a, int aoff, int alen, long[] b, int boff, int blen) {
        for (int i = 0; i < 16; ++i) {
            o[i + ooff] = a[i + aoff] + b[i + boff];
        }
    }

    private static void Z(long[] o, int ooff, int olen, long[] a, int aoff, int alen, long[] b, int boff, int blen) {
        for (int i = 0; i < 16; ++i) {
            o[i + ooff] = a[i + aoff] - b[i + boff];
        }
    }

    private static void M(long[] o, int ooff, int olen, long[] a, int aoff, int alen, long[] b, int boff, int blen) {
        int i;
        long[] t = new long[31];
        for (i = 0; i < 31; ++i) {
            t[i] = 0L;
        }
        for (i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int n = i + j;
                t[n] = t[n] + a[i + aoff] * b[j + boff];
            }
        }
        for (i = 0; i < 15; ++i) {
            int n = i;
            t[n] = t[n] + 38L * t[i + 16];
        }
        for (i = 0; i < 16; ++i) {
            o[i + ooff] = t[i];
        }
        TweetNacl.car25519(o, ooff, olen);
        TweetNacl.car25519(o, ooff, olen);
    }

    private static void S(long[] o, int ooff, int olen, long[] a, int aoff, int alen) {
        TweetNacl.M(o, ooff, olen, a, aoff, alen, a, aoff, alen);
    }

    private static void inv25519(long[] o, int ooff, int olen, long[] i, int ioff, int ilen) {
        int a;
        long[] c = new long[16];
        for (a = 0; a < 16; ++a) {
            c[a] = i[a + ioff];
        }
        for (a = 253; a >= 0; --a) {
            TweetNacl.S(c, 0, c.length, c, 0, c.length);
            if (a == 2 || a == 4) continue;
            TweetNacl.M(c, 0, c.length, c, 0, c.length, i, ioff, ilen);
        }
        for (a = 0; a < 16; ++a) {
            o[a + ooff] = c[a];
        }
    }

    private static void pow2523(long[] o, long[] i) {
        int a;
        long[] c = new long[16];
        for (a = 0; a < 16; ++a) {
            c[a] = i[a];
        }
        for (a = 250; a >= 0; --a) {
            TweetNacl.S(c, 0, c.length, c, 0, c.length);
            if (a == 1) continue;
            TweetNacl.M(c, 0, c.length, c, 0, c.length, i, 0, i.length);
        }
        for (a = 0; a < 16; ++a) {
            o[a] = c[a];
        }
    }

    public static int crypto_scalarmult(byte[] q, byte[] n, byte[] p) {
        int i;
        byte[] z = new byte[32];
        long[] x = new long[80];
        long[] a = new long[16];
        long[] b = new long[16];
        long[] c = new long[16];
        long[] d = new long[16];
        long[] e = new long[16];
        long[] f = new long[16];
        for (i = 0; i < 31; ++i) {
            z[i] = n[i];
        }
        z[31] = (byte)((n[31] & 0x7F | 0x40) & 0xFF);
        z[0] = (byte)(z[0] & 0xF8);
        TweetNacl.unpack25519(x, p);
        for (i = 0; i < 16; ++i) {
            b[i] = x[i];
            c[i] = 0L;
            a[i] = 0L;
            d[i] = 0L;
        }
        d[0] = 1L;
        a[0] = 1L;
        for (i = 254; i >= 0; --i) {
            int r = z[i >>> 3] >>> (i & 7) & 1;
            TweetNacl.sel25519(a, 0, a.length, b, 0, b.length, r);
            TweetNacl.sel25519(c, 0, c.length, d, 0, d.length, r);
            TweetNacl.A(e, 0, e.length, a, 0, a.length, c, 0, c.length);
            TweetNacl.Z(a, 0, a.length, a, 0, a.length, c, 0, c.length);
            TweetNacl.A(c, 0, c.length, b, 0, b.length, d, 0, d.length);
            TweetNacl.Z(b, 0, b.length, b, 0, b.length, d, 0, d.length);
            TweetNacl.S(d, 0, d.length, e, 0, e.length);
            TweetNacl.S(f, 0, f.length, a, 0, a.length);
            TweetNacl.M(a, 0, a.length, c, 0, c.length, a, 0, a.length);
            TweetNacl.M(c, 0, c.length, b, 0, b.length, e, 0, e.length);
            TweetNacl.A(e, 0, e.length, a, 0, a.length, c, 0, c.length);
            TweetNacl.Z(a, 0, a.length, a, 0, a.length, c, 0, c.length);
            TweetNacl.S(b, 0, b.length, a, 0, a.length);
            TweetNacl.Z(c, 0, c.length, d, 0, d.length, f, 0, f.length);
            TweetNacl.M(a, 0, a.length, c, 0, c.length, _121665, 0, _121665.length);
            TweetNacl.A(a, 0, a.length, a, 0, a.length, d, 0, d.length);
            TweetNacl.M(c, 0, c.length, c, 0, c.length, a, 0, a.length);
            TweetNacl.M(a, 0, a.length, d, 0, d.length, f, 0, f.length);
            TweetNacl.M(d, 0, d.length, b, 0, b.length, x, 0, x.length);
            TweetNacl.S(b, 0, b.length, e, 0, e.length);
            TweetNacl.sel25519(a, 0, a.length, b, 0, b.length, r);
            TweetNacl.sel25519(c, 0, c.length, d, 0, d.length, r);
        }
        for (i = 0; i < 16; ++i) {
            x[i + 16] = a[i];
            x[i + 32] = c[i];
            x[i + 48] = b[i];
            x[i + 64] = d[i];
        }
        TweetNacl.inv25519(x, 32, x.length - 32, x, 32, x.length - 32);
        TweetNacl.M(x, 16, x.length - 16, x, 16, x.length - 16, x, 32, x.length - 32);
        TweetNacl.pack25519(q, x, 16, x.length - 16);
        return 0;
    }

    public static int crypto_scalarmult_base(byte[] q, byte[] n) {
        return TweetNacl.crypto_scalarmult(q, n, _9);
    }

    public static int crypto_box_keypair(byte[] y, byte[] x) {
        TweetNacl.randombytes(x, 32);
        return TweetNacl.crypto_scalarmult_base(y, x);
    }

    public static int crypto_box_beforenm(byte[] k, byte[] y, byte[] x) {
        byte[] s = new byte[32];
        TweetNacl.crypto_scalarmult(s, x, y);
        return TweetNacl.crypto_core_hsalsa20(k, _0, s, sigma);
    }

    public static int crypto_box_afternm(byte[] c, byte[] m, int d, byte[] n, byte[] k) {
        return TweetNacl.crypto_secretbox(c, m, d, n, k);
    }

    public static int crypto_box_open_afternm(byte[] m, byte[] c, int d, byte[] n, byte[] k) {
        return TweetNacl.crypto_secretbox_open(m, c, d, n, k);
    }

    public static int crypto_box(byte[] c, byte[] m, int d, byte[] n, byte[] y, byte[] x) {
        byte[] k = new byte[32];
        TweetNacl.crypto_box_beforenm(k, y, x);
        return TweetNacl.crypto_box_afternm(c, m, d, n, k);
    }

    public static int crypto_box_open(byte[] m, byte[] c, int d, byte[] n, byte[] y, byte[] x) {
        byte[] k = new byte[32];
        TweetNacl.crypto_box_beforenm(k, y, x);
        return TweetNacl.crypto_box_open_afternm(m, c, d, n, k);
    }

    private static long R(long x, int c) {
        return x >>> c | x << 64 - c;
    }

    private static long Ch(long x, long y, long z) {
        return x & y ^ (x ^ 0xFFFFFFFFFFFFFFFFL) & z;
    }

    private static long Maj(long x, long y, long z) {
        return x & y ^ x & z ^ y & z;
    }

    private static long Sigma0(long x) {
        return TweetNacl.R(x, 28) ^ TweetNacl.R(x, 34) ^ TweetNacl.R(x, 39);
    }

    private static long Sigma1(long x) {
        return TweetNacl.R(x, 14) ^ TweetNacl.R(x, 18) ^ TweetNacl.R(x, 41);
    }

    private static long sigma0(long x) {
        return TweetNacl.R(x, 1) ^ TweetNacl.R(x, 8) ^ x >>> 7;
    }

    private static long sigma1(long x) {
        return TweetNacl.R(x, 19) ^ TweetNacl.R(x, 61) ^ x >>> 6;
    }

    private static int crypto_hashblocks(byte[] x, byte[] m, int moff, int mlen, int n) {
        int i;
        long[] z = new long[8];
        long[] b = new long[8];
        long[] a = new long[8];
        long[] w = new long[16];
        for (i = 0; i < 8; ++i) {
            z[i] = a[i] = TweetNacl.dl64(x, 8 * i, x.length - 8 * i);
        }
        int moffset = moff;
        while (n >= 128) {
            for (i = 0; i < 16; ++i) {
                w[i] = TweetNacl.dl64(m, 8 * i + moffset, mlen - 8 * i);
            }
            for (i = 0; i < 80; ++i) {
                int j;
                for (j = 0; j < 8; ++j) {
                    b[j] = a[j];
                }
                long t = a[7] + TweetNacl.Sigma1(a[4]) + TweetNacl.Ch(a[4], a[5], a[6]) + K[i] + w[i % 16];
                b[7] = t + TweetNacl.Sigma0(a[0]) + TweetNacl.Maj(a[0], a[1], a[2]);
                b[3] = b[3] + t;
                for (j = 0; j < 8; ++j) {
                    a[(j + 1) % 8] = b[j];
                }
                if (i % 16 != 15) continue;
                for (j = 0; j < 16; ++j) {
                    int n2 = j;
                    w[n2] = w[n2] + (w[(j + 9) % 16] + TweetNacl.sigma0(w[(j + 1) % 16]) + TweetNacl.sigma1(w[(j + 14) % 16]));
                }
            }
            for (i = 0; i < 8; ++i) {
                int n3 = i;
                a[n3] = a[n3] + z[i];
                z[i] = a[i];
            }
            moffset += 128;
            n -= 128;
        }
        for (i = 0; i < 8; ++i) {
            TweetNacl.ts64(x, 8 * i, x.length - 8 * i, z[i]);
        }
        return n;
    }

    public static int crypto_hashblocks(byte[] x, byte[] m, int n) {
        return TweetNacl.crypto_hashblocks(x, m, 0, m.length, n);
    }

    private static int crypto_hash(byte[] out, byte[] m, int moff, int mlen, int n) {
        int i;
        byte[] h = new byte[64];
        byte[] x = new byte[256];
        long b = n;
        for (i = 0; i < 64; ++i) {
            h[i] = iv[i];
        }
        TweetNacl.crypto_hashblocks(h, m, moff, mlen, n);
        n &= 0x7F;
        for (i = 0; i < 256; ++i) {
            x[i] = 0;
        }
        for (i = 0; i < n; ++i) {
            x[i] = m[i + moff];
        }
        x[n] = -128;
        n = 256 - 128 * (n < 112 ? 1 : 0);
        x[n - 9] = (byte)(b >>> 61);
        TweetNacl.ts64(x, n - 8, x.length - (n - 8), b << 3);
        TweetNacl.crypto_hashblocks(h, x, 0, x.length, n);
        for (i = 0; i < 64; ++i) {
            out[i] = h[i];
        }
        return 0;
    }

    public static int crypto_hash(byte[] out, byte[] m, int n) {
        return TweetNacl.crypto_hash(out, m, 0, m.length, n);
    }

    public static int crypto_hash(byte[] out, byte[] m) {
        return TweetNacl.crypto_hash(out, m, m != null ? m.length : 0);
    }

    private static void add(long[][] p, long[][] q) {
        long[] a = new long[16];
        long[] b = new long[16];
        long[] c = new long[16];
        long[] d = new long[16];
        long[] t = new long[16];
        long[] e = new long[16];
        long[] f = new long[16];
        long[] g = new long[16];
        long[] h = new long[16];
        long[] p0 = p[0];
        long[] p1 = p[1];
        long[] p2 = p[2];
        long[] p3 = p[3];
        long[] q0 = q[0];
        long[] q1 = q[1];
        long[] q2 = q[2];
        long[] q3 = q[3];
        TweetNacl.Z(a, 0, a.length, p1, 0, p1.length, p0, 0, p0.length);
        TweetNacl.Z(t, 0, t.length, q1, 0, q1.length, q0, 0, q0.length);
        TweetNacl.M(a, 0, a.length, a, 0, a.length, t, 0, t.length);
        TweetNacl.A(b, 0, b.length, p0, 0, p0.length, p1, 0, p1.length);
        TweetNacl.A(t, 0, t.length, q0, 0, q0.length, q1, 0, q1.length);
        TweetNacl.M(b, 0, b.length, b, 0, b.length, t, 0, t.length);
        TweetNacl.M(c, 0, c.length, p3, 0, p3.length, q3, 0, q3.length);
        TweetNacl.M(c, 0, c.length, c, 0, c.length, D2, 0, D2.length);
        TweetNacl.M(d, 0, d.length, p2, 0, p2.length, q2, 0, q2.length);
        TweetNacl.A(d, 0, d.length, d, 0, d.length, d, 0, d.length);
        TweetNacl.Z(e, 0, e.length, b, 0, b.length, a, 0, a.length);
        TweetNacl.Z(f, 0, f.length, d, 0, d.length, c, 0, c.length);
        TweetNacl.A(g, 0, g.length, d, 0, d.length, c, 0, c.length);
        TweetNacl.A(h, 0, h.length, b, 0, b.length, a, 0, a.length);
        TweetNacl.M(p0, 0, p0.length, e, 0, e.length, f, 0, f.length);
        TweetNacl.M(p1, 0, p1.length, h, 0, h.length, g, 0, g.length);
        TweetNacl.M(p2, 0, p2.length, g, 0, g.length, f, 0, f.length);
        TweetNacl.M(p3, 0, p3.length, e, 0, e.length, h, 0, h.length);
    }

    private static void cswap(long[][] p, long[][] q, byte b) {
        for (int i = 0; i < 4; ++i) {
            TweetNacl.sel25519(p[i], 0, p[i].length, q[i], 0, q[i].length, b);
        }
    }

    private static void pack(byte[] r, long[][] p) {
        long[] tx = new long[16];
        long[] ty = new long[16];
        long[] zi = new long[16];
        TweetNacl.inv25519(zi, 0, zi.length, p[2], 0, p[2].length);
        TweetNacl.M(tx, 0, tx.length, p[0], 0, p[0].length, zi, 0, zi.length);
        TweetNacl.M(ty, 0, ty.length, p[1], 0, p[1].length, zi, 0, zi.length);
        TweetNacl.pack25519(r, ty, 0, ty.length);
        r[31] = (byte)(r[31] ^ TweetNacl.par25519(tx) << 7);
    }

    private static void scalarmult(long[][] p, long[][] q, byte[] s, int soff, int slen) {
        TweetNacl.set25519(p[0], gf0);
        TweetNacl.set25519(p[1], gf1);
        TweetNacl.set25519(p[2], gf1);
        TweetNacl.set25519(p[3], gf0);
        for (int i = 255; i >= 0; --i) {
            byte b = (byte)(s[i / 8 + soff] >> (i & 7) & 1);
            TweetNacl.cswap(p, q, b);
            TweetNacl.add(q, p);
            TweetNacl.add(p, p);
            TweetNacl.cswap(p, q, b);
        }
    }

    private static void scalarbase(long[][] p, byte[] s, int soff, int slen) {
        long[][] q = new long[][]{new long[16], new long[16], new long[16], new long[16]};
        TweetNacl.set25519(q[0], X);
        TweetNacl.set25519(q[1], Y);
        TweetNacl.set25519(q[2], gf1);
        TweetNacl.M(q[3], 0, q[3].length, X, 0, X.length, Y, 0, Y.length);
        TweetNacl.scalarmult(p, q, s, soff, slen);
    }

    public static int crypto_sign_keypair(byte[] pk, byte[] sk, boolean seeded) {
        byte[] d = new byte[64];
        long[][] p = new long[][]{new long[16], new long[16], new long[16], new long[16]};
        if (!seeded) {
            TweetNacl.randombytes(sk, 32);
        }
        TweetNacl.crypto_hash(d, sk, 0, sk.length, 32);
        d[0] = (byte)(d[0] & 0xF8);
        d[31] = (byte)(d[31] & 0x7F);
        d[31] = (byte)(d[31] | 0x40);
        TweetNacl.scalarbase(p, d, 0, d.length);
        TweetNacl.pack(pk, p);
        for (int i = 0; i < 32; ++i) {
            sk[i + 32] = pk[i];
        }
        return 0;
    }

    private static void modL(byte[] r, int roff, int rlen, long[] x) {
        int j;
        long carry;
        int i;
        for (i = 63; i >= 32; --i) {
            carry = 0L;
            j = i - 32;
            while (j < i - 12) {
                int n = j;
                x[n] = x[n] + (carry - 16L * x[i] * L[j - (i - 32)]);
                carry = x[j] + 128L >> 8;
                int n2 = j++;
                x[n2] = x[n2] - (carry << 8);
            }
            int n = j;
            x[n] = x[n] + carry;
            x[i] = 0L;
        }
        carry = 0L;
        j = 0;
        while (j < 32) {
            int n = j;
            x[n] = x[n] + (carry - (x[31] >> 4) * L[j]);
            carry = x[j] >> 8;
            int n3 = j++;
            x[n3] = x[n3] & 0xFFL;
        }
        for (j = 0; j < 32; ++j) {
            int n = j;
            x[n] = x[n] - carry * L[j];
        }
        for (i = 0; i < 32; ++i) {
            int n = i + 1;
            x[n] = x[n] + (x[i] >> 8);
            r[i + roff] = (byte)(x[i] & 0xFFL);
        }
    }

    private static void reduce(byte[] r) {
        int i;
        long[] x = new long[64];
        for (i = 0; i < 64; ++i) {
            x[i] = r[i] & 0xFF;
        }
        for (i = 0; i < 64; ++i) {
            r[i] = 0;
        }
        TweetNacl.modL(r, 0, r.length, x);
    }

    public static int crypto_sign(byte[] sm, long dummy, byte[] m, int n, byte[] sk) {
        int i;
        byte[] d = new byte[64];
        byte[] h = new byte[64];
        byte[] r = new byte[64];
        long[] x = new long[64];
        long[][] p = new long[][]{new long[16], new long[16], new long[16], new long[16]};
        TweetNacl.crypto_hash(d, sk, 0, sk.length, 32);
        d[0] = (byte)(d[0] & 0xF8);
        d[31] = (byte)(d[31] & 0x7F);
        d[31] = (byte)(d[31] | 0x40);
        for (i = 0; i < n; ++i) {
            sm[64 + i] = m[i];
        }
        for (i = 0; i < 32; ++i) {
            sm[32 + i] = d[32 + i];
        }
        TweetNacl.crypto_hash(r, sm, 32, sm.length - 32, n + 32);
        TweetNacl.reduce(r);
        TweetNacl.scalarbase(p, r, 0, r.length);
        TweetNacl.pack(sm, p);
        for (i = 0; i < 32; ++i) {
            sm[i + 32] = sk[i + 32];
        }
        TweetNacl.crypto_hash(h, sm, 0, sm.length, n + 64);
        TweetNacl.reduce(h);
        for (i = 0; i < 64; ++i) {
            x[i] = 0L;
        }
        for (i = 0; i < 32; ++i) {
            x[i] = r[i] & 0xFF;
        }
        for (i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                int n2 = i + j;
                x[n2] = x[n2] + (long)(h[i] & 0xFF) * (long)(d[j] & 0xFF);
            }
        }
        TweetNacl.modL(sm, 32, sm.length - 32, x);
        return 0;
    }

    private static int unpackneg(long[][] r, byte[] p) {
        long[] t = new long[16];
        long[] chk = new long[16];
        long[] num = new long[16];
        long[] den = new long[16];
        long[] den2 = new long[16];
        long[] den4 = new long[16];
        long[] den6 = new long[16];
        TweetNacl.set25519(r[2], gf1);
        TweetNacl.unpack25519(r[1], p);
        TweetNacl.S(num, 0, num.length, r[1], 0, r[1].length);
        TweetNacl.M(den, 0, den.length, num, 0, num.length, D, 0, D.length);
        TweetNacl.Z(num, 0, num.length, num, 0, num.length, r[2], 0, r[2].length);
        TweetNacl.A(den, 0, den.length, r[2], 0, r[2].length, den, 0, den.length);
        TweetNacl.S(den2, 0, den2.length, den, 0, den.length);
        TweetNacl.S(den4, 0, den4.length, den2, 0, den2.length);
        TweetNacl.M(den6, 0, den6.length, den4, 0, den4.length, den2, 0, den2.length);
        TweetNacl.M(t, 0, t.length, den6, 0, den6.length, num, 0, num.length);
        TweetNacl.M(t, 0, t.length, t, 0, t.length, den, 0, den.length);
        TweetNacl.pow2523(t, t);
        TweetNacl.M(t, 0, t.length, t, 0, t.length, num, 0, num.length);
        TweetNacl.M(t, 0, t.length, t, 0, t.length, den, 0, den.length);
        TweetNacl.M(t, 0, t.length, t, 0, t.length, den, 0, den.length);
        TweetNacl.M(r[0], 0, r[0].length, t, 0, t.length, den, 0, den.length);
        TweetNacl.S(chk, 0, chk.length, r[0], 0, r[0].length);
        TweetNacl.M(chk, 0, chk.length, chk, 0, chk.length, den, 0, den.length);
        if (TweetNacl.neq25519(chk, num) != 0) {
            TweetNacl.M(r[0], 0, r[0].length, r[0], 0, r[0].length, I, 0, I.length);
        }
        TweetNacl.S(chk, 0, chk.length, r[0], 0, r[0].length);
        TweetNacl.M(chk, 0, chk.length, chk, 0, chk.length, den, 0, den.length);
        if (TweetNacl.neq25519(chk, num) != 0) {
            return -1;
        }
        if (TweetNacl.par25519(r[0]) == (p[31] & 0xFF) >> 7) {
            TweetNacl.Z(r[0], 0, r[0].length, gf0, 0, gf0.length, r[0], 0, r[0].length);
        }
        TweetNacl.M(r[3], 0, r[3].length, r[0], 0, r[0].length, r[1], 0, r[1].length);
        return 0;
    }

    public static int crypto_sign_open(byte[] m, long dummy, byte[] sm, int n, byte[] pk) {
        int i;
        byte[] t = new byte[32];
        byte[] h = new byte[64];
        long[][] p = new long[][]{new long[16], new long[16], new long[16], new long[16]};
        long[][] q = new long[][]{new long[16], new long[16], new long[16], new long[16]};
        if (n < 64) {
            return -1;
        }
        if (TweetNacl.unpackneg(q, pk) != 0) {
            return -1;
        }
        for (i = 0; i < n; ++i) {
            m[i] = sm[i];
        }
        for (i = 0; i < 32; ++i) {
            m[i + 32] = pk[i];
        }
        TweetNacl.crypto_hash(h, m, 0, m.length, n);
        TweetNacl.reduce(h);
        TweetNacl.scalarmult(p, q, h, 0, h.length);
        TweetNacl.scalarbase(q, sm, 32, sm.length - 32);
        TweetNacl.add(p, q);
        TweetNacl.pack(t, p);
        n -= 64;
        if (TweetNacl.crypto_verify_32(sm, 0, sm.length, t, 0, t.length) != 0) {
            return -1;
        }
        return 0;
    }

    public static void randombytes(byte[] x, int len) {
        long rnd;
        int i;
        int ret = len % 8;
        for (i = 0; i < len - ret; i += 8) {
            rnd = jrandom.nextLong();
            x[i + 0] = (byte)(rnd >>> 0);
            x[i + 1] = (byte)(rnd >>> 8);
            x[i + 2] = (byte)(rnd >>> 16);
            x[i + 3] = (byte)(rnd >>> 24);
            x[i + 4] = (byte)(rnd >>> 32);
            x[i + 5] = (byte)(rnd >>> 40);
            x[i + 6] = (byte)(rnd >>> 48);
            x[i + 7] = (byte)(rnd >>> 56);
        }
        if (ret > 0) {
            rnd = jrandom.nextLong();
            for (i = len - ret; i < len; ++i) {
                x[i] = (byte)(rnd >>> 8 * i);
            }
        }
    }

    static {
        int i;
        _0 = new byte[16];
        _9 = new byte[32];
        for (i = 0; i < _0.length; ++i) {
            TweetNacl._0[i] = 0;
        }
        for (i = 0; i < _9.length; ++i) {
            TweetNacl._9[i] = 0;
        }
        TweetNacl._9[0] = 9;
        gf0 = new long[16];
        gf1 = new long[16];
        _121665 = new long[16];
        for (i = 0; i < gf0.length; ++i) {
            TweetNacl.gf0[i] = 0L;
        }
        for (i = 0; i < gf1.length; ++i) {
            TweetNacl.gf1[i] = 0L;
        }
        TweetNacl.gf1[0] = 1L;
        for (i = 0; i < _121665.length; ++i) {
            TweetNacl._121665[i] = 0L;
        }
        TweetNacl._121665[0] = 56129L;
        TweetNacl._121665[1] = 1L;
        D = new long[]{30883L, 4953L, 19914L, 30187L, 55467L, 16705L, 2637L, 112L, 59544L, 30585L, 16505L, 36039L, 65139L, 11119L, 27886L, 20995L};
        D2 = new long[]{61785L, 9906L, 39828L, 60374L, 45398L, 33411L, 5274L, 224L, 53552L, 61171L, 33010L, 6542L, 64743L, 22239L, 55772L, 9222L};
        X = new long[]{54554L, 36645L, 11616L, 51542L, 42930L, 38181L, 51040L, 26924L, 56412L, 64982L, 57905L, 49316L, 21502L, 52590L, 14035L, 8553L};
        Y = new long[]{26200L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L, 26214L};
        I = new long[]{41136L, 18958L, 6951L, 50414L, 58488L, 44335L, 6150L, 12099L, 55207L, 15867L, 153L, 11085L, 57099L, 20417L, 9344L, 11139L};
        sigma = new byte[]{101, 120, 112, 97, 110, 100, 32, 51, 50, 45, 98, 121, 116, 101, 32, 107};
        K = new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L};
        iv = new byte[]{106, 9, -26, 103, -13, -68, -55, 8, -69, 103, -82, -123, -124, -54, -89, 59, 60, 110, -13, 114, -2, -108, -8, 43, -91, 79, -11, 58, 95, 29, 54, -15, 81, 14, 82, 127, -83, -26, -126, -47, -101, 5, 104, -116, 43, 62, 108, 31, 31, -125, -39, -85, -5, 65, -67, 107, 91, -32, -51, 25, 19, 126, 33, 121};
        L = new long[]{237L, 211L, 245L, 92L, 26L, 99L, 18L, 88L, 214L, 156L, 247L, 162L, 222L, 249L, 222L, 20L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 16L};
        jrandom = new SecureRandom();
    }

    public static final class poly1305 {
        private byte[] buffer = new byte[16];
        private int[] r = new int[10];
        private int[] h = new int[10];
        private int[] pad = new int[8];
        private int leftover = 0;
        private int fin = 0;

        public poly1305(byte[] key) {
            int t0 = key[0] & 0xFF | (key[1] & 0xFF) << 8;
            this.r[0] = t0 & 0x1FFF;
            int t1 = key[2] & 0xFF | (key[3] & 0xFF) << 8;
            this.r[1] = (t0 >>> 13 | t1 << 3) & 0x1FFF;
            int t2 = key[4] & 0xFF | (key[5] & 0xFF) << 8;
            this.r[2] = (t1 >>> 10 | t2 << 6) & 0x1F03;
            int t3 = key[6] & 0xFF | (key[7] & 0xFF) << 8;
            this.r[3] = (t2 >>> 7 | t3 << 9) & 0x1FFF;
            int t4 = key[8] & 0xFF | (key[9] & 0xFF) << 8;
            this.r[4] = (t3 >>> 4 | t4 << 12) & 0xFF;
            this.r[5] = t4 >>> 1 & 0x1FFE;
            int t5 = key[10] & 0xFF | (key[11] & 0xFF) << 8;
            this.r[6] = (t4 >>> 14 | t5 << 2) & 0x1FFF;
            int t6 = key[12] & 0xFF | (key[13] & 0xFF) << 8;
            this.r[7] = (t5 >>> 11 | t6 << 5) & 0x1F81;
            int t7 = key[14] & 0xFF | (key[15] & 0xFF) << 8;
            this.r[8] = (t6 >>> 8 | t7 << 8) & 0x1FFF;
            this.r[9] = t7 >>> 5 & 0x7F;
            this.pad[0] = key[16] & 0xFF | (key[17] & 0xFF) << 8;
            this.pad[1] = key[18] & 0xFF | (key[19] & 0xFF) << 8;
            this.pad[2] = key[20] & 0xFF | (key[21] & 0xFF) << 8;
            this.pad[3] = key[22] & 0xFF | (key[23] & 0xFF) << 8;
            this.pad[4] = key[24] & 0xFF | (key[25] & 0xFF) << 8;
            this.pad[5] = key[26] & 0xFF | (key[27] & 0xFF) << 8;
            this.pad[6] = key[28] & 0xFF | (key[29] & 0xFF) << 8;
            this.pad[7] = key[30] & 0xFF | (key[31] & 0xFF) << 8;
        }

        public poly1305 blocks(byte[] m, int mpos, int bytes) {
            int hibit = this.fin != 0 ? 0 : 2048;
            int h0 = this.h[0];
            int h1 = this.h[1];
            int h2 = this.h[2];
            int h3 = this.h[3];
            int h4 = this.h[4];
            int h5 = this.h[5];
            int h6 = this.h[6];
            int h7 = this.h[7];
            int h8 = this.h[8];
            int h9 = this.h[9];
            int r0 = this.r[0];
            int r1 = this.r[1];
            int r2 = this.r[2];
            int r3 = this.r[3];
            int r4 = this.r[4];
            int r5 = this.r[5];
            int r6 = this.r[6];
            int r7 = this.r[7];
            int r8 = this.r[8];
            int r9 = this.r[9];
            while (bytes >= 16) {
                int c;
                int t0 = m[mpos + 0] & 0xFF | (m[mpos + 1] & 0xFF) << 8;
                h0 += t0 & 0x1FFF;
                int t1 = m[mpos + 2] & 0xFF | (m[mpos + 3] & 0xFF) << 8;
                h1 += (t0 >>> 13 | t1 << 3) & 0x1FFF;
                int t2 = m[mpos + 4] & 0xFF | (m[mpos + 5] & 0xFF) << 8;
                h2 += (t1 >>> 10 | t2 << 6) & 0x1FFF;
                int t3 = m[mpos + 6] & 0xFF | (m[mpos + 7] & 0xFF) << 8;
                h3 += (t2 >>> 7 | t3 << 9) & 0x1FFF;
                int t4 = m[mpos + 8] & 0xFF | (m[mpos + 9] & 0xFF) << 8;
                h4 += (t3 >>> 4 | t4 << 12) & 0x1FFF;
                h5 += t4 >>> 1 & 0x1FFF;
                int t5 = m[mpos + 10] & 0xFF | (m[mpos + 11] & 0xFF) << 8;
                h6 += (t4 >>> 14 | t5 << 2) & 0x1FFF;
                int t6 = m[mpos + 12] & 0xFF | (m[mpos + 13] & 0xFF) << 8;
                h7 += (t5 >>> 11 | t6 << 5) & 0x1FFF;
                int t7 = m[mpos + 14] & 0xFF | (m[mpos + 15] & 0xFF) << 8;
                h8 += (t6 >>> 8 | t7 << 8) & 0x1FFF;
                h9 += t7 >>> 5 | hibit;
                int d0 = c = 0;
                d0 += h0 * r0;
                d0 += h1 * (5 * r9);
                d0 += h2 * (5 * r8);
                d0 += h3 * (5 * r7);
                c = (d0 += h4 * (5 * r6)) >>> 13;
                d0 &= 0x1FFF;
                d0 += h5 * (5 * r5);
                d0 += h6 * (5 * r4);
                d0 += h7 * (5 * r3);
                d0 += h8 * (5 * r2);
                d0 &= 0x1FFF;
                int d1 = c += (d0 += h9 * (5 * r1)) >>> 13;
                d1 += h0 * r1;
                d1 += h1 * r0;
                d1 += h2 * (5 * r9);
                d1 += h3 * (5 * r8);
                c = (d1 += h4 * (5 * r7)) >>> 13;
                d1 &= 0x1FFF;
                d1 += h5 * (5 * r6);
                d1 += h6 * (5 * r5);
                d1 += h7 * (5 * r4);
                d1 += h8 * (5 * r3);
                d1 &= 0x1FFF;
                int d2 = c += (d1 += h9 * (5 * r2)) >>> 13;
                d2 += h0 * r2;
                d2 += h1 * r1;
                d2 += h2 * r0;
                d2 += h3 * (5 * r9);
                c = (d2 += h4 * (5 * r8)) >>> 13;
                d2 &= 0x1FFF;
                d2 += h5 * (5 * r7);
                d2 += h6 * (5 * r6);
                d2 += h7 * (5 * r5);
                d2 += h8 * (5 * r4);
                d2 &= 0x1FFF;
                int d3 = c += (d2 += h9 * (5 * r3)) >>> 13;
                d3 += h0 * r3;
                d3 += h1 * r2;
                d3 += h2 * r1;
                d3 += h3 * r0;
                c = (d3 += h4 * (5 * r9)) >>> 13;
                d3 &= 0x1FFF;
                d3 += h5 * (5 * r8);
                d3 += h6 * (5 * r7);
                d3 += h7 * (5 * r6);
                d3 += h8 * (5 * r5);
                d3 &= 0x1FFF;
                int d4 = c += (d3 += h9 * (5 * r4)) >>> 13;
                d4 += h0 * r4;
                d4 += h1 * r3;
                d4 += h2 * r2;
                d4 += h3 * r1;
                c = (d4 += h4 * r0) >>> 13;
                d4 &= 0x1FFF;
                d4 += h5 * (5 * r9);
                d4 += h6 * (5 * r8);
                d4 += h7 * (5 * r7);
                d4 += h8 * (5 * r6);
                d4 &= 0x1FFF;
                int d5 = c += (d4 += h9 * (5 * r5)) >>> 13;
                d5 += h0 * r5;
                d5 += h1 * r4;
                d5 += h2 * r3;
                d5 += h3 * r2;
                c = (d5 += h4 * r1) >>> 13;
                d5 &= 0x1FFF;
                d5 += h5 * r0;
                d5 += h6 * (5 * r9);
                d5 += h7 * (5 * r8);
                d5 += h8 * (5 * r7);
                d5 &= 0x1FFF;
                int d6 = c += (d5 += h9 * (5 * r6)) >>> 13;
                d6 += h0 * r6;
                d6 += h1 * r5;
                d6 += h2 * r4;
                d6 += h3 * r3;
                c = (d6 += h4 * r2) >>> 13;
                d6 &= 0x1FFF;
                d6 += h5 * r1;
                d6 += h6 * r0;
                d6 += h7 * (5 * r9);
                d6 += h8 * (5 * r8);
                d6 &= 0x1FFF;
                int d7 = c += (d6 += h9 * (5 * r7)) >>> 13;
                d7 += h0 * r7;
                d7 += h1 * r6;
                d7 += h2 * r5;
                d7 += h3 * r4;
                c = (d7 += h4 * r3) >>> 13;
                d7 &= 0x1FFF;
                d7 += h5 * r2;
                d7 += h6 * r1;
                d7 += h7 * r0;
                d7 += h8 * (5 * r9);
                d7 &= 0x1FFF;
                int d8 = c += (d7 += h9 * (5 * r8)) >>> 13;
                d8 += h0 * r8;
                d8 += h1 * r7;
                d8 += h2 * r6;
                d8 += h3 * r5;
                c = (d8 += h4 * r4) >>> 13;
                d8 &= 0x1FFF;
                d8 += h5 * r3;
                d8 += h6 * r2;
                d8 += h7 * r1;
                d8 += h8 * r0;
                d8 &= 0x1FFF;
                int d9 = c += (d8 += h9 * (5 * r9)) >>> 13;
                d9 += h0 * r9;
                d9 += h1 * r8;
                d9 += h2 * r7;
                d9 += h3 * r6;
                c = (d9 += h4 * r5) >>> 13;
                d9 &= 0x1FFF;
                d9 += h5 * r4;
                d9 += h6 * r3;
                d9 += h7 * r2;
                d9 += h8 * r1;
                c += (d9 += h9 * r0) >>> 13;
                d9 &= 0x1FFF;
                c = (c << 2) + c | 0;
                c = c + d0 | 0;
                d0 = c & 0x1FFF;
                h0 = d0;
                h1 = d1 += (c >>>= 13);
                h2 = d2;
                h3 = d3;
                h4 = d4;
                h5 = d5;
                h6 = d6;
                h7 = d7;
                h8 = d8;
                h9 = d9;
                mpos += 16;
                bytes -= 16;
            }
            this.h[0] = h0;
            this.h[1] = h1;
            this.h[2] = h2;
            this.h[3] = h3;
            this.h[4] = h4;
            this.h[5] = h5;
            this.h[6] = h6;
            this.h[7] = h7;
            this.h[8] = h8;
            this.h[9] = h9;
            return this;
        }

        public poly1305 finish(byte[] mac, int macpos) {
            int i;
            int[] g = new int[10];
            if (this.leftover != 0) {
                i = this.leftover;
                this.buffer[i++] = 1;
                while (i < 16) {
                    this.buffer[i] = 0;
                    ++i;
                }
                this.fin = 1;
                this.blocks(this.buffer, 0, 16);
            }
            int c = this.h[1] >>> 13;
            this.h[1] = this.h[1] & 0x1FFF;
            i = 2;
            while (i < 10) {
                int n = i;
                this.h[n] = this.h[n] + c;
                c = this.h[i] >>> 13;
                int n2 = i++;
                this.h[n2] = this.h[n2] & 0x1FFF;
            }
            this.h[0] = this.h[0] + c * 5;
            c = this.h[0] >>> 13;
            this.h[0] = this.h[0] & 0x1FFF;
            this.h[1] = this.h[1] + c;
            c = this.h[1] >>> 13;
            this.h[1] = this.h[1] & 0x1FFF;
            this.h[2] = this.h[2] + c;
            g[0] = this.h[0] + 5;
            c = g[0] >>> 13;
            g[0] = g[0] & 0x1FFF;
            i = 1;
            while (i < 10) {
                g[i] = this.h[i] + c;
                c = g[i] >>> 13;
                int n = i++;
                g[n] = g[n] & 0x1FFF;
            }
            g[9] = g[9] - 8192;
            g[9] = g[9] & 0xFFFF;
            int mask = (g[9] >>> 15) - 1;
            mask &= 0xFFFF;
            i = 0;
            while (i < 10) {
                int n = i++;
                g[n] = g[n] & mask;
            }
            mask ^= 0xFFFFFFFF;
            for (i = 0; i < 10; ++i) {
                this.h[i] = this.h[i] & mask | g[i];
            }
            this.h[0] = (this.h[0] | this.h[1] << 13) & 0xFFFF;
            this.h[1] = (this.h[1] >>> 3 | this.h[2] << 10) & 0xFFFF;
            this.h[2] = (this.h[2] >>> 6 | this.h[3] << 7) & 0xFFFF;
            this.h[3] = (this.h[3] >>> 9 | this.h[4] << 4) & 0xFFFF;
            this.h[4] = (this.h[4] >>> 12 | this.h[5] << 1 | this.h[6] << 14) & 0xFFFF;
            this.h[5] = (this.h[6] >>> 2 | this.h[7] << 11) & 0xFFFF;
            this.h[6] = (this.h[7] >>> 5 | this.h[8] << 8) & 0xFFFF;
            this.h[7] = (this.h[8] >>> 8 | this.h[9] << 5) & 0xFFFF;
            int f = this.h[0] + this.pad[0];
            this.h[0] = f & 0xFFFF;
            for (i = 1; i < 8; ++i) {
                f = (this.h[i] + this.pad[i] | 0) + (f >>> 16) | 0;
                this.h[i] = f & 0xFFFF;
            }
            mac[macpos + 0] = (byte)(this.h[0] >>> 0 & 0xFF);
            mac[macpos + 1] = (byte)(this.h[0] >>> 8 & 0xFF);
            mac[macpos + 2] = (byte)(this.h[1] >>> 0 & 0xFF);
            mac[macpos + 3] = (byte)(this.h[1] >>> 8 & 0xFF);
            mac[macpos + 4] = (byte)(this.h[2] >>> 0 & 0xFF);
            mac[macpos + 5] = (byte)(this.h[2] >>> 8 & 0xFF);
            mac[macpos + 6] = (byte)(this.h[3] >>> 0 & 0xFF);
            mac[macpos + 7] = (byte)(this.h[3] >>> 8 & 0xFF);
            mac[macpos + 8] = (byte)(this.h[4] >>> 0 & 0xFF);
            mac[macpos + 9] = (byte)(this.h[4] >>> 8 & 0xFF);
            mac[macpos + 10] = (byte)(this.h[5] >>> 0 & 0xFF);
            mac[macpos + 11] = (byte)(this.h[5] >>> 8 & 0xFF);
            mac[macpos + 12] = (byte)(this.h[6] >>> 0 & 0xFF);
            mac[macpos + 13] = (byte)(this.h[6] >>> 8 & 0xFF);
            mac[macpos + 14] = (byte)(this.h[7] >>> 0 & 0xFF);
            mac[macpos + 15] = (byte)(this.h[7] >>> 8 & 0xFF);
            return this;
        }

        public poly1305 update(byte[] m, int mpos, int bytes) {
            int i;
            int want;
            if (this.leftover != 0) {
                want = 16 - this.leftover;
                if (want > bytes) {
                    want = bytes;
                }
                for (i = 0; i < want; ++i) {
                    this.buffer[this.leftover + i] = m[mpos + i];
                }
                bytes -= want;
                mpos += want;
                this.leftover += want;
                if (this.leftover < 16) {
                    return this;
                }
                this.blocks(this.buffer, 0, 16);
                this.leftover = 0;
            }
            if (bytes >= 16) {
                want = bytes - bytes % 16;
                this.blocks(m, mpos, want);
                mpos += want;
                bytes -= want;
            }
            if (bytes != 0) {
                for (i = 0; i < bytes; ++i) {
                    this.buffer[this.leftover + i] = m[mpos + i];
                }
                this.leftover += bytes;
            }
            return this;
        }
    }

    public static final class Signature {
        private static final String TAG = "Signature";
        private byte[] theirPublicKey;
        private byte[] mySecretKey;
        public static final int publicKeyLength = 32;
        public static final int secretKeyLength = 64;
        public static final int seedLength = 32;
        public static final int signatureLength = 64;

        public Signature(byte[] theirPublicKey, byte[] mySecretKey) {
            this.theirPublicKey = theirPublicKey;
            this.mySecretKey = mySecretKey;
        }

        public byte[] sign(byte[] message) {
            byte[] sm = new byte[message.length + 64];
            TweetNacl.crypto_sign(sm, -1L, message, message.length, this.mySecretKey);
            return sm;
        }

        public byte[] open(byte[] signedMessage) {
            if (signedMessage == null || signedMessage.length <= 64) {
                return null;
            }
            byte[] tmp = new byte[signedMessage.length];
            if (0 != TweetNacl.crypto_sign_open(tmp, -1L, signedMessage, signedMessage.length, this.theirPublicKey)) {
                return null;
            }
            byte[] msg = new byte[signedMessage.length - 64];
            for (int i = 0; i < msg.length; ++i) {
                msg[i] = signedMessage[i + 64];
            }
            return msg;
        }

        public byte[] detached(byte[] message) {
            byte[] signedMsg = this.sign(message);
            byte[] sig = new byte[64];
            for (int i = 0; i < sig.length; ++i) {
                sig[i] = signedMsg[i];
            }
            return sig;
        }

        public boolean detached_verify(byte[] message, byte[] signature) {
            int i;
            if (signature.length != 64) {
                return false;
            }
            if (this.theirPublicKey.length != 32) {
                return false;
            }
            byte[] sm = new byte[64 + message.length];
            byte[] m = new byte[64 + message.length];
            for (i = 0; i < 64; ++i) {
                sm[i] = signature[i];
            }
            for (i = 0; i < message.length; ++i) {
                sm[i + 64] = message[i];
            }
            return TweetNacl.crypto_sign_open(m, -1L, sm, sm.length, this.theirPublicKey) >= 0;
        }

        public static KeyPair keyPair() {
            KeyPair kp = new KeyPair();
            TweetNacl.crypto_sign_keypair(kp.getPublicKey(), kp.getSecretKey(), false);
            return kp;
        }

        public static KeyPair keyPair_fromSecretKey(byte[] secretKey) {
            int i;
            KeyPair kp = new KeyPair();
            byte[] pk = kp.getPublicKey();
            byte[] sk = kp.getSecretKey();
            for (i = 0; i < kp.getSecretKey().length; ++i) {
                sk[i] = secretKey[i];
            }
            for (i = 0; i < kp.getPublicKey().length; ++i) {
                pk[i] = secretKey[32 + i];
            }
            return kp;
        }

        public static KeyPair keyPair_fromSeed(byte[] seed) {
            KeyPair kp = new KeyPair();
            byte[] pk = kp.getPublicKey();
            byte[] sk = kp.getSecretKey();
            for (int i = 0; i < 32; ++i) {
                sk[i] = seed[i];
            }
            TweetNacl.crypto_sign_keypair(pk, sk, true);
            return kp;
        }

        public static class KeyPair {
            private byte[] publicKey = new byte[32];
            private byte[] secretKey = new byte[64];

            public byte[] getPublicKey() {
                return this.publicKey;
            }

            public byte[] getSecretKey() {
                return this.secretKey;
            }
        }
    }

    public static final class Hash {
        private static final String TAG = "Hash";
        public static final int hashLength = 64;

        public static byte[] sha512(byte[] message) {
            if (message == null || message.length <= 0) {
                return null;
            }
            byte[] out = new byte[64];
            TweetNacl.crypto_hash(out, message);
            return out;
        }

        public static byte[] sha512(String message) throws UnsupportedEncodingException {
            return Hash.sha512(message.getBytes("utf-8"));
        }
    }

    public static final class ScalarMult {
        private static final String TAG = "ScalarMult";
        public static final int scalarLength = 32;
        public static final int groupElementLength = 32;

        public static byte[] scalseMult(byte[] n, byte[] p) {
            if (n.length != 32 || p.length != 32) {
                return null;
            }
            byte[] q = new byte[32];
            TweetNacl.crypto_scalarmult(q, n, p);
            return q;
        }

        public static byte[] scalseMult_base(byte[] n) {
            if (n.length != 32) {
                return null;
            }
            byte[] q = new byte[32];
            TweetNacl.crypto_scalarmult_base(q, n);
            return q;
        }
    }

    public static final class SecretBox {
        private static final String TAG = "SecretBox";
        private AtomicLong nonce;
        private byte[] key;
        public static final int keyLength = 32;
        public static final int nonceLength = 24;
        public static final int overheadLength = 16;
        public static final int zerobytesLength = 32;
        public static final int boxzerobytesLength = 16;

        public SecretBox(byte[] key) {
            this(key, 68L);
        }

        public SecretBox(byte[] key, long nonce) {
            this.key = key;
            this.nonce = new AtomicLong(nonce);
        }

        public void setNonce(long nonce) {
            this.nonce.set(nonce);
        }

        public long getNonce() {
            return this.nonce.get();
        }

        public long incrNonce() {
            return this.nonce.incrementAndGet();
        }

        private byte[] generateNonce() {
            long nonce = this.nonce.get();
            byte[] n = new byte[24];
            for (int i = 0; i < 24; i += 8) {
                n[i + 0] = (byte)(nonce >>> 0);
                n[i + 1] = (byte)(nonce >>> 8);
                n[i + 2] = (byte)(nonce >>> 16);
                n[i + 3] = (byte)(nonce >>> 24);
                n[i + 4] = (byte)(nonce >>> 32);
                n[i + 5] = (byte)(nonce >>> 40);
                n[i + 6] = (byte)(nonce >>> 48);
                n[i + 7] = (byte)(nonce >>> 56);
            }
            return n;
        }

        public byte[] box(byte[] message) {
            return this.box(message, this.generateNonce());
        }

        public byte[] box(byte[] message, byte[] theNonce) {
            if (message == null || message.length <= 0 || theNonce == null || theNonce.length != 24) {
                return null;
            }
            byte[] m = new byte[message.length + 32];
            byte[] c = new byte[m.length];
            for (int i = 0; i < message.length; ++i) {
                m[i + 32] = message[i];
            }
            if (0 != TweetNacl.crypto_secretbox(c, m, m.length, theNonce, this.key)) {
                return null;
            }
            byte[] ret = new byte[c.length - 16];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = c[i + 16];
            }
            return ret;
        }

        public byte[] open(byte[] box) {
            return this.open(box, this.generateNonce());
        }

        public byte[] open(byte[] box, byte[] theNonce) {
            if (box == null || box.length <= 16 || theNonce == null || theNonce.length != 24) {
                return null;
            }
            byte[] c = new byte[box.length + 16];
            byte[] m = new byte[c.length];
            for (int i = 0; i < box.length; ++i) {
                c[i + 16] = box[i];
            }
            if (0 != TweetNacl.crypto_secretbox_open(m, c, c.length, theNonce, this.key)) {
                return null;
            }
            byte[] ret = new byte[m.length - 32];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = m[i + 32];
            }
            return ret;
        }
    }

    public static final class Box {
        private static final String TAG = "Box";
        private AtomicLong nonce;
        private byte[] theirPublicKey;
        private byte[] mySecretKey;
        private byte[] sharedKey;
        public static final int publicKeyLength = 32;
        public static final int secretKeyLength = 32;
        public static final int sharedKeyLength = 32;
        public static final int nonceLength = 24;
        public static final int zerobytesLength = 32;
        public static final int boxzerobytesLength = 16;
        public static final int overheadLength = 16;

        public Box(byte[] theirPublicKey, byte[] mySecretKey) {
            this(theirPublicKey, mySecretKey, 68L);
        }

        public Box(byte[] theirPublicKey, byte[] mySecretKey, long nonce) {
            this.theirPublicKey = theirPublicKey;
            this.mySecretKey = mySecretKey;
            this.nonce = new AtomicLong(nonce);
            this.before();
        }

        public void setNonce(long nonce) {
            this.nonce.set(nonce);
        }

        public long getNonce() {
            return this.nonce.get();
        }

        public long incrNonce() {
            return this.nonce.incrementAndGet();
        }

        private byte[] generateNonce() {
            long nonce = this.nonce.get();
            byte[] n = new byte[24];
            for (int i = 0; i < 24; i += 8) {
                n[i + 0] = (byte)(nonce >>> 0);
                n[i + 1] = (byte)(nonce >>> 8);
                n[i + 2] = (byte)(nonce >>> 16);
                n[i + 3] = (byte)(nonce >>> 24);
                n[i + 4] = (byte)(nonce >>> 32);
                n[i + 5] = (byte)(nonce >>> 40);
                n[i + 6] = (byte)(nonce >>> 48);
                n[i + 7] = (byte)(nonce >>> 56);
            }
            return n;
        }

        public byte[] box(byte[] message) {
            return this.box(message, this.generateNonce());
        }

        public byte[] box(byte[] message, byte[] theNonce) {
            if (message == null || message.length <= 0 || theNonce == null || theNonce.length != 24) {
                return null;
            }
            byte[] m = new byte[message.length + 32];
            byte[] c = new byte[m.length];
            for (int i = 0; i < message.length; ++i) {
                m[i + 32] = message[i];
            }
            if (0 != TweetNacl.crypto_box(c, m, m.length, theNonce, this.theirPublicKey, this.mySecretKey)) {
                return null;
            }
            byte[] ret = new byte[c.length - 16];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = c[i + 16];
            }
            return ret;
        }

        public byte[] open(byte[] box) {
            return this.open(box, this.generateNonce());
        }

        public byte[] open(byte[] box, byte[] theNonce) {
            if (box == null || box.length <= 16 || theNonce == null || theNonce.length != 24) {
                return null;
            }
            byte[] c = new byte[box.length + 16];
            byte[] m = new byte[c.length];
            for (int i = 0; i < box.length; ++i) {
                c[i + 16] = box[i];
            }
            if (0 != TweetNacl.crypto_box_open(m, c, c.length, theNonce, this.theirPublicKey, this.mySecretKey)) {
                return null;
            }
            byte[] ret = new byte[m.length - 32];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = m[i + 32];
            }
            return ret;
        }

        public byte[] before() {
            if (this.sharedKey == null) {
                this.sharedKey = new byte[32];
                TweetNacl.crypto_box_beforenm(this.sharedKey, this.theirPublicKey, this.mySecretKey);
            }
            return this.sharedKey;
        }

        public byte[] after(byte[] message) {
            return this.after(message, this.generateNonce());
        }

        public byte[] after(byte[] message, byte[] theNonce) {
            if (message == null || message.length <= 0 || theNonce == null || theNonce.length != 24) {
                return null;
            }
            byte[] m = new byte[message.length + 32];
            byte[] c = new byte[m.length];
            for (int i = 0; i < message.length; ++i) {
                m[i + 32] = message[i];
            }
            if (0 != TweetNacl.crypto_box_afternm(c, m, m.length, theNonce, this.sharedKey)) {
                return null;
            }
            byte[] ret = new byte[c.length - 16];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = c[i + 16];
            }
            return ret;
        }

        public byte[] open_after(byte[] box) {
            return this.open_after(box, this.generateNonce());
        }

        public byte[] open_after(byte[] box, byte[] theNonce) {
            if (box == null || box.length <= 16 || theNonce == null || theNonce.length != 24) {
                return null;
            }
            byte[] c = new byte[box.length + 16];
            byte[] m = new byte[c.length];
            for (int i = 0; i < box.length; ++i) {
                c[i + 16] = box[i];
            }
            if (TweetNacl.crypto_box_open_afternm(m, c, c.length, theNonce, this.sharedKey) != 0) {
                return null;
            }
            byte[] ret = new byte[m.length - 32];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = m[i + 32];
            }
            return ret;
        }

        public static KeyPair keyPair() {
            KeyPair kp = new KeyPair();
            TweetNacl.crypto_box_keypair(kp.getPublicKey(), kp.getSecretKey());
            return kp;
        }

        public static KeyPair keyPair_fromSecretKey(byte[] secretKey) {
            KeyPair kp = new KeyPair();
            byte[] sk = kp.getSecretKey();
            byte[] pk = kp.getPublicKey();
            for (int i = 0; i < sk.length; ++i) {
                sk[i] = secretKey[i];
            }
            TweetNacl.crypto_scalarmult_base(pk, sk);
            return kp;
        }

        public static class KeyPair {
            private byte[] publicKey = new byte[32];
            private byte[] secretKey = new byte[32];

            public byte[] getPublicKey() {
                return this.publicKey;
            }

            public byte[] getSecretKey() {
                return this.secretKey;
            }
        }
    }
}

