/*
 * Decompiled with CFR 0.152.
 */
package org.softee.management;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.xml.datatype.XMLGregorianCalendar;
import org.softee.management.AbstractMBean;
import org.softee.management.annotation.Description;
import org.softee.management.annotation.MBean;
import org.softee.management.annotation.ManagedAttribute;
import org.softee.management.annotation.ManagedOperation;
import org.softee.management.exception.ManagementException;

@MBean(objectName="org.softee:type=org.softee.MessagingMBean,name=Default")
@Description(value="Generic MBean for monitoring input/output processing")
public class MessagingMBean
extends AbstractMBean {
    private AtomicLong inputCount;
    private AtomicLong inputLatest;
    private AtomicLong outputCount;
    private AtomicLong outputLatest;
    private AtomicLong durationLastMillis;
    private AtomicLong durationTotalMillis;
    private AtomicLong durationMaxMillis;
    private AtomicLong durationMinMillis;
    private AtomicLong failedCount;
    private AtomicLong failedLatest;
    private Throwable failedLatestCause;

    public MessagingMBean() throws MalformedObjectNameException {
    }

    public MessagingMBean(String name) throws MalformedObjectNameException {
        super(name);
    }

    public MessagingMBean(ObjectName objectName) {
        super(objectName);
    }

    public synchronized void notifyInput() {
        this.inputCount.incrementAndGet();
        this.inputLatest.set(this.now());
    }

    public synchronized void notifyOutput() {
        long latest = this.inputLatest.get();
        if (latest == Long.MIN_VALUE) {
            this.notifyOutput(-1L);
        } else {
            this.notifyOutput(this.now() - latest);
        }
    }

    public synchronized void notifyOutput(long durationMillis) {
        this.outputLatest.set(this.now());
        this.outputCount.incrementAndGet();
        if (durationMillis >= 0L) {
            Long maxMillis;
            this.durationLastMillis.set(durationMillis);
            this.durationTotalMillis.addAndGet(durationMillis);
            Long minMillis = this.getDurationMinMillis();
            if (minMillis == null || minMillis != null && durationMillis < minMillis) {
                this.durationMinMillis.set(durationMillis);
            }
            if ((maxMillis = this.getDurationMaxMillis()) == null || durationMillis > maxMillis) {
                this.durationMaxMillis.set(durationMillis);
            }
        }
    }

    public synchronized void notifyFailed() {
        this.notifyFailed(null);
    }

    public synchronized void notifyFailed(Throwable cause) {
        this.failedCount.incrementAndGet();
        this.failedLatest.set(this.now());
        this.failedLatestCause = cause;
    }

    public void reregisterMonitor() throws ManagementException {
        this.registration.unregister();
        this.registration.register();
    }

    @ManagedOperation(value=ManagedOperation.Impact.ACTION)
    @Description(value="Reset this MBean's metrics")
    public synchronized void resetMBean() {
        super.resetMBean();
        this.inputLatest = this.none();
        this.outputLatest = this.none();
        this.failedLatest = this.none();
        this.inputCount = this.zero();
        this.outputCount = this.zero();
        this.failedCount = this.zero();
        this.durationLastMillis = this.none();
        this.durationMinMillis = this.none();
        this.durationMaxMillis = this.none();
        this.durationTotalMillis = this.zero();
    }

    @ManagedAttribute
    @Description(value="Number of messages received")
    public long getInputCount() {
        return this.inputCount.get();
    }

    @ManagedAttribute
    @Description(value="Time of last received message")
    public XMLGregorianCalendar getInputLatest() {
        return this.date(this.noneAsNull(this.inputLatest));
    }

    @ManagedAttribute
    @Description(value="Time since latest received message (seconds)")
    public Long getInputLatestAgeSeconds() {
        return this.age(this.noneAsNull(this.inputLatest), TimeUnit.SECONDS);
    }

    @ManagedAttribute
    @Description(value="Number of processed messages")
    public long getOutputCount() {
        return this.outputCount.get();
    }

    @ManagedAttribute
    @Description(value="Time of the latest processed message")
    public XMLGregorianCalendar getOutputLatest() {
        return this.date(this.noneAsNull(this.outputLatest));
    }

    @ManagedAttribute
    @Description(value="Time since latest processed message (seconds)")
    public Long getOutputLatestAgeSeconds() {
        return this.age(this.noneAsNull(this.outputLatest), TimeUnit.SECONDS);
    }

    @ManagedAttribute
    @Description(value="Processing time of the latest message (ms)")
    public Long getDurationLatestMillis() {
        return this.noneAsNull(this.durationLastMillis);
    }

    @ManagedAttribute
    @Description(value="Total processing time of all messages (ms)")
    public long getDurationTotalMillis() {
        return this.durationTotalMillis.get();
    }

    @ManagedAttribute
    @Description(value="Average processing time (ms)")
    public Long getDurationAverageMillis() {
        long processedDurationTotalMillis = this.getDurationTotalMillis();
        long processedCount = this.getOutputCount();
        return processedCount != 0L ? Long.valueOf(processedDurationTotalMillis / processedCount) : null;
    }

    @ManagedAttribute
    @Description(value="Min processing time (ms)")
    public Long getDurationMinMillis() {
        return this.noneAsNull(this.durationMinMillis);
    }

    @ManagedAttribute
    @Description(value="Max processing time (ms)")
    public Long getDurationMaxMillis() {
        return this.noneAsNull(this.durationMaxMillis);
    }

    @ManagedAttribute
    @Description(value="Number of processes that failed")
    public long getFailedCount() {
        return this.failedCount.get();
    }

    @ManagedAttribute
    @Description(value="Time of the latest failed message processing")
    public XMLGregorianCalendar getFailedLatest() {
        return this.date(this.noneAsNull(this.failedLatest));
    }

    @ManagedAttribute
    @Description(value="Time since latest failed message processing (seconds)")
    public Long getFailedLatestAgeSeconds() {
        return this.age(this.noneAsNull(this.failedLatest), TimeUnit.SECONDS);
    }

    @ManagedAttribute
    @Description(value="The failure reason of the latest failed message processing")
    public String getFailedLatestReason() {
        if (this.failedLatestCause == null) {
            return null;
        }
        return this.failedLatestCause.toString();
    }

    @ManagedAttribute
    @Description(value="The failure stacktrace of the latest failed message processing (one line per element)")
    public String[] getFailedLatestStacktrace() {
        if (this.failedLatestCause == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        this.failedLatestCause.printStackTrace(new PrintWriter(sw));
        ArrayList<String> lines = new ArrayList<String>(1000);
        BufferedReader reader = new BufferedReader(new StringReader(sw.toString()));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return lines.toArray(new String[lines.size()]);
    }
}

