/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.repository.fs.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import org.smartparam.repository.fs.exception.ResourceResolverException;

public final class StreamReaderOpener {
    private StreamReaderOpener() {
    }

    public static BufferedReader openReaderForFile(String filePath, Charset charset) {
        try {
            File file = new File(filePath);
            return Files.newBufferedReader(file.toPath(), charset);
        }
        catch (IOException exception) {
            throw new ResourceResolverException("Unable to open reader stream to file " + filePath, exception);
        }
    }

    public static BufferedReader openReaderForResource(Class<?> classloaderClass, String classpathResourceName) {
        InputStream stream = classloaderClass.getResourceAsStream(classpathResourceName);
        if (stream == null) {
            throw new ResourceResolverException("No resource " + classpathResourceName + " found in classpath.");
        }
        return new BufferedReader(new InputStreamReader(stream));
    }
}

