/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.repository.fs.resolver;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.parameter.Parameter;
import org.smartparam.serializer.ParamDeserializer;
import org.smartparam.serializer.exception.ParamSerializationException;

public class ParameterFileVisitor
extends SimpleFileVisitor<Path> {
    private static final Logger logger = LoggerFactory.getLogger(ParameterFileVisitor.class);
    private final ParamDeserializer deserializer;
    private final Pattern filePattern;
    private final Map<String, String> parameters = new HashMap<String, String>();

    public ParameterFileVisitor(String filePattern, ParamDeserializer deserializer) {
        this.filePattern = Pattern.compile(filePattern);
        this.deserializer = deserializer;
    }

    public void clearOldResults() {
        this.parameters.clear();
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        String fileName = file.toFile().getCanonicalPath();
        if (!this.filePattern.matcher(fileName).matches()) {
            logger.debug("discarding file {}, does not match filtering pattern: {}", (Object)fileName, (Object)this.filePattern);
            return FileVisitResult.CONTINUE;
        }
        BufferedReader reader = null;
        try {
            reader = Files.newBufferedReader(file, this.deserializer.getSerializationConfig().getCharset());
            Parameter parameter = this.deserializer.deserializeMetadata(reader);
            this.parameters.put(parameter.getName(), fileName);
            logger.debug("found parameter {} in file {}", (Object)parameter.getName(), (Object)fileName);
        }
        catch (ParamSerializationException exception) {
            throw new IOException(exception);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return FileVisitResult.CONTINUE;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }
}

