/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.repository.fs.resolver;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.parameter.Parameter;
import org.smartparam.engine.core.parameter.ParameterBatchLoader;
import org.smartparam.engine.core.parameter.entry.ParameterEntryBatchLoader;
import org.smartparam.repository.fs.exception.ResourceResolverException;
import org.smartparam.repository.fs.resolver.ParameterFileVisitor;
import org.smartparam.repository.fs.resolver.ResourceResolver;
import org.smartparam.repository.fs.util.StreamReaderOpener;
import org.smartparam.serializer.ParamDeserializer;
import org.smartparam.serializer.exception.ParamSerializationException;
import org.smartparam.serializer.util.StreamCloser;

public class FileResourceResolver
implements ResourceResolver {
    private static final Logger logger = LoggerFactory.getLogger(FileResourceResolver.class);
    private final String basePath;
    private final ParameterFileVisitor fileVisitor;
    private final ParamDeserializer deserializer;

    public FileResourceResolver(String basePath, String filePattern, ParamDeserializer deserializer) {
        this.basePath = basePath;
        this.deserializer = deserializer;
        this.fileVisitor = new ParameterFileVisitor(filePattern, deserializer);
    }

    @Override
    public Map<String, String> findParameterResources() {
        logger.info("scanning files at {}", (Object)this.basePath);
        try {
            this.fileVisitor.clearOldResults();
            Path basePathPath = new File(this.basePath).toPath();
            Files.walkFileTree(basePathPath, this.fileVisitor);
            return this.fileVisitor.getParameters();
        }
        catch (IOException exception) {
            throw new ResourceResolverException("Exception while scanning base path: " + this.basePath, exception);
        }
    }

    @Override
    public ParameterBatchLoader batchLoadParameterFromResource(String parameterResourceName) {
        try {
            BufferedReader reader = StreamReaderOpener.openReaderForFile(parameterResourceName, this.deserializer.getSerializationConfig().getCharset());
            Parameter metadata = this.deserializer.deserializeMetadata(reader);
            ParameterEntryBatchLoader entriesLoader = this.deserializer.deserializeEntries(reader);
            return new ParameterBatchLoader(metadata, entriesLoader);
        }
        catch (ParamSerializationException serializationException) {
            throw new ResourceResolverException("Unable to load parameter from " + parameterResourceName, serializationException);
        }
    }

    @Override
    public Parameter loadParameterFromResource(String parameterResourceName) {
        Parameter parameter;
        BufferedReader reader = null;
        try {
            reader = StreamReaderOpener.openReaderForFile(parameterResourceName, this.deserializer.getSerializationConfig().getCharset());
            parameter = this.deserializer.deserialize(reader);
        }
        catch (ParamSerializationException serializationException) {
            try {
                throw new ResourceResolverException("Unable to load parameter from " + parameterResourceName, serializationException);
            }
            catch (Throwable throwable) {
                StreamCloser.closeStream(reader);
                throw throwable;
            }
        }
        StreamCloser.closeStream((Closeable)reader);
        return parameter;
    }
}

