/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.repository.fs.resolver;

import com.google.common.base.Predicates;
import java.io.BufferedReader;
import java.io.Closeable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.parameter.Parameter;
import org.smartparam.engine.core.parameter.ParameterBatchLoader;
import org.smartparam.engine.core.parameter.entry.ParameterEntryBatchLoader;
import org.smartparam.repository.fs.exception.ResourceResolverException;
import org.smartparam.repository.fs.resolver.ResourceResolver;
import org.smartparam.repository.fs.util.StreamReaderOpener;
import org.smartparam.serializer.ParamDeserializer;
import org.smartparam.serializer.exception.ParamSerializationException;
import org.smartparam.serializer.util.StreamCloser;

public class ClasspathResourceResolver
implements ResourceResolver {
    private static final Logger logger = LoggerFactory.getLogger(ClasspathResourceResolver.class);
    private static final String CLASSPATH_SEPARATOR = "/";
    private static final String PACKAGE_SEPARATOR = ".";
    private final String basePath;
    private final String filePattern;
    private final ParamDeserializer deserializer;

    public ClasspathResourceResolver(String basePath, String filePattern, ParamDeserializer deserializer) {
        this.basePath = basePath;
        this.filePattern = filePattern;
        this.deserializer = deserializer;
    }

    @Override
    public Map<String, String> findParameterResources() {
        logger.info("scanning resources, filtering pattern: {}", (Object)this.filePattern);
        String packagePath = this.createPackagePath(this.basePath);
        String regexPackagePath = "^" + packagePath.replaceAll("\\.", "[.]");
        ConfigurationBuilder config = new ConfigurationBuilder().setUrls((Collection)ClasspathHelper.forPackage((String)packagePath, (ClassLoader[])new ClassLoader[0])).filterInputsBy(Predicates.containsPattern((String)regexPackagePath)).addScanners(new Scanner[]{new ResourcesScanner()});
        Reflections reflections = new Reflections((Configuration)config);
        Set resources = reflections.getResources(Pattern.compile(this.filePattern));
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String resource : resources) {
            String resourceName = CLASSPATH_SEPARATOR + resource;
            String parameterName = this.readParameterNameFromResource(resourceName);
            parameters.put(parameterName, resourceName);
            logger.debug("found parameter {} in resource {}", (Object)parameterName, (Object)resourceName);
        }
        return parameters;
    }

    private String createPackagePath(String basePath) {
        String packagePath = "";
        if (basePath.length() > 1) {
            packagePath = basePath.replaceAll(CLASSPATH_SEPARATOR, PACKAGE_SEPARATOR);
            if (packagePath.startsWith(PACKAGE_SEPARATOR)) {
                packagePath = packagePath.substring(1);
            }
            if (!packagePath.endsWith(PACKAGE_SEPARATOR)) {
                packagePath = packagePath + PACKAGE_SEPARATOR;
            }
        }
        return packagePath;
    }

    private String readParameterNameFromResource(String resourceName) {
        try {
            return this.readParameterConfigFromResource(resourceName).getName();
        }
        catch (ParamSerializationException serializationException) {
            throw new ResourceResolverException("Unable to load parameter from " + resourceName, serializationException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Parameter readParameterConfigFromResource(String resourceName) throws ParamSerializationException {
        Parameter parameter;
        BufferedReader reader = null;
        try {
            reader = StreamReaderOpener.openReaderForResource(this.getClass(), resourceName);
            parameter = this.deserializer.deserializeMetadata(reader);
        }
        catch (Throwable throwable) {
            StreamCloser.closeStream(reader);
            throw throwable;
        }
        StreamCloser.closeStream((Closeable)reader);
        return parameter;
    }

    @Override
    public ParameterBatchLoader batchLoadParameterFromResource(String parameterResourceName) {
        try {
            BufferedReader reader = StreamReaderOpener.openReaderForResource(this.getClass(), parameterResourceName);
            Parameter metadata = this.deserializer.deserializeMetadata(reader);
            ParameterEntryBatchLoader entriesLoader = this.deserializer.deserializeEntries(reader);
            return new ParameterBatchLoader(metadata, entriesLoader);
        }
        catch (ParamSerializationException serializationException) {
            throw new ResourceResolverException("Unable to load parameter from " + parameterResourceName, serializationException);
        }
    }

    @Override
    public Parameter loadParameterFromResource(String parameterResourceName) {
        Parameter parameter;
        BufferedReader reader = null;
        try {
            reader = StreamReaderOpener.openReaderForResource(this.getClass(), parameterResourceName);
            parameter = this.deserializer.deserialize(reader);
        }
        catch (ParamSerializationException serializationException) {
            try {
                throw new ResourceResolverException("Unable to load parameter from " + parameterResourceName, serializationException);
            }
            catch (Throwable throwable) {
                StreamCloser.closeStream(reader);
                throw throwable;
            }
        }
        StreamCloser.closeStream((Closeable)reader);
        return parameter;
    }
}

