/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.repository.fs;

import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.config.initialization.InitializableComponent;
import org.smartparam.engine.config.initialization.InitializableComponentNotInitialized;
import org.smartparam.engine.core.parameter.ParamRepository;
import org.smartparam.engine.core.parameter.Parameter;
import org.smartparam.engine.core.parameter.ParameterBatchLoader;
import org.smartparam.engine.core.parameter.entry.ParameterEntry;
import org.smartparam.repository.fs.resolver.ResourceResolver;
import org.smartparam.serializer.ParamDeserializer;
import org.smartparam.serializer.ParamSerializerFactory;
import org.smartparam.serializer.StandardParamDeserializer;
import org.smartparam.serializer.config.DefaultSerializationConfig;
import org.smartparam.serializer.config.SerializationConfig;

public abstract class AbstractFSParamRepository
implements ParamRepository,
InitializableComponent {
    private static final Logger logger = LoggerFactory.getLogger(AbstractFSParamRepository.class);
    private boolean initialized;
    private String basePath;
    private String filePattern;
    private ParamDeserializer deserializer;
    private ResourceResolver resourceResolver;
    private Map<String, String> parameters;

    public AbstractFSParamRepository(String basePath, String filePattern) {
        this(basePath, filePattern, null);
    }

    public AbstractFSParamRepository(String basePath, String filePattern, ParamDeserializer deserializer) {
        this.basePath = basePath;
        this.filePattern = filePattern;
        this.deserializer = deserializer;
    }

    public void initialize() {
        this.initialized = true;
        if (this.deserializer == null) {
            logger.debug("no custom deserializer provided, using {}", (Object)StandardParamDeserializer.class.getSimpleName());
            this.deserializer = ParamSerializerFactory.paramDeserializer((SerializationConfig)new DefaultSerializationConfig());
        }
        this.resourceResolver = this.createResourceResolver(this.basePath, this.filePattern, this.deserializer);
        this.parameters = this.resourceResolver.findParameterResources();
        logger.info("found {} parameters after scanning resources at {}", (Object)this.parameters.size(), (Object)this.basePath);
    }

    protected abstract ResourceResolver createResourceResolver(String var1, String var2, ParamDeserializer var3);

    public Parameter load(String parameterName) {
        this.checkIfInitialized();
        String parameterResourceName = this.parameters.get(parameterName);
        if (parameterResourceName != null) {
            return this.resourceResolver.loadParameterFromResource(parameterResourceName);
        }
        return null;
    }

    public ParameterBatchLoader batchLoad(String parameterName) {
        this.checkIfInitialized();
        String parameterResourceName = this.parameters.get(parameterName);
        if (parameterResourceName != null) {
            return this.resourceResolver.batchLoadParameterFromResource(parameterResourceName);
        }
        return null;
    }

    public Set<ParameterEntry> findEntries(String parameterName, String[] levelValues) {
        this.checkIfInitialized();
        logger.info("trying to load parameter {}, but {} does not support non-cacheable parameters", (Object)parameterName, (Object)this.getClass().getSimpleName());
        return null;
    }

    public Set<String> listParameters() {
        this.checkIfInitialized();
        return this.parameters.keySet();
    }

    private void checkIfInitialized() {
        if (!this.initialized) {
            throw new InitializableComponentNotInitialized(this.getClass());
        }
    }
}

