/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.smartboot.http.common.Cookie;
import org.smartboot.http.common.HeaderValue;
import org.smartboot.http.common.Reset;
import org.smartboot.http.common.enums.DecodePartEnum;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.enums.HttpTypeEnum;
import org.smartboot.http.common.exception.HttpException;
import org.smartboot.http.common.logging.Logger;
import org.smartboot.http.common.logging.LoggerFactory;
import org.smartboot.http.common.utils.ByteTree;
import org.smartboot.http.common.utils.HttpUtils;
import org.smartboot.http.common.utils.NumberUtils;
import org.smartboot.http.common.utils.SmartDecoder;
import org.smartboot.http.common.utils.StringUtils;
import org.smartboot.http.server.Http2ServerHandler;
import org.smartboot.http.server.HttpRequest;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.ServerHandler;
import org.smartboot.http.server.WebSocketHandler;
import org.smartboot.http.server.decode.Decoder;
import org.smartboot.http.server.impl.AbstractRequest;
import org.smartboot.http.server.impl.HttpRequestImpl;
import org.smartboot.http.server.impl.WebSocketRequestImpl;
import org.smartboot.socket.timer.HashedWheelTimer;
import org.smartboot.socket.timer.TimerTask;
import org.smartboot.socket.transport.AioSession;
import org.smartboot.socket.util.Attachment;

public final class Request
implements HttpRequest,
Reset {
    private static final Logger LOGGER = LoggerFactory.getLogger(Request.class);
    private static final Locale defaultLocale = Locale.getDefault();
    private static final int INIT_CONTENT_LENGTH = -2;
    private static final int NONE_CONTENT_LENGTH = -1;
    private final AioSession aioSession;
    private Decoder decoder;
    private SmartDecoder bodyDecoder;
    private final List<HeaderValue> headers = new ArrayList<HeaderValue>(8);
    private final HttpServerConfiguration configuration;
    private ByteTree<Function<String, ServerHandler>> headerTemp;
    private Map<String, String[]> parameters;
    private String uri;
    private int headerSize = 0;
    private String method;
    private String protocol;
    private String requestUri;
    private String requestUrl;
    private String contentType;
    private String queryString;
    private String scheme;
    private int contentLength = -2;
    private String remoteAddr;
    private String remoteHost;
    private String hostHeader;
    private HttpTypeEnum type = null;
    private ByteBuffer formUrlencoded;
    private Cookie[] cookies;
    private Attachment attachment;
    private DecodePartEnum decodePartEnum = DecodePartEnum.HEADER_FINISH;
    private HttpRequestImpl httpRequest;
    private WebSocketRequestImpl webSocketRequest;
    private ServerHandler serverHandler;
    private int remainingThreshold;
    private long latestIo;
    private TimerTask httpIdleTask;
    private TimerTask wsIdleTask;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelHttpIdleTask() {
        Request request = this;
        synchronized (request) {
            if (this.httpIdleTask != null) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("cancel http idle monitor, request:{}", (Object)this);
                }
                this.httpIdleTask.cancel();
                this.httpIdleTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelWsIdleTask() {
        Request request = this;
        synchronized (request) {
            if (this.wsIdleTask != null) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("cancel websocket idle monitor, request:{}", (Object)this);
                }
                this.wsIdleTask.cancel();
                this.wsIdleTask = null;
            }
        }
    }

    Request(HttpServerConfiguration configuration, AioSession aioSession) {
        this.configuration = configuration;
        this.aioSession = aioSession;
        this.remainingThreshold = configuration.getMaxRequestSize();
        if (configuration.getWsIdleTimeout() > 0) {
            this.wsIdleTask = HashedWheelTimer.DEFAULT_TIMER.scheduleWithFixedDelay(() -> {
                LOGGER.debug("check wsIdle monitor");
                if (System.currentTimeMillis() - this.latestIo > (long)configuration.getWsIdleTimeout() && this.webSocketRequest != null) {
                    LOGGER.debug("close ws connection by idle monitor");
                    try {
                        aioSession.close();
                    }
                    finally {
                        this.cancelWsIdleTask();
                        this.cancelHttpIdleTask();
                    }
                }
            }, (long)configuration.getWsIdleTimeout(), TimeUnit.MILLISECONDS);
        }
        if (configuration.getHttpIdleTimeout() > 0) {
            this.httpIdleTask = HashedWheelTimer.DEFAULT_TIMER.scheduleWithFixedDelay(() -> {
                LOGGER.debug("check httpIdle monitor");
                if (System.currentTimeMillis() - this.latestIo > (long)configuration.getHttpIdleTimeout() && this.webSocketRequest == null) {
                    LOGGER.debug("close http connection by idle monitor");
                    try {
                        aioSession.close();
                    }
                    finally {
                        this.cancelHttpIdleTask();
                        this.cancelWsIdleTask();
                    }
                }
            }, (long)configuration.getHttpIdleTimeout(), TimeUnit.MILLISECONDS);
        }
    }

    int getRemainingThreshold() {
        return this.remainingThreshold;
    }

    public DecodePartEnum getDecodePartEnum() {
        return this.decodePartEnum;
    }

    public void setDecodePartEnum(DecodePartEnum decodePartEnum) {
        this.decodePartEnum = decodePartEnum;
    }

    public AioSession getAioSession() {
        return this.aioSession;
    }

    public String getHost() {
        if (this.hostHeader == null) {
            this.hostHeader = this.getHeader(HeaderNameEnum.HOST.getName());
        }
        return this.hostHeader;
    }

    void decodeSize(int size) {
        this.remainingThreshold -= size;
        if (this.remainingThreshold < 0) {
            throw new HttpException(HttpStatus.PAYLOAD_TOO_LARGE);
        }
    }

    @Override
    public String getHeader(String headName) {
        for (int i = 0; i < this.headerSize; ++i) {
            HeaderValue headerValue = this.headers.get(i);
            if (!headerValue.getName().equalsIgnoreCase(headName)) continue;
            return headerValue.getValue();
        }
        return null;
    }

    @Override
    public Collection<String> getHeaders(String name) {
        ArrayList<String> value = new ArrayList<String>(4);
        for (int i = 0; i < this.headerSize; ++i) {
            HeaderValue headerValue = this.headers.get(i);
            if (!headerValue.getName().equalsIgnoreCase(name)) continue;
            value.add(headerValue.getValue());
        }
        return value;
    }

    @Override
    public Collection<String> getHeaderNames() {
        HashSet<String> nameSet = new HashSet<String>();
        for (int i = 0; i < this.headerSize; ++i) {
            nameSet.add(this.headers.get(i).getName());
        }
        return nameSet;
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    @Override
    public InputStream getInputStream() {
        throw new UnsupportedOperationException();
    }

    public void setHeadValue(String value) {
        ServerHandler replaceServerHandler;
        if (this.headerTemp.getAttach() != null && (replaceServerHandler = (ServerHandler)((Function)this.headerTemp.getAttach()).apply(value)) != null) {
            this.setServerHandler(replaceServerHandler);
        }
        this.setHeader(this.headerTemp.getStringValue(), value);
    }

    public void setHeader(String headerName, String value) {
        if (this.headerSize < this.headers.size()) {
            HeaderValue headerValue = this.headers.get(this.headerSize);
            headerValue.setName(headerName);
            headerValue.setValue(value);
        } else {
            this.headers.add(new HeaderValue(headerName, value));
        }
        ++this.headerSize;
    }

    public HttpTypeEnum getRequestType() {
        if (this.type != null) {
            return this.type;
        }
        this.type = this.serverHandler instanceof WebSocketHandler ? HttpTypeEnum.WEBSOCKET : (this.serverHandler instanceof Http2ServerHandler ? HttpTypeEnum.HTTP_2 : HttpTypeEnum.HTTP);
        return this.type;
    }

    public ServerHandler getServerHandler() {
        return this.serverHandler;
    }

    public void setServerHandler(ServerHandler serverHandler) {
        this.serverHandler = serverHandler;
    }

    @Override
    public String getRequestURI() {
        return this.requestUri;
    }

    public void setRequestURI(String uri) {
        this.requestUri = uri;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public boolean isSecure() {
        return this.configuration.isSecure();
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setHeaderTemp(ByteTree headerTemp) {
        this.headerTemp = headerTemp;
    }

    @Override
    public String getRequestURL() {
        if (this.requestUrl != null) {
            return this.requestUrl;
        }
        this.requestUrl = this.requestUri.startsWith("/") ? this.getScheme() + "://" + this.getHeader(HeaderNameEnum.HOST.getName()) + this.getRequestURI() : this.requestUri;
        return this.requestUrl;
    }

    @Override
    public String getScheme() {
        if (this.scheme == null) {
            return this.configuration.isSecure() ? "https" : "http";
        }
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    @Override
    public String getContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        this.contentType = this.getHeader(HeaderNameEnum.CONTENT_TYPE.getName());
        return this.contentType;
    }

    @Override
    public int getContentLength() {
        if (this.contentLength > -2) {
            return this.contentLength;
        }
        this.contentLength = NumberUtils.toInt((String)this.getHeader(HeaderNameEnum.CONTENT_LENGTH.getName()), (int)-1);
        if (this.contentLength >= this.remainingThreshold) {
            throw new HttpException(HttpStatus.PAYLOAD_TOO_LARGE);
        }
        return this.contentLength;
    }

    @Override
    public String getParameter(String name) {
        String[] arr = name != null ? this.getParameterValues(name) : null;
        return arr != null && arr.length > 0 ? arr[0] : null;
    }

    @Override
    public String[] getParameterValues(String name) {
        if (this.parameters != null) {
            return this.parameters.get(name);
        }
        this.parameters = new HashMap<String, String[]>();
        String urlParamStr = this.queryString;
        if (StringUtils.isNotBlank((CharSequence)urlParamStr)) {
            urlParamStr = StringUtils.substringBefore((String)urlParamStr, (String)"#");
            HttpUtils.decodeParamString((String)urlParamStr, this.parameters);
        }
        if (this.formUrlencoded != null) {
            HttpUtils.decodeParamString((String)new String(this.formUrlencoded.array()), this.parameters);
        }
        return this.getParameterValues(name);
    }

    @Override
    public Map<String, String[]> getParameters() {
        if (this.parameters == null) {
            this.getParameter("");
        }
        return this.parameters;
    }

    @Override
    public String getRemoteAddr() {
        if (this.remoteAddr != null) {
            return this.remoteAddr;
        }
        try {
            InetSocketAddress remote = this.aioSession.getRemoteAddress();
            InetAddress address = remote.getAddress();
            this.remoteAddr = address == null ? remote.getHostString() : address.getHostAddress();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.remoteAddr;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        try {
            return this.aioSession.getRemoteAddress();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        try {
            return this.aioSession.getLocalAddress();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getRemoteHost() {
        if (this.remoteHost != null) {
            return this.remoteHost;
        }
        try {
            this.remoteHost = this.aioSession.getRemoteAddress().getHostString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.remoteHost;
    }

    @Override
    public Locale getLocale() {
        return this.getLocales().nextElement();
    }

    @Override
    public Enumeration<Locale> getLocales() {
        Collection<String> acceptLanguage = this.getHeaders(HeaderNameEnum.ACCEPT_LANGUAGE.getName());
        if (acceptLanguage.isEmpty()) {
            return Collections.enumeration(Collections.singletonList(defaultLocale));
        }
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (String language : acceptLanguage) {
            for (String lan : language.split(",")) {
                locales.add(Locale.forLanguageTag(lan));
            }
        }
        return Collections.enumeration(locales);
    }

    @Override
    public String getCharacterEncoding() {
        return "utf8";
    }

    @Override
    public Cookie[] getCookies() {
        if (this.cookies != null) {
            return this.cookies;
        }
        HashMap parsedCookies = new HashMap();
        for (int i = 0; i < this.headerSize; ++i) {
            HeaderValue headerValue = this.headers.get(i);
            if (!headerValue.getName().equalsIgnoreCase(HeaderNameEnum.COOKIE.getName())) continue;
            HttpUtils.parseCookie((String)headerValue.getValue(), parsedCookies);
        }
        this.cookies = new Cookie[parsedCookies.size()];
        parsedCookies.values().toArray(this.cookies);
        return this.cookies;
    }

    ByteBuffer getFormUrlencoded() {
        return this.formUrlencoded;
    }

    public void setFormUrlencoded(ByteBuffer formUrlencoded) {
        this.formUrlencoded = formUrlencoded;
    }

    @Override
    public Attachment getAttachment() {
        return this.attachment;
    }

    @Override
    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
    }

    public AbstractRequest newAbstractRequest() {
        switch (this.getRequestType()) {
            case WEBSOCKET: {
                return this.newWebsocketRequest();
            }
            case HTTP: {
                return this.newHttpRequest();
            }
        }
        return null;
    }

    public HttpRequestImpl newHttpRequest() {
        if (this.httpRequest == null) {
            this.httpRequest = new HttpRequestImpl(this);
            this.cancelWsIdleTask();
        }
        return this.httpRequest;
    }

    public WebSocketRequestImpl newWebsocketRequest() {
        if (this.webSocketRequest == null) {
            this.webSocketRequest = new WebSocketRequestImpl(this);
            this.cancelHttpIdleTask();
        }
        return this.webSocketRequest;
    }

    public HttpServerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setLatestIo(long latestIo) {
        this.latestIo = latestIo;
    }

    public Decoder getDecoder() {
        return this.decoder;
    }

    public void setDecoder(Decoder decoder) {
        this.decoder = decoder;
    }

    public SmartDecoder getBodyDecoder() {
        return this.bodyDecoder;
    }

    public void setBodyDecoder(SmartDecoder bodyDecoder) {
        this.bodyDecoder = bodyDecoder;
    }

    public void reset() {
        this.remainingThreshold = this.configuration.getMaxRequestSize();
        this.headerSize = 0;
        this.method = null;
        this.uri = null;
        this.requestUrl = null;
        this.parameters = null;
        this.contentType = null;
        this.contentLength = -2;
        this.formUrlencoded = null;
        this.queryString = null;
        this.cookies = null;
        this.httpRequest = null;
        this.webSocketRequest = null;
        this.type = null;
        this.decodePartEnum = DecodePartEnum.HEADER_FINISH;
        this.scheme = null;
    }
}

