/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import org.smartboot.http.common.BufferOutputStream;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.enums.HeaderValueEnum;
import org.smartboot.http.common.enums.HttpMethodEnum;
import org.smartboot.http.common.enums.HttpProtocolEnum;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.utils.TimerUtils;
import org.smartboot.http.server.impl.AbstractOutputStream;
import org.smartboot.http.server.impl.HttpRequestImpl;
import org.smartboot.http.server.impl.HttpResponseImpl;

final class HttpOutputStream
extends AbstractOutputStream {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
    private static final int CACHE_LIMIT = 512;
    private static final Map<String, BufferOutputStream.WriteCache>[] CACHE_CONTENT_TYPE_AND_LENGTH = new Map[512];
    private static final Date currentDate = new Date(0L);
    private static final Semaphore flushDateSemaphore = new Semaphore(1);
    private static long expireTime;
    private static byte[] dateBytes;
    private static String date;

    public HttpOutputStream(HttpRequestImpl httpRequest, HttpResponseImpl response) {
        super(httpRequest, response);
    }

    private static long flushDate() {
        long currentTime = TimerUtils.currentTimeMillis();
        if (currentTime > expireTime && flushDateSemaphore.tryAcquire()) {
            try {
                expireTime = currentTime + 1000L;
                currentDate.setTime(currentTime);
                date = sdf.format(currentDate);
                dateBytes = date.getBytes();
            }
            finally {
                flushDateSemaphore.release();
            }
        }
        return currentTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] getHeadPart(boolean hasHeader) {
        BufferOutputStream.WriteCache data;
        boolean cache;
        this.checkChunked();
        long currentTime = HttpOutputStream.flushDate();
        int contentLength = this.response.getContentLength();
        String contentType = this.response.getContentType();
        boolean bl = cache = this.response.isDefaultStatus() && contentLength > 0 && contentLength < 512 && !hasHeader;
        if (cache && (data = CACHE_CONTENT_TYPE_AND_LENGTH[contentLength].get(contentType)) != null) {
            if (currentTime > data.getExpireTime() && data.getSemaphore().tryAcquire()) {
                try {
                    data.setExpireTime(currentTime + 1000L);
                    System.arraycopy(dateBytes, 0, data.getCacheData(), data.getCacheData().length - 4 - dateBytes.length, dateBytes.length);
                }
                finally {
                    data.getSemaphore().release();
                }
            }
            return data.getCacheData();
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append(this.request.getProtocol()).append(' ').append(this.response.getHttpStatus()).append(' ').append(this.response.getReasonPhrase()).append("\r\n");
        if (contentType != null) {
            sb.append(HeaderNameEnum.CONTENT_TYPE.getName()).append(':').append(contentType).append("\r\n");
        }
        if (contentLength >= 0) {
            sb.append(HeaderNameEnum.CONTENT_LENGTH.getName()).append(':').append(contentLength).append("\r\n");
        } else if (this.chunkedSupport) {
            sb.append(HeaderNameEnum.TRANSFER_ENCODING.getName()).append(':').append(HeaderValueEnum.CHUNKED.getName()).append("\r\n");
        }
        if (this.configuration.serverName() != null && this.response.getHeader(HeaderNameEnum.SERVER.getName()) == null) {
            sb.append(SERVER_LINE);
        }
        sb.append(HeaderNameEnum.DATE.getName()).append(':').append(date).append("\r\n");
        if (cache) {
            sb.append("\r\n");
            BufferOutputStream.WriteCache writeCache = new BufferOutputStream.WriteCache(currentTime + 1000L, sb.toString().getBytes());
            CACHE_CONTENT_TYPE_AND_LENGTH[contentLength].put(contentType, writeCache);
            return writeCache.getCacheData();
        }
        return hasHeader ? sb.toString().getBytes() : sb.append("\r\n").toString().getBytes();
    }

    private void checkChunked() {
        if (!this.chunkedSupport) {
            return;
        }
        if (this.response.getContentLength() >= 0) {
            this.disableChunked();
        } else if (this.response.getHttpStatus() == HttpStatus.CONTINUE.value()) {
            this.disableChunked();
        } else if (HttpMethodEnum.HEAD.name().equals(this.request.getMethod())) {
            this.disableChunked();
        } else if (!HttpProtocolEnum.HTTP_11.getProtocol().equals(this.request.getProtocol())) {
            this.disableChunked();
        } else if (this.response.getContentType().startsWith(HeaderValueEnum.CONTENT_TYPE_EVENT_STREAM.getName())) {
            this.disableChunked();
        }
    }

    static {
        HttpOutputStream.flushDate();
        for (int i = 0; i < 512; ++i) {
            HttpOutputStream.CACHE_CONTENT_TYPE_AND_LENGTH[i] = new ConcurrentHashMap<String, BufferOutputStream.WriteCache>();
        }
    }
}

