/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Base64;
import org.smartboot.http.common.codec.websocket.BasicFrameDecoder;
import org.smartboot.http.common.codec.websocket.Decoder;
import org.smartboot.http.common.codec.websocket.WebSocket;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.enums.HeaderValueEnum;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.utils.SHA1;
import org.smartboot.http.server.ServerHandler;
import org.smartboot.http.server.WebSocketRequest;
import org.smartboot.http.server.WebSocketResponse;
import org.smartboot.http.server.impl.AbstractOutputStream;
import org.smartboot.http.server.impl.Request;
import org.smartboot.http.server.impl.WebSocketRequestImpl;
import org.smartboot.http.server.impl.WebSocketResponseImpl;
import org.smartboot.socket.util.AttachKey;
import org.smartboot.socket.util.Attachment;

public abstract class WebSocketHandler
implements ServerHandler<WebSocketRequest, WebSocketResponse> {
    public static final String WEBSOCKET_13_ACCEPT_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private static final AttachKey<Decoder> FRAME_DECODER_KEY = AttachKey.valueOf((String)"ws_frame_decoder");
    private final Decoder basicFrameDecoder = new BasicFrameDecoder();

    public void willHeaderComplete(WebSocketRequestImpl request, WebSocketResponseImpl response) {
    }

    public final void onHeaderComplete(Request request) throws IOException {
        WebSocketRequestImpl webSocketRequest = request.newWebsocketRequest();
        WebSocketResponseImpl response = webSocketRequest.getResponse();
        this.willHeaderComplete(webSocketRequest, response);
        String key = request.getHeader(HeaderNameEnum.Sec_WebSocket_Key.getName());
        String acceptSeed = key + WEBSOCKET_13_ACCEPT_GUID;
        byte[] sha1 = SHA1.encode((String)acceptSeed);
        String accept = Base64.getEncoder().encodeToString(sha1);
        response.setHttpStatus(HttpStatus.SWITCHING_PROTOCOLS);
        response.setHeader(HeaderNameEnum.UPGRADE.getName(), HeaderValueEnum.WEBSOCKET.getName());
        response.setHeader(HeaderNameEnum.CONNECTION.getName(), HeaderValueEnum.UPGRADE.getName());
        response.setHeader(HeaderNameEnum.Sec_WebSocket_Accept.getName(), accept);
        AbstractOutputStream outputStream = response.getOutputStream();
        ((OutputStream)((Object)outputStream)).flush();
        Attachment attachment = webSocketRequest.getAttachment();
        if (attachment == null) {
            attachment = new Attachment();
            webSocketRequest.setAttachment(attachment);
        }
        attachment.put(FRAME_DECODER_KEY, (Object)this.basicFrameDecoder);
        webSocketRequest.setAttachment(attachment);
        this.whenHeaderComplete(webSocketRequest, response);
    }

    public void whenHeaderComplete(WebSocketRequestImpl request, WebSocketResponseImpl response) {
    }

    public boolean onBodyStream(ByteBuffer byteBuffer, Request request) {
        Attachment attachment = request.newWebsocketRequest().getAttachment();
        Decoder decoder = ((Decoder)attachment.get(FRAME_DECODER_KEY)).decode(byteBuffer, (WebSocket)request.newWebsocketRequest());
        if (decoder == WebSocket.PAYLOAD_FINISH) {
            attachment.put(FRAME_DECODER_KEY, (Object)this.basicFrameDecoder);
            return true;
        }
        attachment.put(FRAME_DECODER_KEY, (Object)decoder);
        return false;
    }
}

