/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server;

import java.io.IOException;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.smartboot.http.common.utils.ByteTree;
import org.smartboot.http.common.utils.StringUtils;
import org.smartboot.http.server.HttpRequest;
import org.smartboot.http.server.HttpResponse;
import org.smartboot.http.server.HttpServerHandler;
import org.smartboot.http.server.ServerHandler;
import org.smartboot.http.server.WebSocketHandler;
import org.smartboot.http.server.impl.Request;
import org.smartboot.http.server.waf.WafConfiguration;
import org.smartboot.socket.extension.plugins.Plugin;
import org.smartboot.socket.extension.plugins.SslPlugin;
import org.smartboot.socket.extension.plugins.StreamMonitorPlugin;

public class HttpServerConfiguration {
    public static final String VERSION = "1.4.3";
    private final ByteTree<?> byteCache = new ByteTree();
    private final ByteTree<ServerHandler<?, ?>> uriByteTree = new ByteTree();
    private final ByteTree<Function<String, ServerHandler<?, ?>>> headerNameByteTree = new ByteTree();
    private final List<Plugin<Request>> plugins = new ArrayList<Plugin<Request>>();
    private boolean bannerEnabled = true;
    private int readBufferSize = 1024;
    private int writeBufferSize = 1024;
    private int threadNum = Math.max(Runtime.getRuntime().availableProcessors(), 2);
    private int writePageSize = 0x100000;
    private int writePageNum = this.threadNum;
    private String host;
    private int readPageSize = 0x100000;
    private int headerLimiter = 100;
    private int httpIdleTimeout = 60000;
    private int wsIdleTimeout = 120000;
    private String serverName = "smart-http";
    private boolean secure;
    private int maxRequestSize = Integer.MAX_VALUE;
    private AsynchronousChannelGroup group;
    private HttpServerHandler httpServerHandler = new HttpServerHandler(){

        @Override
        public void handle(HttpRequest request, HttpResponse response) throws IOException {
            response.write("Hello smart-http".getBytes(StandardCharsets.UTF_8));
        }
    };
    private WebSocketHandler webSocketHandler;
    private WafConfiguration wafConfiguration = new WafConfiguration();

    public HttpServerConfiguration readMemoryPool(int totalBytes) {
        this.readPageSize = totalBytes;
        return this;
    }

    int getReadPageSize() {
        return this.readPageSize;
    }

    public HttpServerConfiguration writeMemoryPool(int totalBytes, int shards) {
        this.writePageSize = totalBytes / shards;
        this.writePageNum = shards;
        return this;
    }

    int getReadBufferSize() {
        return this.readBufferSize;
    }

    public HttpServerConfiguration readBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
        return this;
    }

    int getThreadNum() {
        return this.threadNum;
    }

    public HttpServerConfiguration threadNum(int threadNum) {
        this.threadNum = threadNum;
        return this;
    }

    int getWritePageSize() {
        return this.writePageSize;
    }

    int getWritePageNum() {
        return this.writePageNum;
    }

    int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public HttpServerConfiguration writeBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
        return this;
    }

    String getHost() {
        return this.host;
    }

    public HttpServerConfiguration host(String host) {
        this.host = host;
        return this;
    }

    boolean isBannerEnabled() {
        return this.bannerEnabled;
    }

    public HttpServerConfiguration bannerEnabled(boolean bannerEnabled) {
        this.bannerEnabled = bannerEnabled;
        return this;
    }

    public int getHeaderLimiter() {
        return this.headerLimiter;
    }

    public HttpServerConfiguration headerLimiter(int headerLimiter) {
        this.headerLimiter = headerLimiter;
        return this;
    }

    public HttpServerConfiguration debug(boolean debug) {
        this.plugins.removeIf(plugin -> plugin instanceof StreamMonitorPlugin);
        if (debug) {
            this.addPlugin((Plugin<Request>)new StreamMonitorPlugin(StreamMonitorPlugin.BLUE_TEXT_INPUT_STREAM, StreamMonitorPlugin.RED_TEXT_OUTPUT_STREAM));
        }
        return this;
    }

    public String serverName() {
        return this.serverName;
    }

    public HttpServerConfiguration serverName(String server) {
        this.serverName = server == null ? null : StringUtils.trim((String)server).replaceAll("\r", "").replaceAll("\n", "");
        return this;
    }

    public ByteTree<ServerHandler<?, ?>> getUriByteTree() {
        return this.uriByteTree;
    }

    public HttpServerHandler getHttpServerHandler() {
        return this.httpServerHandler;
    }

    public void setHttpServerHandler(HttpServerHandler httpServerHandler) {
        this.httpServerHandler = httpServerHandler;
    }

    public WebSocketHandler getWebSocketHandler() {
        return this.webSocketHandler;
    }

    public void setWebSocketHandler(WebSocketHandler webSocketHandler) {
        this.webSocketHandler = webSocketHandler;
    }

    public ByteTree<?> getByteCache() {
        return this.byteCache;
    }

    public ByteTree<Function<String, ServerHandler<?, ?>>> getHeaderNameByteTree() {
        return this.headerNameByteTree;
    }

    public HttpServerConfiguration addPlugin(Plugin<Request> plugin) {
        this.plugins.add(plugin);
        if (plugin instanceof SslPlugin) {
            this.secure = true;
        }
        return this;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public int getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public void setMaxRequestSize(int maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
    }

    public HttpServerConfiguration addPlugin(List<Plugin<Request>> plugins) {
        this.plugins.addAll(plugins);
        return this;
    }

    public List<Plugin<Request>> getPlugins() {
        return this.plugins;
    }

    public AsynchronousChannelGroup group() {
        return this.group;
    }

    public HttpServerConfiguration group(AsynchronousChannelGroup group) {
        this.group = group;
        return this;
    }

    public WafConfiguration getWafConfiguration() {
        return this.wafConfiguration;
    }

    public int getHttpIdleTimeout() {
        return this.httpIdleTimeout;
    }

    public HttpServerConfiguration setHttpIdleTimeout(int httpIdleTimeout) {
        this.httpIdleTimeout = httpIdleTimeout;
        return this;
    }

    public int getWsIdleTimeout() {
        return this.wsIdleTimeout;
    }

    public HttpServerConfiguration setWsIdleTimeout(int wsIdleTimeout) {
        this.wsIdleTimeout = wsIdleTimeout;
        return this;
    }
}

