/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.smartboot.http.common.enums.DecodePartEnum;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.enums.HeaderValueEnum;
import org.smartboot.http.common.enums.HttpMethodEnum;
import org.smartboot.http.common.enums.HttpProtocolEnum;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.enums.HttpTypeEnum;
import org.smartboot.http.common.exception.HttpException;
import org.smartboot.http.common.logging.Logger;
import org.smartboot.http.common.logging.LoggerFactory;
import org.smartboot.http.common.utils.StringUtils;
import org.smartboot.http.server.HttpRequest;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.HttpServerHandler;
import org.smartboot.http.server.WebSocketHandler;
import org.smartboot.http.server.impl.AbstractOutputStream;
import org.smartboot.http.server.impl.AbstractRequest;
import org.smartboot.http.server.impl.AbstractResponse;
import org.smartboot.http.server.impl.HttpRequestImpl;
import org.smartboot.http.server.impl.HttpRequestProtocol;
import org.smartboot.http.server.impl.HttpResponseImpl;
import org.smartboot.http.server.impl.Request;
import org.smartboot.http.server.impl.WebSocketRequestImpl;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.extension.processor.AbstractMessageProcessor;
import org.smartboot.socket.transport.AioSession;

public class HttpMessageProcessor
extends AbstractMessageProcessor<Request> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpMessageProcessor.class);
    private static final int MAX_LENGTH = 261120;
    private HttpServerConfiguration configuration;

    public void process0(AioSession session, Request request) {
        AbstractRequest abstractRequest = request.newAbstractRequest();
        AbstractResponse response = abstractRequest.getResponse();
        try {
            block1 : switch (request.getDecodePartEnum()) {
                case HEADER_FINISH: {
                    this.doHttpHeader(request);
                    if (response.isClosed()) break;
                }
                case BODY: {
                    this.onHttpBody(request, session.readBuffer());
                    if (response.isClosed() || request.getDecodePartEnum() != DecodePartEnum.FINISH) break;
                }
                case FINISH: {
                    switch (request.getRequestType()) {
                        case WEBSOCKET: {
                            this.handleWebSocketRequest(request.newWebsocketRequest());
                            break block1;
                        }
                        case HTTP: {
                            this.handleHttpRequest(request.newHttpRequest());
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private void handleWebSocketRequest(WebSocketRequestImpl abstractRequest) throws Throwable {
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        abstractRequest.request.getServerHandler().handle(abstractRequest, abstractRequest.getResponse(), future);
        if (future.isDone()) {
            this.finishResponse(abstractRequest);
        } else {
            Thread thread = Thread.currentThread();
            AioSession session = abstractRequest.request.getAioSession();
            session.awaitRead();
            future.thenRun(() -> {
                try {
                    this.finishResponse(abstractRequest);
                    if (thread != Thread.currentThread()) {
                        session.writeBuffer().flush();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    abstractRequest.getResponse().close();
                }
                finally {
                    session.signalRead();
                }
            });
        }
    }

    private void handleHttpRequest(HttpRequestImpl abstractRequest) {
        HttpResponseImpl response = abstractRequest.getResponse();
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        boolean keepAlive = this.isKeepAlive(abstractRequest, response);
        abstractRequest.setKeepAlive(keepAlive);
        try {
            abstractRequest.request.getServerHandler().handle(abstractRequest, response, future);
            this.finishHttpHandle(abstractRequest, future);
        }
        catch (Throwable e) {
            HttpMessageProcessor.responseError(response, e);
        }
    }

    private boolean isKeepAlive(AbstractRequest abstractRequest, AbstractResponse response) {
        boolean keepAlive = true;
        if (HttpProtocolEnum.HTTP_10.getProtocol() == abstractRequest.getProtocol() && (keepAlive = HeaderValueEnum.KEEPALIVE.getName().equalsIgnoreCase(abstractRequest.getHeader(HeaderNameEnum.CONNECTION.getName())))) {
            response.setHeader(HeaderNameEnum.CONNECTION.getName(), HeaderValueEnum.KEEPALIVE.getName());
        }
        return keepAlive;
    }

    private static void responseError(AbstractResponse response, Throwable throwable) {
        if (throwable instanceof HttpException) {
            HttpMessageProcessor.responseError(response, HttpStatus.valueOf((int)((HttpException)throwable).getHttpCode()), ((HttpException)throwable).getDesc());
        } else if (throwable.getCause() != null) {
            HttpMessageProcessor.responseError(response, throwable.getCause());
        } else {
            LOGGER.warn("", throwable);
            HttpMessageProcessor.responseError(response, HttpStatus.INTERNAL_SERVER_ERROR, throwable.fillInStackTrace().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void responseError(AbstractResponse response, HttpStatus httpStatus, String desc) {
        try {
            response.setHttpStatus(httpStatus);
            AbstractOutputStream outputStream = response.getOutputStream();
            ((OutputStream)((Object)outputStream)).write(("<center><h1>" + httpStatus.value() + " " + httpStatus.getReasonPhrase() + "</h1>" + desc + "<hr/><a target='_blank' href='https://smartboot.tech/'>smart-http</a>/" + "1.4.1" + "&nbsp;|&nbsp; <a target='_blank' href='https://gitee.com/smartboot/smart-http'>Gitee</a></center>").getBytes());
        }
        catch (IOException e) {
            LOGGER.warn("HttpError response exception", (Throwable)e);
        }
        finally {
            response.close();
        }
    }

    private void finishHttpHandle(HttpRequestImpl abstractRequest, CompletableFuture<Object> future) throws IOException {
        if (future.isDone()) {
            if (this.keepConnection(abstractRequest)) {
                this.finishResponse(abstractRequest);
            }
        } else {
            AioSession session = abstractRequest.request.getAioSession();
            session.awaitRead();
            Thread thread = Thread.currentThread();
            HttpResponseImpl response = abstractRequest.getResponse();
            ((CompletableFuture)future.thenRun(() -> {
                try {
                    if (this.keepConnection(abstractRequest)) {
                        this.finishResponse(abstractRequest);
                        if (thread != Thread.currentThread()) {
                            session.writeBuffer().flush();
                        }
                    }
                }
                catch (Exception e) {
                    HttpMessageProcessor.responseError(response, e);
                }
                finally {
                    session.signalRead();
                }
            })).exceptionally(throwable -> {
                try {
                    HttpMessageProcessor.responseError(response, throwable);
                }
                finally {
                    session.signalRead();
                }
                return null;
            });
        }
    }

    private boolean keepConnection(HttpRequestImpl request) throws IOException {
        if (!request.isKeepAlive() || !HttpMethodEnum.GET.getMethod().equals(request.getMethod()) && request.getContentLength() > 0 && request.getInputStream().available() > 0) {
            request.getResponse().close();
            return false;
        }
        return true;
    }

    private void finishResponse(AbstractRequest abstractRequest) throws IOException {
        AbstractResponse response = abstractRequest.getResponse();
        if (!response.getOutputStream().isClosed()) {
            response.getOutputStream().close();
        }
        abstractRequest.reset();
    }

    private void onHttpBody(Request request, ByteBuffer readBuffer) {
        if (request.getServerHandler().onBodyStream(readBuffer, request)) {
            request.setDecodePartEnum(DecodePartEnum.FINISH);
            if (request.getRequestType() == HttpTypeEnum.HTTP) {
                request.setDecoder(null);
            }
        } else if (readBuffer.hasRemaining()) {
            request.setDecoder(HttpRequestProtocol.BODY_CONTINUE_DECODER);
        }
    }

    private void doHttpHeader(Request request) throws IOException {
        this.methodCheck(request);
        this.uriCheck(request);
        request.getServerHandler().onHeaderComplete(request);
        request.setDecodePartEnum(DecodePartEnum.BODY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateEvent0(AioSession session, StateMachineEnum stateMachineEnum, Throwable throwable) {
        switch (stateMachineEnum) {
            case NEW_SESSION: {
                session.setAttachment((Object)new Request(this.configuration, session));
                break;
            }
            case PROCESS_EXCEPTION: {
                LOGGER.error("process exception", throwable);
                session.close();
                break;
            }
            case SESSION_CLOSED: {
                Request request = (Request)session.getAttachment();
                try {
                    if (request.getServerHandler() == null) break;
                    request.getServerHandler().onClose(request);
                    break;
                }
                finally {
                    request.cancelWsIdleTask();
                    request.cancelHttpIdleTask();
                }
            }
            case DECODE_EXCEPTION: {
                LOGGER.warn("http decode exception,", throwable);
                Request request = (Request)session.getAttachment();
                AbstractRequest abstractRequest = request.newAbstractRequest();
                AbstractResponse response = abstractRequest.getResponse();
                HttpMessageProcessor.responseError(response, throwable);
                break;
            }
        }
    }

    public void httpServerHandler(HttpServerHandler httpServerHandler) {
        this.configuration.setHttpServerHandler(Objects.requireNonNull(httpServerHandler));
    }

    public void setWebSocketHandler(WebSocketHandler webSocketHandler) {
        this.configuration.setWebSocketHandler(Objects.requireNonNull(webSocketHandler));
    }

    private void methodCheck(HttpRequest request) {
        if (request.getMethod() == null) {
            throw new HttpException(HttpStatus.NOT_IMPLEMENTED);
        }
    }

    private void hostCheck(Request request) {
        if (request.getHost() == null) {
            throw new HttpException(HttpStatus.BAD_REQUEST);
        }
    }

    private void uriCheck(Request request) {
        String originalUri = request.getUri();
        if (StringUtils.length((CharSequence)originalUri) > 261120) {
            throw new HttpException(HttpStatus.URI_TOO_LONG);
        }
        if (originalUri.charAt(0) == '/') {
            request.setRequestURI(originalUri);
            return;
        }
        int schemeIndex = originalUri.indexOf("://");
        if (schemeIndex > 0) {
            int uriIndex = originalUri.indexOf(47, schemeIndex + 3);
            if (uriIndex == -1) {
                request.setRequestURI("/");
            } else {
                request.setRequestURI(StringUtils.substring((String)originalUri, (int)uriIndex));
            }
            request.setScheme(StringUtils.substring((String)originalUri, (int)0, (int)schemeIndex));
        } else {
            request.setRequestURI(originalUri);
        }
    }

    public void setConfiguration(HttpServerConfiguration configuration) {
        this.configuration = configuration;
    }
}

