/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.smartboot.http.common.Cookie;
import org.smartboot.http.common.utils.StringUtils;

public class HttpUtils {
    public static void decodeParamString(String paramStr, Map<String, String[]> paramMap) {
        String[] uriParamStrArray;
        if (StringUtils.isBlank(paramStr)) {
            return;
        }
        for (String param : uriParamStrArray = StringUtils.split(paramStr, "&")) {
            int index = param.indexOf("=");
            if (index == -1) continue;
            try {
                String key = StringUtils.substring(param, 0, index);
                String value = URLDecoder.decode(StringUtils.substring(param, index + 1), "utf8");
                String[] values = paramMap.get(key);
                if (values == null) {
                    paramMap.put(key, new String[]{value});
                    continue;
                }
                String[] newValue = new String[values.length + 1];
                System.arraycopy(values, 0, newValue, 0, values.length);
                newValue[values.length] = value;
                paramMap.put(key, newValue);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public static void parseCookie(String cookie, Map<String, Cookie> parsedCookies) {
        HttpUtils.parseCookie(cookie, parsedCookies, false, true);
    }

    private static void parseCookie(String cookie, Map<String, Cookie> parsedCookies, boolean allowEqualInValue, boolean commaIsSeperator) {
        int state = 0;
        String name = null;
        int start = 0;
        boolean containsEscapedQuotes = false;
        HashMap<String, String> cookies = new HashMap<String, String>();
        HashMap<String, String> additional = new HashMap<String, String>();
        block7: for (int i = 0; i < cookie.length(); ++i) {
            char c = cookie.charAt(i);
            switch (state) {
                case 0: {
                    if (c == ' ' || c == '\t' || c == ';') {
                        start = i + 1;
                        continue block7;
                    }
                    state = 1;
                }
                case 1: {
                    if (c == '=') {
                        name = cookie.substring(start, i);
                        start = i + 1;
                        state = 2;
                        continue block7;
                    }
                    if (c != ';' && (!commaIsSeperator || c != ',')) continue block7;
                    if (name != null) {
                        HttpUtils.createCookie(name, cookie.substring(start, i), cookies, additional);
                    }
                    state = 0;
                    start = i + 1;
                    continue block7;
                }
                case 2: {
                    if (c == ';' || commaIsSeperator && c == ',') {
                        HttpUtils.createCookie(name, cookie.substring(start, i), cookies, additional);
                        state = 0;
                        start = i + 1;
                        continue block7;
                    }
                    if (c == '\"' && start == i) {
                        containsEscapedQuotes = false;
                        state = 3;
                        start = i + 1;
                        continue block7;
                    }
                    if (allowEqualInValue || c != '=') continue block7;
                    HttpUtils.createCookie(name, cookie.substring(start, i), cookies, additional);
                    state = 4;
                    start = i + 1;
                    continue block7;
                }
                case 3: {
                    if (c == '\"') {
                        HttpUtils.createCookie(name, containsEscapedQuotes ? HttpUtils.unescapeDoubleQuotes(cookie.substring(start, i)) : cookie.substring(start, i), cookies, additional);
                        state = 0;
                        start = i + 1;
                    }
                    if (c != '\\' || i + 1 >= cookie.length() || cookie.charAt(i + 1) != '\"' || i + 2 == cookie.length() || i + 2 < cookie.length() && (cookie.charAt(i + 2) == ';' || commaIsSeperator && cookie.charAt(i + 2) == ',')) continue block7;
                    ++i;
                    containsEscapedQuotes = true;
                    continue block7;
                }
                case 4: {
                    if (c == ';' || commaIsSeperator && c == ',') {
                        state = 0;
                    }
                    start = i + 1;
                }
            }
        }
        if (state == 2) {
            HttpUtils.createCookie(name, cookie.substring(start), cookies, additional);
        }
        for (Map.Entry entry : cookies.entrySet()) {
            String path;
            String version;
            Cookie c = new Cookie((String)entry.getKey(), (String)entry.getValue());
            String domain = (String)additional.get("$Domain");
            if (domain != null) {
                c.setDomain(domain);
            }
            if ((version = (String)additional.get("$Version")) != null) {
                c.setVersion(Integer.parseInt(version));
            }
            if ((path = (String)additional.get("$Path")) != null) {
                c.setPath(path);
            }
            parsedCookies.put(c.getName(), c);
        }
    }

    private static void createCookie(String name, String value, Map<String, String> cookies, Map<String, String> additional) {
        if (!name.isEmpty() && name.charAt(0) == '$') {
            if (!additional.containsKey(name)) {
                additional.put(name, value);
            }
        } else if (!cookies.containsKey(name)) {
            cookies.put(name, value);
        }
    }

    private static String unescapeDoubleQuotes(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        char[] tmp = new char[value.length()];
        int dest = 0;
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == '\\' && i + 1 < value.length() && value.charAt(i + 1) == '\"') {
                ++i;
            }
            tmp[dest] = value.charAt(i);
            ++dest;
        }
        return new String(tmp, 0, dest);
    }
}

