/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common;

import java.util.Date;
import org.smartboot.http.common.utils.DateUtils;
import org.smartboot.http.common.utils.StringUtils;

public class Cookie {
    public static final String DOMAIN = "$Domain";
    public static final String VERSION = "$Version";
    public static final String PATH = "$Path";
    private final String name;
    private String value;
    private String path;
    private String domain;
    private int maxAge = -1;
    private Date expires;
    private boolean secure;
    private boolean httpOnly;
    private int version = 0;
    private String comment;

    public Cookie(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public Cookie(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Cookie setValue(String value) {
        this.value = value;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public Cookie setPath(String path) {
        this.path = path;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public Cookie setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public Cookie setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public Cookie setSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public int getVersion() {
        return this.version;
    }

    public Cookie setVersion(int version) {
        this.version = version;
        return this;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public Cookie setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    public Date getExpires() {
        return this.expires;
    }

    public Cookie setExpires(Date expires) {
        this.expires = expires;
        return this;
    }

    public String getComment() {
        return this.comment;
    }

    public Cookie setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append('=').append(this.getValue());
        if (StringUtils.isNotBlank(this.getPath())) {
            sb.append("; Path=").append(this.getPath());
        }
        if (StringUtils.isNotBlank(this.domain)) {
            sb.append("; Domain=").append(this.domain);
        }
        if (this.expires != null) {
            sb.append("; Expires=");
            sb.append(DateUtils.formatCookieExpire(this.expires));
        } else if (this.maxAge >= 0) {
            sb.append("; Max-Age=").append(this.maxAge);
            Date expires = new Date();
            expires.setTime(expires.getTime() + (long)this.maxAge * 1000L);
            sb.append("; Expires=");
            sb.append(DateUtils.formatCookieExpire(expires));
        }
        if (this.secure) {
            sb.append("; Secure");
        }
        if (this.httpOnly) {
            sb.append("; HttpOnly");
        }
        return sb.toString();
    }
}

