/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import org.smartboot.http.common.Reset;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.utils.Constant;
import org.smartboot.socket.transport.AioSession;
import org.smartboot.socket.transport.WriteBuffer;

public abstract class BufferOutputStream
extends OutputStream
implements Reset {
    private static final Map<String, byte[]> HEADER_NAME_EXT_MAP = new ConcurrentHashMap<String, byte[]>();
    protected final AioSession session;
    protected final WriteBuffer writeBuffer;
    protected boolean committed = false;
    protected boolean chunkedSupport = true;
    private boolean closed = false;

    public BufferOutputStream(AioSession session) {
        this.session = session;
        this.writeBuffer = session.writeBuffer();
    }

    @Override
    public final void write(int b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeHeader(HeaderWriteSource.WRITE);
        if (len == 0) {
            return;
        }
        if (this.chunkedSupport) {
            byte[] start = (Integer.toHexString(len) + "\r\n").getBytes();
            this.writeBuffer.write(start);
            this.writeBuffer.write(b, off, len);
            this.writeBuffer.write(Constant.CRLF_BYTES);
        } else {
            this.writeBuffer.write(b, off, len);
        }
    }

    public final void write(byte[] b, int off, int len, Consumer<BufferOutputStream> consumer) throws IOException {
        this.writeHeader(HeaderWriteSource.WRITE);
        if (this.chunkedSupport) {
            byte[] start = (Integer.toHexString(len) + "\r\n").getBytes();
            this.writeBuffer.write(start);
            this.writeBuffer.write(b, off, len);
            this.writeBuffer.write(Constant.CRLF_BYTES, 0, 2, writeBuffer -> consumer.accept(this));
        } else {
            this.writeBuffer.write(b, off, len, writeBuffer -> consumer.accept(this));
        }
    }

    @Override
    public final void flush() throws IOException {
        this.writeHeader(HeaderWriteSource.FLUSH);
        this.writeBuffer.flush();
    }

    @Override
    public final void close() throws IOException {
        if (this.closed) {
            throw new IOException("outputStream has already closed");
        }
        this.writeHeader(HeaderWriteSource.CLOSE);
        if (this.chunkedSupport) {
            this.writeBuffer.write(Constant.CHUNKED_END_BYTES);
        }
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final byte[] getHeaderNameBytes(String name) {
        HeaderNameEnum headerNameEnum = HeaderNameEnum.HEADER_NAME_ENUM_MAP.get(name);
        if (headerNameEnum != null) {
            return headerNameEnum.getBytesWithColon();
        }
        byte[] extBytes = HEADER_NAME_EXT_MAP.get(name);
        if (extBytes == null) {
            String string = name;
            synchronized (string) {
                extBytes = this.getBytes(name + ":");
                HEADER_NAME_EXT_MAP.put(name, extBytes);
            }
        }
        return extBytes;
    }

    protected final byte[] getBytes(String str) {
        return str.getBytes(StandardCharsets.US_ASCII);
    }

    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public final void reset() {
        this.closed = false;
        this.committed = false;
        this.chunkedSupport = true;
    }

    protected abstract void writeHeader(HeaderWriteSource var1) throws IOException;

    public void disableChunked() {
        this.chunkedSupport = false;
    }

    protected static enum HeaderWriteSource {
        WRITE,
        FLUSH,
        CLOSE;

    }

    protected static class WriteCache {
        private final byte[] cacheData;
        private final Semaphore semaphore = new Semaphore(1);
        private long expireTime;

        public WriteCache(long cacheTime, byte[] data) {
            this.expireTime = cacheTime;
            this.cacheData = data;
        }

        public long getExpireTime() {
            return this.expireTime;
        }

        public void setExpireTime(long expireTime) {
            this.expireTime = expireTime;
        }

        public Semaphore getSemaphore() {
            return this.semaphore;
        }

        public byte[] getCacheData() {
            return this.cacheData;
        }
    }
}

