/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.schedule.quartz.spring;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.quartz.Job;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;
import org.smallmind.schedule.quartz.spring.FormattedSchedulerException;
import org.springframework.context.ApplicationContext;

public class SpringJobFactory
implements JobFactory {
    private final ApplicationContext applicationContext;

    public SpringJobFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public synchronized void close() throws IOException {
        if (this.applicationContext != null && Closeable.class.isAssignableFrom(this.applicationContext.getClass())) {
            ((Closeable)this.applicationContext).close();
        }
    }

    public synchronized Job newJob(TriggerFiredBundle bundle, Scheduler scheduler) throws SchedulerException {
        Map jobMap = this.applicationContext.getBeansOfType(bundle.getJobDetail().getJobClass());
        if (jobMap.size() == 0) {
            throw new FormattedSchedulerException("No job(%s) of type(%s) is present in the application context", bundle.getJobDetail().getKey(), bundle.getJobDetail().getJobClass().getName());
        }
        if (jobMap.size() == 1) {
            Map.Entry jobEntry = jobMap.entrySet().iterator().next();
            if (!this.applicationContext.isPrototype((String)jobEntry.getKey())) {
                throw new FormattedSchedulerException("The matching job(%s) with id(%s) in the application context is not a prototype bean", bundle.getJobDetail().getKey(), jobEntry.getKey());
            }
            return (Job)jobEntry.getValue();
        }
        for (Map.Entry jobEntry : jobMap.entrySet()) {
            if (!((String)jobEntry.getKey()).equals(bundle.getJobDetail().getKey().toString())) continue;
            if (!this.applicationContext.isPrototype((String)jobEntry.getKey())) {
                throw new FormattedSchedulerException("The matching job(%s) with id(%s) in the application context is not a prototype bean", bundle.getJobDetail().getKey(), jobEntry.getKey());
            }
            return (Job)jobEntry.getValue();
        }
        throw new FormattedSchedulerException("Multiple jobs of type(%s) are present in the application context, but none with an exact id(%s)", bundle.getJobDetail().getJobClass().getName(), bundle.getJobDetail().getKey());
    }
}

