/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.schedule.quartz.spring;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.smallmind.scribe.pen.LoggerManager;
import org.springframework.beans.factory.InitializingBean;

public class CronJobInitializingBean
implements InitializingBean {
    private final HashMap<JobDetail, List<CronTrigger>> jobMap = new HashMap();
    private Scheduler scheduler;

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setJobMap(Map<JobDetail, List<CronTrigger>> jobMap) {
        this.jobMap.putAll(jobMap);
    }

    public void afterPropertiesSet() {
        for (JobDetail jobDetail : this.jobMap.keySet()) {
            for (CronTrigger cronTrigger : this.jobMap.get(jobDetail)) {
                try {
                    JobDetail installedJobDetail = this.scheduler.getJobDetail(jobDetail.getKey());
                    if (installedJobDetail == null) {
                        this.scheduler.addJob(jobDetail, false);
                    } else if (!this.isSame(jobDetail, installedJobDetail)) {
                        this.scheduler.addJob(jobDetail, true);
                    }
                    CronTrigger installedCronTrigger = (CronTrigger)this.scheduler.getTrigger(cronTrigger.getKey());
                    if (installedCronTrigger == null) {
                        this.scheduler.scheduleJob((Trigger)cronTrigger);
                        continue;
                    }
                    if (cronTrigger.getCronExpression().equals(installedCronTrigger.getCronExpression())) continue;
                    this.scheduler.rescheduleJob(installedCronTrigger.getKey(), (Trigger)cronTrigger);
                }
                catch (Exception exception) {
                    LoggerManager.getLogger(CronJobInitializingBean.class).error((Throwable)exception);
                }
            }
        }
    }

    private boolean isSame(JobDetail jobDetail, JobDetail installedJobDetail) {
        String[] installedKeys;
        if (jobDetail.isDurable() != installedJobDetail.isDurable()) {
            return false;
        }
        if (jobDetail.requestsRecovery() != installedJobDetail.requestsRecovery()) {
            return false;
        }
        if (jobDetail.isConcurrentExectionDisallowed() != installedJobDetail.isConcurrentExectionDisallowed()) {
            return false;
        }
        if (jobDetail.isPersistJobDataAfterExecution() != installedJobDetail.isPersistJobDataAfterExecution()) {
            return false;
        }
        String[] detailKeys = jobDetail.getJobDataMap().getKeys();
        if (detailKeys.length != (installedKeys = installedJobDetail.getJobDataMap().getKeys()).length) {
            return false;
        }
        for (String detailKey : detailKeys) {
            boolean match = false;
            for (String installedKey : installedKeys) {
                if (!detailKey.equals(installedKey)) continue;
                match = true;
                break;
            }
            if (!match) {
                return false;
            }
            Object detailValue = jobDetail.getJobDataMap().get((Object)detailKey);
            Object installedDetailValue = installedJobDetail.getJobDataMap().get((Object)detailKey);
            if (detailValue == null && installedDetailValue != null) {
                return false;
            }
            if (detailValue != null && installedDetailValue == null) {
                return false;
            }
            if (detailValue == null || detailValue.equals(installedDetailValue)) continue;
            return false;
        }
        return true;
    }
}

