/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.schedule.quartz.jmx;

import javax.management.StandardMBean;
import org.quartz.Scheduler;
import org.smallmind.schedule.quartz.jmx.SchedulerMXBean;
import org.smallmind.schedule.quartz.jmx.SchedulerStatus;

public class SchedulerMonitor
extends StandardMBean
implements SchedulerMXBean {
    private final Scheduler scheduler;

    public SchedulerMonitor(Scheduler scheduler) {
        super(SchedulerMXBean.class, true);
        this.scheduler = scheduler;
    }

    @Override
    public void start() throws Exception {
        this.scheduler.start();
    }

    @Override
    public void standby() throws Exception {
        this.scheduler.standby();
    }

    @Override
    public SchedulerStatus status() throws Exception {
        if (this.scheduler.isInStandbyMode()) {
            return SchedulerStatus.STANDBY;
        }
        if (this.scheduler.isStarted()) {
            return SchedulerStatus.STARTED;
        }
        if (this.scheduler.isShutdown()) {
            return SchedulerStatus.SHUTDOWN;
        }
        return SchedulerStatus.UNKNOWN;
    }
}

