/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.schedule.quartz;

import java.util.Date;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReference;
import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.smallmind.nutsnbolts.util.SuccessOrFailure;
import org.smallmind.schedule.base.ProxyJob;
import org.smallmind.scribe.pen.Level;
import org.smallmind.scribe.pen.LoggerManager;

public abstract class QuartzProxyJob
implements ProxyJob,
InterruptableJob {
    private final AtomicReference<Thread> threadRef = new AtomicReference();
    private final AtomicReference<SuccessOrFailure> statusRef = new AtomicReference<SuccessOrFailure>(SuccessOrFailure.SUCCESS);
    private final LinkedList<Throwable> throwableList = new LinkedList();
    private Date startTime;
    private Date stopTime;
    private int count = 0;

    public boolean isEnabled() {
        return true;
    }

    public SuccessOrFailure getJobStatus() {
        return this.statusRef.get();
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getStopTime() {
        return this.stopTime;
    }

    public synchronized void incCount() {
        ++this.count;
    }

    public synchronized void addToCount(int additional) {
        this.count += additional;
    }

    public synchronized int getCount() {
        return this.count;
    }

    public synchronized Throwable[] getThrowables() {
        if (!this.throwableList.isEmpty()) {
            Throwable[] throwables = new Exception[this.throwableList.size()];
            this.throwableList.toArray(throwables);
            return throwables;
        }
        return null;
    }

    public synchronized void setThrowable(Throwable throwable) {
        this.setThrowable(throwable, true);
    }

    public synchronized void setThrowable(Throwable throwable, boolean isFailure) {
        this.throwableList.add(throwable);
        if (isFailure) {
            this.statusRef.set(SuccessOrFailure.FAILURE);
        }
        LoggerManager.getLogger(this.getClass()).error(throwable);
    }

    public void interrupt() {
        Thread thread = this.threadRef.get();
        if (thread != null) {
            thread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(JobExecutionContext jobExecutionContext) {
        block27: {
            if (this.isEnabled()) {
                this.startTime = new Date();
                this.threadRef.set(Thread.currentThread());
                this.proceed();
                this.threadRef.set(null);
                this.stopTime = new Date();
                SuccessOrFailure status = this.statusRef.get();
                if (SuccessOrFailure.INTERRUPTED.equals((Object)status)) {
                    LoggerManager.getLogger(this.getClass()).info("Job(%s) start(%s) has been interrupted", new Object[]{this.getClass().getSimpleName(), this.startTime, this.stopTime, this.count, status.name()});
                } else if (SuccessOrFailure.FAILURE.equals((Object)status) || this.count > 0 || this.logOnZeroCount()) {
                    LoggerManager.getLogger(this.getClass()).log(SuccessOrFailure.FAILURE.equals((Object)status) ? Level.WARN : Level.INFO, "Job(%s) start(%s) stop(%s) count(%d) state(%s)", new Object[]{this.getClass().getSimpleName(), this.startTime, this.stopTime, this.count, status.name()});
                }
                try {
                    this.cleanup();
                }
                catch (Exception exception) {
                    LoggerManager.getLogger(this.getClass()).error((Throwable)exception);
                }
                break block27;
                catch (InterruptedException interruptedException) {
                    this.statusRef.set(SuccessOrFailure.INTERRUPTED);
                    this.threadRef.set(null);
                    this.stopTime = new Date();
                    status = this.statusRef.get();
                    if (SuccessOrFailure.INTERRUPTED.equals((Object)status)) {
                        LoggerManager.getLogger(this.getClass()).info("Job(%s) start(%s) has been interrupted", new Object[]{this.getClass().getSimpleName(), this.startTime, this.stopTime, this.count, status.name()});
                    } else if (SuccessOrFailure.FAILURE.equals((Object)status) || this.count > 0 || this.logOnZeroCount()) {
                        LoggerManager.getLogger(this.getClass()).log(SuccessOrFailure.FAILURE.equals((Object)status) ? Level.WARN : Level.INFO, "Job(%s) start(%s) stop(%s) count(%d) state(%s)", new Object[]{this.getClass().getSimpleName(), this.startTime, this.stopTime, this.count, status.name()});
                    }
                    try {
                        this.cleanup();
                    }
                    catch (Exception exception) {
                        LoggerManager.getLogger(this.getClass()).error((Throwable)exception);
                    }
                }
                catch (Exception exception) {
                    this.setThrowable(exception);
                    this.threadRef.set(null);
                    this.stopTime = new Date();
                    status = this.statusRef.get();
                    {
                        catch (Throwable throwable) {
                            this.threadRef.set(null);
                            this.stopTime = new Date();
                            SuccessOrFailure status2 = this.statusRef.get();
                            if (SuccessOrFailure.INTERRUPTED.equals((Object)status2)) {
                                LoggerManager.getLogger(this.getClass()).info("Job(%s) start(%s) has been interrupted", new Object[]{this.getClass().getSimpleName(), this.startTime, this.stopTime, this.count, status2.name()});
                            } else if (SuccessOrFailure.FAILURE.equals((Object)status2) || this.count > 0 || this.logOnZeroCount()) {
                                LoggerManager.getLogger(this.getClass()).log(SuccessOrFailure.FAILURE.equals((Object)status2) ? Level.WARN : Level.INFO, "Job(%s) start(%s) stop(%s) count(%d) state(%s)", new Object[]{this.getClass().getSimpleName(), this.startTime, this.stopTime, this.count, status2.name()});
                            }
                            try {
                                this.cleanup();
                            }
                            catch (Exception exception2) {
                                LoggerManager.getLogger(this.getClass()).error((Throwable)exception2);
                            }
                            throw throwable;
                        }
                    }
                    if (SuccessOrFailure.INTERRUPTED.equals((Object)status)) {
                        LoggerManager.getLogger(this.getClass()).info("Job(%s) start(%s) has been interrupted", new Object[]{this.getClass().getSimpleName(), this.startTime, this.stopTime, this.count, status.name()});
                    } else if (SuccessOrFailure.FAILURE.equals((Object)status) || this.count > 0 || this.logOnZeroCount()) {
                        LoggerManager.getLogger(this.getClass()).log(SuccessOrFailure.FAILURE.equals((Object)status) ? Level.WARN : Level.INFO, "Job(%s) start(%s) stop(%s) count(%d) state(%s)", new Object[]{this.getClass().getSimpleName(), this.startTime, this.stopTime, this.count, status.name()});
                    }
                    try {
                        this.cleanup();
                    }
                    catch (Exception exception3) {
                        LoggerManager.getLogger(this.getClass()).error((Throwable)exception3);
                    }
                }
            }
        }
    }
}

