/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.converter.line;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.converter.line.ConversionRule;

public class MultiGroupConversionRule
implements ConversionRule {
    private static final int MAX_GROUPS = 10;
    private Pattern pattern;
    private String[] replacementTable = new String[10];

    public MultiGroupConversionRule(Pattern pattern) {
        this.pattern = pattern;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void addReplacement(int groupIndex, String replacement) {
        if (groupIndex == 0) {
            throw new IllegalArgumentException("regex groups start at 1, not zero");
        }
        this.replacementTable[groupIndex] = replacement;
    }

    public String getReplacement(int groupIndex) {
        return this.replacementTable[groupIndex];
    }

    public String replace(Matcher matcher) {
        StringBuffer replacementBuffer = new StringBuffer();
        for (int group = 1; group <= matcher.groupCount(); ++group) {
            String replacementText = this.getReplacement(group);
            if (replacementText != null) {
                System.out.println("replacing group " + group + " : " + matcher.group(group) + " with " + replacementText);
                replacementBuffer.append(replacementText);
                continue;
            }
            replacementBuffer.append(matcher.group(group));
        }
        return replacementBuffer.toString();
    }

    public String getAdditionalLine() {
        return null;
    }
}

