/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.converter.line;

import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.converter.line.ConversionRule;
import org.slf4j.converter.line.RuleSet;

public class LineConverter {
    final RuleSet ruleSet;
    boolean atLeastOneMatchOccured = false;

    public LineConverter(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    public String[] getReplacement(String text) {
        Iterator<ConversionRule> conversionRuleIterator = this.ruleSet.iterator();
        String additionalLine = null;
        while (conversionRuleIterator.hasNext()) {
            ConversionRule conversionRule = conversionRuleIterator.next();
            Pattern pattern = conversionRule.getPattern();
            Matcher matcher = pattern.matcher(text);
            if (!matcher.find()) continue;
            this.atLeastOneMatchOccured = true;
            String replacementText = conversionRule.replace(matcher);
            text = matcher.replaceAll(replacementText);
            if (conversionRule.getAdditionalLine() == null) continue;
            additionalLine = conversionRule.getAdditionalLine();
        }
        if (additionalLine == null) {
            return new String[]{text};
        }
        return new String[]{text, additionalLine};
    }

    public String getOneLineReplacement(String text) {
        Object[] r = this.getReplacement(text);
        if (r.length != 1) {
            throw new IllegalStateException("Expecting a single string but got " + Arrays.toString(r));
        }
        return r[0];
    }

    public boolean atLeastOneMatchOccured() {
        return this.atLeastOneMatchOccured;
    }
}

