/*
 * Decompiled with CFR 0.152.
 */
package skinny.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.pattern.CompositeConverter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import skinny.logging.ansi.AnsiElement;
import skinny.logging.ansi.AnsiOutput;

public class ColorConverter
extends CompositeConverter<ILoggingEvent> {
    private static final Map<String, AnsiElement> ELEMENTS;
    private static final Map<Integer, AnsiElement> LEVELS;

    protected String transform(ILoggingEvent iLoggingEvent, String string) {
        AnsiElement ansiElement = ELEMENTS.get(this.getFirstOption());
        if (ansiElement == null) {
            ansiElement = LEVELS.get(iLoggingEvent.getLevel().toInteger());
            ansiElement = ansiElement == null ? AnsiElement.GREEN : ansiElement;
        }
        return this.toAnsiString(string, ansiElement);
    }

    protected String toAnsiString(String string, AnsiElement ansiElement) {
        return AnsiOutput.toString(ansiElement, string);
    }

    static {
        HashMap<Object, AnsiElement> hashMap = new HashMap<Object, AnsiElement>();
        hashMap.put("faint", AnsiElement.FAINT);
        hashMap.put("red", AnsiElement.RED);
        hashMap.put("green", AnsiElement.GREEN);
        hashMap.put("yellow", AnsiElement.YELLOW);
        hashMap.put("blue", AnsiElement.BLUE);
        hashMap.put("magenta", AnsiElement.MAGENTA);
        hashMap.put("cyan", AnsiElement.CYAN);
        ELEMENTS = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap();
        hashMap.put(Level.ERROR_INTEGER, AnsiElement.RED);
        hashMap.put(Level.WARN_INTEGER, AnsiElement.YELLOW);
        LEVELS = Collections.unmodifiableMap(hashMap);
    }
}

