/*
 * Decompiled with CFR 0.152.
 */
package skinny.logging.ansi;

import skinny.logging.ansi.AnsiElement;

public abstract class AnsiOutput {
    private static final String ENCODE_JOIN = ";";
    private static Enabled enabled = Enabled.DETECT;
    private static final String OPERATING_SYSTEM_NAME = System.getProperty("os.name").toLowerCase();
    private static final String ENCODE_START = "\u001b[";
    private static final String ENCODE_END = "m";
    private static final String RESET = "0;" + AnsiElement.DEFAULT;

    public static void setEnabled(Enabled enabled) {
        AnsiOutput.enabled = enabled;
    }

    public static String toString(Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (AnsiOutput.isEnabled()) {
            AnsiOutput.buildEnabled(stringBuilder, objectArray);
        } else {
            AnsiOutput.buildDisabled(stringBuilder, objectArray);
        }
        return stringBuilder.toString();
    }

    private static void buildEnabled(StringBuilder stringBuilder, Object[] objectArray) {
        boolean bl = false;
        boolean bl2 = false;
        for (Object object : objectArray) {
            if (object instanceof AnsiElement) {
                bl2 = true;
                if (!bl) {
                    stringBuilder.append(ENCODE_START);
                    bl = true;
                } else {
                    stringBuilder.append(ENCODE_JOIN);
                }
            } else if (bl) {
                stringBuilder.append(ENCODE_END);
                bl = false;
            }
            stringBuilder.append(object);
        }
        if (bl2) {
            stringBuilder.append(bl ? ENCODE_JOIN : ENCODE_START);
            stringBuilder.append(RESET);
            stringBuilder.append(ENCODE_END);
        }
    }

    private static void buildDisabled(StringBuilder stringBuilder, Object[] objectArray) {
        for (Object object : objectArray) {
            if (object instanceof AnsiElement || object == null) continue;
            stringBuilder.append(object);
        }
    }

    private static boolean isEnabled() {
        if (enabled == Enabled.DETECT) {
            return AnsiOutput.detectIfEnabled();
        }
        return enabled == Enabled.ALWAYS;
    }

    private static boolean detectIfEnabled() {
        try {
            if (System.console() == null) {
                return false;
            }
            return OPERATING_SYSTEM_NAME.indexOf("win") < 0;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static enum Enabled {
        DETECT,
        ALWAYS,
        NEVER;

    }
}

