/*
 * Decompiled with CFR 0.152.
 */
package org.sisioh.dddbase.utils.future.impl;

import java.util.concurrent.ExecutorService;
import org.sisioh.dddbase.utils.Function0;
import org.sisioh.dddbase.utils.Try;
import org.sisioh.dddbase.utils.future.Future;
import org.sisioh.dddbase.utils.future.impl.DefaultPromise;

public final class InternalFutureFactory {
    public static <T> Future<T> create(Function0<T> func, ExecutorService executor) {
        PromiseCompletingRunnable<T> runnable = new PromiseCompletingRunnable<T>(func);
        executor.submit(runnable);
        return ((PromiseCompletingRunnable)runnable).promise.toFuture();
    }

    static class PromiseCompletingRunnable<T>
    implements Runnable {
        private final Function0<T> func;
        private final DefaultPromise<T> promise = new DefaultPromise();

        PromiseCompletingRunnable(Function0<T> func) {
            this.func = func;
        }

        @Override
        public void run() {
            Try<Object> tryA = null;
            try {
                tryA = Try.ofSuccess(this.func.apply());
            }
            catch (RuntimeException e) {
                tryA = Try.ofFailure(e);
            }
            this.promise.complete(tryA);
        }
    }
}

