/*
 * Decompiled with CFR 0.152.
 */
package org.sisioh.dddbase.utils.future.impl;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.sisioh.dddbase.utils.Function1;
import org.sisioh.dddbase.utils.Option;
import org.sisioh.dddbase.utils.Try;
import org.sisioh.dddbase.utils.future.Future;
import org.sisioh.dddbase.utils.future.impl.AbstractPromise;
import org.sisioh.dddbase.utils.future.impl.CallbackRunnable;

public final class DefaultPromise<T>
extends AbstractPromise<T> {
    public DefaultPromise() {
        this.updateState(null, new ArrayList());
    }

    public static class KeptPromise<T>
    extends AbstractPromise<T>
    implements Future<T> {
        private final Try<T> suppliedValue;
        private final Option<Try<T>> value;

        public KeptPromise(Try<T> suppliedValue) {
            this.suppliedValue = suppliedValue;
            this.value = Option.ofSome(AbstractPromise.resolveTry(suppliedValue));
        }

        @Override
        public Option<Try<T>> getValue() {
            return this.value;
        }

        @Override
        public <U> void onComplete(ExecutorService executor, Function1<Try<T>, U> func) {
            Try<T> completedAs = this.value.get();
            new CallbackRunnable<T>(executor, func).executeWithValue(completedAs);
        }

        @Override
        public Future<T> toFuture() {
            return this;
        }

        @Override
        public boolean isCompleted() {
            return true;
        }

        @Override
        public boolean tryComplete(Try<T> result) {
            return false;
        }

        @Override
        public Future<T> ready(Long atMost, TimeUnit unit) throws TimeoutException, InterruptedException {
            return this;
        }

        @Override
        public T result(Long atMost, TimeUnit unit) throws Throwable {
            return this.value.get().get();
        }

        @Override
        public Future<T> ready() throws TimeoutException, InterruptedException {
            return this.ready(null, null);
        }

        @Override
        public T result() throws Throwable {
            return this.result(null, null);
        }
    }
}

