/*
 * Decompiled with CFR 0.152.
 */
package org.sisioh.dddbase.utils.future.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import org.sisioh.dddbase.utils.Function1;
import org.sisioh.dddbase.utils.Option;
import org.sisioh.dddbase.utils.Try;
import org.sisioh.dddbase.utils.Unsafe;
import org.sisioh.dddbase.utils.future.Future;
import org.sisioh.dddbase.utils.future.Promise;
import org.sisioh.dddbase.utils.future.PromiseFactory;
import org.sisioh.dddbase.utils.future.impl.CallbackRunnable;
import org.sisioh.dddbase.utils.future.impl.DefaultPromise;

public abstract class AbstractPromise<T>
implements Promise<T>,
Future<T> {
    private volatile Object _ref;
    static final long _refoffset;
    protected static final AtomicReferenceFieldUpdater<AbstractPromise, Object> updater;
    protected final ExecutorService internalCallbackExecutor = this.getInternalExecutor();

    protected final boolean updateState(Object oldState, Object newState) {
        return Unsafe.instance.compareAndSwapObject(this, _refoffset, oldState, newState);
    }

    protected final Object getState() {
        return this._ref;
    }

    protected ExecutorService getInternalExecutor() {
        return Executors.newCachedThreadPool();
    }

    @Override
    public Promise<T> complete(Try<T> result) {
        if (this.tryComplete(result)) {
            return this;
        }
        throw new IllegalStateException("Promise already completed.");
    }

    @Override
    public Promise<T> completeWith(Future<T> other) {
        other.onComplete(this.internalCallbackExecutor, new Function1<Try<T>, Promise<T>>(){

            @Override
            public Promise<T> apply(Try<T> value) {
                return AbstractPromise.this.complete(value);
            }
        });
        return this;
    }

    @Override
    public Promise<T> tryCompleteWith(Future<T> other) {
        other.onComplete(this.internalCallbackExecutor, new Function1<Try<T>, Boolean>(){

            @Override
            public Boolean apply(Try<T> value) {
                return AbstractPromise.this.tryComplete(value);
            }
        });
        return this;
    }

    @Override
    public Promise<T> success(T value) {
        return this.complete(Try.ofSuccess(value));
    }

    @Override
    public boolean trySuccess(T value) {
        return this.tryComplete(Try.ofSuccess(value));
    }

    @Override
    public Promise<T> failure(RuntimeException cause) {
        Try causeTry = Try.ofFailure(cause);
        return this.complete(causeTry);
    }

    @Override
    public boolean tryFailure(RuntimeException cause) {
        Try causeTry = Try.ofFailure(cause);
        return this.tryComplete(causeTry);
    }

    AbstractPromise<T> root() {
        Object state = this.getState();
        if (state instanceof AbstractPromise) {
            return ((AbstractPromise)state).root();
        }
        return this;
    }

    AbstractPromise<T> compressedRoot() {
        Object state = this.getState();
        if (state instanceof AbstractPromise) {
            AbstractPromise linked = (AbstractPromise)state;
            AbstractPromise<T> target = linked.root();
            if (linked == target) {
                return target;
            }
            if (this.updateState(linked, target)) {
                return target;
            }
            return this.compressedRoot();
        }
        return this;
    }

    void dispatchOrAddCallback(CallbackRunnable<T> runnable) {
        System.out.println("dispatchOrAddCallback - start");
        Object state = this.getState();
        if (state instanceof Try) {
            System.out.println("dispatchOrAddCallback - executeWithValue");
            runnable.executeWithValue((Try)state);
        } else if (state instanceof DefaultPromise) {
            System.out.println("dispatchOrAddCallback - compressedRoot().dispatchOrAddCallback(runnable)");
            this.compressedRoot().dispatchOrAddCallback(runnable);
        } else if (state instanceof List) {
            System.out.println("dispatchOrAddCallback - List");
            List listeners = (List)state;
            ArrayList<CallbackRunnable<T>> values = new ArrayList<CallbackRunnable<T>>(listeners);
            values.add(runnable);
            if (!this.updateState(listeners, values)) {
                this.dispatchOrAddCallback(runnable);
            }
        } else {
            throw new IllegalArgumentException();
        }
        System.out.println("dispatchOrAddCallback - end");
    }

    private Option<Try<T>> value0() {
        Object state = this.getState();
        if (state instanceof Try) {
            Try c = (Try)state;
            return Option.ofSome(c);
        }
        if (state instanceof DefaultPromise) {
            return super.value0();
        }
        return Option.ofNone();
    }

    private boolean isCompleted0() {
        Object state = this.getState();
        if (state instanceof Try) {
            return true;
        }
        if (state instanceof DefaultPromise) {
            return super.isCompleted0();
        }
        return false;
    }

    private List<CallbackRunnable<T>> tryCompleteAndGetListeners(Try<T> v) {
        Object state = this.getState();
        if (state instanceof List) {
            List cur = (List)state;
            if (this.updateState(cur, v)) {
                return cur;
            }
            return this.tryCompleteAndGetListeners(v);
        }
        if (state instanceof DefaultPromise) {
            return super.tryCompleteAndGetListeners(v);
        }
        return null;
    }

    static <T1> Try<T1> resolveTry(Try<T1> source) {
        if (source.isFailure().booleanValue()) {
            return AbstractPromise.resolver(source.getCause());
        }
        return source;
    }

    private static <T> Try<T> resolver(RuntimeException cause) {
        return Try.ofFailure(cause);
    }

    private void link(AbstractPromise<T> target) {
        if (this != target) {
            Object state = this.getState();
            if (state instanceof Try) {
                if (!target.tryComplete((Try)state)) {
                    throw new IllegalStateException("Cannot link completed promises together");
                }
            } else if (state instanceof DefaultPromise) {
                super.link(target);
            } else if (state instanceof List) {
                List listeners = (List)state;
                if (this.updateState(listeners, target)) {
                    for (CallbackRunnable callbackRunnable : listeners) {
                        target.dispatchOrAddCallback(callbackRunnable);
                    }
                } else {
                    this.link(target);
                }
            }
        }
    }

    final void linkRootOf(DefaultPromise<T> target) {
        System.out.println("linkRootOf - start");
        this.link(target.compressedRoot());
        System.out.println("linkRootOf - end");
    }

    @Override
    public <U> void onComplete(ExecutorService executor, Function1<Try<T>, U> func) {
        CallbackRunnable runnable = new CallbackRunnable(executor, func);
        this.dispatchOrAddCallback(runnable);
    }

    @Override
    public boolean tryComplete(Try<T> result) {
        Try<T> resolved = AbstractPromise.resolveTry(result);
        List<CallbackRunnable<T>> callbackRunnables = this.tryCompleteAndGetListeners(resolved);
        if (callbackRunnables == null) {
            return false;
        }
        if (callbackRunnables.isEmpty()) {
            return true;
        }
        for (CallbackRunnable<T> callbackRunnable : callbackRunnables) {
            callbackRunnable.executeWithValue(resolved);
        }
        return true;
    }

    @Override
    public Future<T> toFuture() {
        return this;
    }

    @Override
    public boolean isCompleted() {
        return this.isCompleted0();
    }

    @Override
    public <U> void onSuccess(ExecutorService executor, final Function1<T, U> func) {
        this.onComplete(executor, new Function1<Try<T>, U>(){

            @Override
            public U apply(Try<T> value) {
                if (value.isSuccess().booleanValue()) {
                    try {
                        return func.apply(value.get());
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                }
                return null;
            }
        });
    }

    @Override
    public <U> void onFailure(ExecutorService executor, final Function1<Throwable, U> func) {
        this.onComplete(executor, new Function1<Try<T>, U>(){

            @Override
            public U apply(Try<T> value) {
                if (value.isFailure().booleanValue()) {
                    try {
                        return func.apply(((Try.Failure)value).getCause());
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                }
                return null;
            }
        });
    }

    @Override
    public Option<Try<T>> getValue() {
        return this.value0();
    }

    @Override
    public Future<Throwable> failed() {
        ExecutorService internalExecutor = this.getInternalExecutor();
        final Promise promise = PromiseFactory.create();
        this.onComplete(internalExecutor, new Function1<Try<T>, Object>(){

            @Override
            public Object apply(Try<T> value) {
                if (value.isFailure().booleanValue()) {
                    promise.success(((Try.Failure)value).getCause());
                } else {
                    promise.failure(new NoSuchElementException("Future.failed not completed with a throwable."));
                }
                return null;
            }
        });
        return promise.toFuture();
    }

    @Override
    public <S> Future<S> map(ExecutorService executor, final Function1<T, S> func) {
        final Promise promise = PromiseFactory.create();
        this.onComplete(executor, new Function1<Try<T>, Object>(){

            @Override
            public Object apply(Try<T> value) {
                promise.complete(value.map(func));
                return null;
            }
        });
        return promise.toFuture();
    }

    @Override
    public <S> Future<S> flatMap(ExecutorService executor, final Function1<T, Future<S>> func) {
        final DefaultPromise promise = new DefaultPromise();
        this.onComplete(executor, new Function1<Try<T>, Object>(){

            @Override
            public Object apply(Try<T> value) {
                if (value.isFailure().booleanValue()) {
                    promise.complete((Try.Failure)value);
                } else {
                    try {
                        Future future = (Future)func.apply(value.get());
                        if (future instanceof DefaultPromise) {
                            ((DefaultPromise)future).linkRootOf(promise);
                        } else {
                            future.onComplete(AbstractPromise.this.internalCallbackExecutor, new Function1<Try<S>, Object>(){

                                @Override
                                public Object apply(Try<S> value) {
                                    promise.complete(value);
                                    return null;
                                }
                            });
                        }
                    }
                    catch (RuntimeException e) {
                        promise.failure(e);
                    }
                }
                return null;
            }
        });
        return promise.toFuture();
    }

    @Override
    public <U> void foreach(ExecutorService executor, final Function1<T, U> func) {
        this.onComplete(executor, new Function1<Try<T>, Object>(){

            @Override
            public Object apply(Try<T> value) {
                value.foreach(func);
                return null;
            }
        });
    }

    @Override
    public <U> Future<U> recoverWith(ExecutorService executor, final Function1<Throwable, Future<U>> func) {
        final Promise p = PromiseFactory.create();
        this.onComplete(executor, new Function1<Try<T>, Object>(){

            @Override
            public Object apply(Try<T> value) {
                if (value.isFailure().booleanValue()) {
                    try {
                        ((Future)func.apply(((Try.Failure)value).getCause())).onComplete(AbstractPromise.this.internalCallbackExecutor, new Function1<Try<U>, Object>(){

                            @Override
                            public Object apply(Try<U> value) {
                                return p.complete(value);
                            }
                        });
                    }
                    catch (RuntimeException e) {
                        return p.failure(e);
                    }
                } else {
                    return p.complete(value);
                }
                return null;
            }
        });
        return p.toFuture();
    }

    @Override
    public <U> Future<U> recover(ExecutorService executor, final Function1<Throwable, U> func) {
        final Promise p = PromiseFactory.create();
        this.onComplete(executor, new Function1<Try<T>, Object>(){

            @Override
            public Object apply(Try<T> value) {
                p.complete(value.recover(func));
                return null;
            }
        });
        return p.toFuture();
    }

    protected final boolean tryAwait(Long atMost, TimeUnit unit) throws InterruptedException {
        System.out.println("tryAwait - start");
        if (!this.isCompleted()) {
            if (atMost != null && unit != null) {
                CompletionLatch l = new CompletionLatch();
                System.out.println("tryAwait - onComplete:1 - before");
                this.onComplete(this.internalCallbackExecutor, l);
                System.out.println("tryAwait - onComplete:1 - after");
                System.out.println("tryAwait - l.tryAcquireSharedNanos - before");
                l.tryAcquireSharedNanos(1, unit.toNanos(atMost));
                System.out.println("tryAwait - l.tryAcquireSharedNanos - after");
            } else {
                CompletionLatch l = new CompletionLatch();
                System.out.println("tryAwait - onComplete:2 - before");
                this.onComplete(this.internalCallbackExecutor, l);
                System.out.println("tryAwait - onComplete:2 - after");
                System.out.println("tryAwait - l.acquireSharedInterruptibly - before");
                l.acquireSharedInterruptibly(1);
                System.out.println("tryAwait - l.acquireSharedInterruptibly - after");
            }
            System.out.println("tryAwait - end1");
            return this.isCompleted();
        }
        System.out.println("tryAwait - end2");
        return true;
    }

    @Override
    public Future<T> ready(Long atMost, TimeUnit unit) throws TimeoutException, InterruptedException {
        if (this.tryAwait(atMost, unit)) {
            return this;
        }
        throw new TimeoutException("Futures timed out after [" + atMost + "]");
    }

    @Override
    public Future<T> ready() throws TimeoutException, InterruptedException {
        if (this.tryAwait(null, null)) {
            return this;
        }
        throw new IllegalStateException("Futures were incomplete.");
    }

    @Override
    public T result(Long atMost, TimeUnit unit) throws Throwable {
        return this.ready(atMost, unit).getValue().get().get();
    }

    @Override
    public T result() throws Throwable {
        return this.ready().getValue().get().get();
    }

    static {
        try {
            _refoffset = Unsafe.instance.objectFieldOffset(AbstractPromise.class.getDeclaredField("_ref"));
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError(t);
        }
        updater = AtomicReferenceFieldUpdater.newUpdater(AbstractPromise.class, Object.class, "_ref");
    }

    private static final class CompletionLatch<T>
    extends AbstractQueuedSynchronizer
    implements Function1<Try<T>, Void> {
        private CompletionLatch() {
        }

        @Override
        protected int tryAcquireShared(int arg) {
            if (this.getState() != 0) {
                return 1;
            }
            return -1;
        }

        @Override
        protected boolean tryReleaseShared(int arg) {
            this.setState(1);
            return true;
        }

        @Override
        public Void apply(Try<T> value) {
            System.out.println("apply - start");
            this.releaseShared(1);
            System.out.println("apply - end");
            return null;
        }
    }
}

