/*
 * Decompiled with CFR 0.152.
 */
package org.sisioh.dddbase.utils.future;

import org.sisioh.dddbase.utils.Try;
import org.sisioh.dddbase.utils.future.Promise;
import org.sisioh.dddbase.utils.future.impl.DefaultPromise;

public class PromiseFactory {
    public static <T> Promise<T> create() {
        return new DefaultPromise();
    }

    public static <T> Promise<T> successful(T result) {
        Try<T> resultTry = Try.ofSuccess(result);
        return PromiseFactory.fromTry(resultTry);
    }

    public static <T> Promise<T> failed(RuntimeException exception) {
        Try resultTry = Try.ofFailure(exception);
        return PromiseFactory.fromTry(resultTry);
    }

    public static <T> Promise<T> fromTry(Try<T> result) {
        return new DefaultPromise.KeptPromise<T>(result);
    }

    private PromiseFactory() {
    }
}

