/*
 * Decompiled with CFR 0.152.
 */
package org.sisioh.dddbase.utils;

import org.sisioh.dddbase.utils.Function1;
import org.sisioh.dddbase.utils.Option;

public abstract class Try<T> {
    public static <A> Try<A> ofSuccess(A value) {
        return new Success<A>(value);
    }

    public static <A> Try<A> ofFailure(RuntimeException cause) {
        return new Failure(cause);
    }

    public abstract Boolean isFailure();

    public abstract Boolean isSuccess();

    public abstract RuntimeException getCause();

    public abstract T get();

    public abstract T getOrElse(T var1);

    public abstract <A> Try<A> map(Function1<T, A> var1);

    public abstract <A> Try<A> flatMap(Function1<T, Try<A>> var1);

    public abstract <A> void foreach(Function1<T, A> var1);

    public abstract <U> Try<U> recoverWith(Function1<Throwable, Try<U>> var1);

    public abstract <U> Try<U> recover(Function1<Throwable, U> var1);

    public Option<T> toOption() throws Throwable {
        if (this.isSuccess().booleanValue()) {
            return Option.ofSome(this.get());
        }
        return Option.ofNone();
    }

    public static final class Failure<T>
    extends Try<T> {
        private final RuntimeException cause;

        Failure(RuntimeException cause) {
            if (cause == null) {
                throw new IllegalArgumentException("cause is null.");
            }
            this.cause = cause;
        }

        @Override
        public RuntimeException getCause() {
            return this.cause;
        }

        @Override
        public Boolean isFailure() {
            return true;
        }

        @Override
        public Boolean isSuccess() {
            return false;
        }

        @Override
        public T get() {
            throw this.cause;
        }

        @Override
        public T getOrElse(T defaultValue) {
            return defaultValue;
        }

        @Override
        public <A> Try<A> map(Function1<T, A> mapper) {
            return this;
        }

        @Override
        public <A> Try<A> flatMap(Function1<T, Try<A>> mapper) {
            return this;
        }

        @Override
        public <A> void foreach(Function1<T, A> mapper) {
        }

        @Override
        public <U> Try<U> recoverWith(Function1<Throwable, Try<U>> func) {
            try {
                return func.apply(this.cause);
            }
            catch (RuntimeException e) {
                return Failure.ofFailure(e);
            }
        }

        @Override
        public <U> Try<U> recover(Function1<Throwable, U> func) {
            try {
                return Failure.ofSuccess(func.apply(this.cause));
            }
            catch (RuntimeException e) {
                return Failure.ofFailure(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Failure failure = (Failure)o;
            return !(this.cause != null ? !this.cause.equals(failure.cause) : failure.cause != null);
        }

        public int hashCode() {
            return this.cause != null ? this.cause.hashCode() : 0;
        }

        public String toString() {
            return "Failure{cause=" + this.cause + '}';
        }
    }

    public static final class Success<T>
    extends Try<T> {
        private final T value;

        Success(T value) {
            this.value = value;
        }

        @Override
        public Boolean isFailure() {
            return false;
        }

        @Override
        public Boolean isSuccess() {
            return true;
        }

        @Override
        public RuntimeException getCause() {
            throw new IllegalStateException();
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public T getOrElse(T defaultValue) {
            return this.value;
        }

        @Override
        public <A> Try<A> map(Function1<T, A> mapper) {
            try {
                return Success.ofSuccess(mapper.apply(this.value));
            }
            catch (RuntimeException e) {
                return Success.ofFailure(e);
            }
        }

        @Override
        public <A> Try<A> flatMap(Function1<T, Try<A>> mapper) {
            try {
                return mapper.apply(this.value);
            }
            catch (RuntimeException e) {
                return Success.ofFailure(e);
            }
        }

        @Override
        public <A> void foreach(Function1<T, A> mapper) {
            this.map(mapper);
        }

        @Override
        public <U> Try<U> recoverWith(Function1<Throwable, Try<U>> func) {
            return this;
        }

        @Override
        public <U> Try<U> recover(Function1<Throwable, U> mapper) {
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Success success = (Success)o;
            return !(this.value != null ? !this.value.equals(success.value) : success.value != null);
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }

        public String toString() {
            return "Success{value=" + this.value + '}';
        }
    }
}

