/*
 * Decompiled with CFR 0.152.
 */
package org.sisioh.dddbase.utils;

import java.util.NoSuchElementException;
import org.sisioh.dddbase.utils.Function1;

public abstract class Option<T> {
    public abstract boolean isDefined();

    public abstract T get();

    public abstract T getOrElse(T var1);

    public abstract <A> Option<A> map(Function1<T, A> var1);

    public abstract <A> Option<A> flatMap(Function1<T, Option<A>> var1);

    public static <A> Option<A> ofSome(A value) {
        return new Some<A>(value);
    }

    public static <A> Option<A> ofNone() {
        return new None();
    }

    public static final class None<T>
    extends Option<T> {
        None() {
        }

        @Override
        public boolean isDefined() {
            return false;
        }

        @Override
        public T get() {
            throw new NoSuchElementException();
        }

        @Override
        public T getOrElse(T defaultValue) {
            return defaultValue;
        }

        @Override
        public <A> Option<A> map(Function1<T, A> mapper) {
            return this;
        }

        @Override
        public <A> Option<A> flatMap(Function1<T, Option<A>> mapper) {
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return 0;
        }
    }

    public static final class Some<T>
    extends Option<T> {
        private final T value;

        Some(T value) {
            this.value = value;
        }

        @Override
        public boolean isDefined() {
            return true;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public T getOrElse(T defaultValue) {
            return this.value;
        }

        @Override
        public <A> Option<A> map(Function1<T, A> mapper) {
            return Some.ofSome(mapper.apply(this.value));
        }

        @Override
        public <A> Option<A> flatMap(Function1<T, Option<A>> mapper) {
            return mapper.apply(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Some some = (Some)o;
            return !(this.value != null ? !this.value.equals(some.value) : some.value != null);
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }
}

