/*
 * Decompiled with CFR 0.152.
 */
package org.sisioh.dddbase.lifecycle;

import java.util.ArrayList;
import java.util.List;

public abstract class ValueObjectBuilder<T, S extends ValueObjectBuilder<T, S>> {
    List<BuilderConfigurator<S>> configurators = new ArrayList<BuilderConfigurator<S>>();

    protected void addConfigurator(BuilderConfigurator<S> configurator) {
        this.configurators.add(configurator);
    }

    public T apply(T vo) {
        S builder = this.newInstance();
        this.apply(vo, builder);
        for (BuilderConfigurator<S> configurator : this.configurators) {
            ((ValueObjectBuilder)builder).addConfigurator(configurator);
        }
        return ((ValueObjectBuilder)builder).build();
    }

    protected abstract void apply(T var1, S var2);

    public T build() {
        for (BuilderConfigurator<S> configurator : this.configurators) {
            configurator.configure(this.getThis());
        }
        return this.createValueObject();
    }

    protected abstract T createValueObject();

    protected abstract S getThis();

    protected abstract S newInstance();

    public static interface BuilderConfigurator<S> {
        public void configure(S var1);
    }
}

