/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.sign;

import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.File;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import lombok.Generated;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.simplify4u.plugins.sign.SignMojoException;
import org.simplify4u.plugins.sign.openpgp.PGPKeyInfo;
import org.simplify4u.plugins.sign.utils.Environment;
import org.simplify4u.plugins.sign.utils.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;

@Singleton
@Named
public class KeyInfoFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyInfoFactory.class);
    private static final String SIGN_KEY_ID_ENV = "SIGN_KEY_ID";
    private static final String SIGN_KEY_ENV = "SIGN_KEY";
    private static final String SIGN_KEY_PASS_ENV = "SIGN_KEY_PASS";
    @Inject
    private Environment environment;
    @Inject
    private SecDispatcher secDispatcher;
    @Inject
    private MavenSession mavenSession;

    public PGPKeyInfo buildKeyInfo(KeyInfoRequest keyInfoRequest) {
        File keyFile;
        String pass;
        String id;
        if (keyInfoRequest.getServerId() != null) {
            Settings settings = this.mavenSession.getSettings();
            Optional<Server> server = Optional.ofNullable(settings.getServer(keyInfoRequest.getServerId()));
            if (server.isPresent()) {
                LOGGER.debug("server id: {} found - read key info from settings.xml", (Object)keyInfoRequest.getServerId());
            } else {
                LOGGER.debug("server id: {} not found in settings.xml", (Object)keyInfoRequest.getServerId());
            }
            id = server.map(Server::getUsername).orElse(null);
            pass = server.map(Server::getPassphrase).orElse(null);
            keyFile = server.map(Server::getPrivateKey).map(File::new).orElse(null);
        } else {
            id = keyInfoRequest.getId();
            pass = keyInfoRequest.getPass();
            keyFile = keyInfoRequest.getFile();
        }
        return PGPKeyInfo.builder().id(this.resolveKeyId(id)).pass(this.resolveKeyPass(pass)).key(this.resolveKey(keyFile)).build();
    }

    private Long resolveKeyId(String id) {
        return Optional.ofNullable(this.environment.getEnv(SIGN_KEY_ID_ENV).orElse(id)).map(KeyInfoFactory::parseKeyId).orElse(null);
    }

    private String resolveKeyPass(String pass) {
        return Optional.ofNullable(this.environment.getEnv(SIGN_KEY_PASS_ENV).orElse(pass)).map(this::decryptPass).orElse(null);
    }

    private byte[] resolveKey(File keyFile) {
        return this.environment.getEnv(SIGN_KEY_ENV).map(String::trim).map(KeyInfoFactory::keyFromString).orElseGet(() -> KeyInfoFactory.keyFromFile(keyFile));
    }

    private String decryptPass(String pass) {
        return (String)Try.of((CheckedFunction0 & Serializable)() -> this.secDispatcher.decrypt(pass)).getOrElseThrow(e -> new SignMojoException("Invalid encrypted password: " + e.getMessage()));
    }

    private static long parseKeyId(String key) {
        return (Long)Try.of((CheckedFunction0 & Serializable)() -> new BigInteger(key, 16)).map(BigInteger::longValue).getOrElseThrow(e -> new SignMojoException("Invalid keyId: " + e.getMessage()));
    }

    private static byte[] keyFromString(String key) {
        return key.getBytes(StandardCharsets.US_ASCII);
    }

    private static byte[] keyFromFile(File keyFile) {
        if (keyFile != null) {
            File file = FileUtil.calculateWithUserHome(keyFile);
            if (file.exists()) {
                LOGGER.debug("Read key from file: {}", (Object)file);
                return (byte[])Try.of((CheckedFunction0 & Serializable)() -> Files.readAllBytes(file.toPath())).get();
            }
            LOGGER.debug("Key file: {} not exist", (Object)keyFile);
        } else {
            LOGGER.debug("Key file not provided");
        }
        return new byte[0];
    }

    public static final class KeyInfoRequest {
        private final String serverId;
        private final String id;
        private final String pass;
        private final File file;

        @Generated
        KeyInfoRequest(String serverId, String id, String pass, File file) {
            this.serverId = serverId;
            this.id = id;
            this.pass = pass;
            this.file = file;
        }

        @Generated
        public static KeyInfoRequestBuilder builder() {
            return new KeyInfoRequestBuilder();
        }

        @Generated
        public String getServerId() {
            return this.serverId;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getPass() {
            return this.pass;
        }

        @Generated
        public File getFile() {
            return this.file;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeyInfoRequest)) {
                return false;
            }
            KeyInfoRequest other = (KeyInfoRequest)o;
            String this$serverId = this.getServerId();
            String other$serverId = other.getServerId();
            if (this$serverId == null ? other$serverId != null : !this$serverId.equals(other$serverId)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$pass = this.getPass();
            String other$pass = other.getPass();
            if (this$pass == null ? other$pass != null : !this$pass.equals(other$pass)) {
                return false;
            }
            File this$file = this.getFile();
            File other$file = other.getFile();
            return !(this$file == null ? other$file != null : !((Object)this$file).equals(other$file));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $serverId = this.getServerId();
            result = result * 59 + ($serverId == null ? 43 : $serverId.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $pass = this.getPass();
            result = result * 59 + ($pass == null ? 43 : $pass.hashCode());
            File $file = this.getFile();
            result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "KeyInfoFactory.KeyInfoRequest(serverId=" + this.getServerId() + ", id=" + this.getId() + ", pass=" + this.getPass() + ", file=" + this.getFile() + ")";
        }

        @Generated
        public static class KeyInfoRequestBuilder {
            @Generated
            private String serverId;
            @Generated
            private String id;
            @Generated
            private String pass;
            @Generated
            private File file;

            @Generated
            KeyInfoRequestBuilder() {
            }

            @Generated
            public KeyInfoRequestBuilder serverId(String serverId) {
                this.serverId = serverId;
                return this;
            }

            @Generated
            public KeyInfoRequestBuilder id(String id) {
                this.id = id;
                return this;
            }

            @Generated
            public KeyInfoRequestBuilder pass(String pass) {
                this.pass = pass;
                return this;
            }

            @Generated
            public KeyInfoRequestBuilder file(File file) {
                this.file = file;
                return this;
            }

            @Generated
            public KeyInfoRequest build() {
                return new KeyInfoRequest(this.serverId, this.id, this.pass, this.file);
            }

            @Generated
            public String toString() {
                return "KeyInfoFactory.KeyInfoRequest.KeyInfoRequestBuilder(serverId=" + this.serverId + ", id=" + this.id + ", pass=" + this.pass + ", file=" + this.file + ")";
            }
        }
    }
}

