/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Optional;
import org.bouncycastle.bcpg.sig.IssuerFingerprint;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.simplify4u.plugins.utils.HexUtils;
import org.simplify4u.plugins.utils.PGPKeyId;
import org.simplify4u.plugins.utils.PGPSignatureException;

public final class PGPSignatureUtils {
    private PGPSignatureUtils() {
    }

    public static String checkWeakHashAlgorithm(PGPSignature signature) {
        switch (signature.getHashAlgorithm()) {
            case 1: {
                return "MD5";
            }
            case 4: {
                return "double-width SHA";
            }
            case 5: {
                return "MD2";
            }
            case 6: {
                return "TIGER/192";
            }
            case 7: {
                return "HAVAL (5 pass, 160-bit)";
            }
            case 11: {
                return "SHA-224";
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                return null;
            }
        }
        throw new UnsupportedOperationException("Unknown hash algorithm value encountered: " + signature.getHashAlgorithm());
    }

    public static PGPSignature loadSignature(InputStream input) throws IOException, PGPSignatureException {
        try {
            Object nextObject;
            InputStream sigInputStream = PGPUtil.getDecoderStream((InputStream)input);
            PGPObjectFactory pgpObjectFactory = new PGPObjectFactory(sigInputStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            while ((nextObject = pgpObjectFactory.nextObject()) != null) {
                if (nextObject instanceof PGPSignatureList) {
                    return ((PGPSignatureList)nextObject).get(0);
                }
                if (nextObject instanceof PGPCompressedData) {
                    pgpObjectFactory = new PGPObjectFactory(((PGPCompressedData)nextObject).getDataStream(), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                }
                if (!(nextObject instanceof PGPLiteralData)) continue;
                InputStream dataStream = ((PGPLiteralData)nextObject).getDataStream();
                while (dataStream.read() > 0) {
                }
            }
        }
        catch (PGPException e) {
            throw new PGPSignatureException(e.getMessage(), e);
        }
        throw new PGPSignatureException("PGP signature not found.");
    }

    public static void readFileContentInto(PGPSignature signature, File file) throws IOException {
        try (BufferedInputStream inArtifact = new BufferedInputStream(new FileInputStream(file));){
            int t;
            while ((t = ((InputStream)inArtifact).read()) >= 0) {
                signature.update((byte)t);
            }
        }
    }

    public static PGPKeyId retrieveKeyId(PGPSignature signature) throws PGPSignatureException {
        Optional<Long> issuerKeyId;
        Optional<PGPSignatureSubpacketVector> hashedSubPackets = Optional.ofNullable(signature.getHashedSubPackets());
        Optional<PGPSignatureSubpacketVector> unHashedSubPackets = Optional.ofNullable(signature.getUnhashedSubPackets());
        Optional<IssuerFingerprint> issuerFingerprint = hashedSubPackets.map(PGPSignatureSubpacketVector::getIssuerFingerprint);
        if (!issuerFingerprint.isPresent()) {
            issuerFingerprint = unHashedSubPackets.map(PGPSignatureSubpacketVector::getIssuerFingerprint);
        }
        if (!(issuerKeyId = unHashedSubPackets.map(PGPSignatureSubpacketVector::getIssuerKeyID).filter(id -> id != 0L)).isPresent()) {
            issuerKeyId = hashedSubPackets.map(PGPSignatureSubpacketVector::getIssuerKeyID).filter(id -> id != 0L);
        }
        if (issuerKeyId.isPresent() && signature.getKeyID() != issuerKeyId.get().longValue()) {
            throw new PGPSignatureException(String.format("Signature KeyID 0x%016X is not equals to IssuerKeyID 0x%016X", signature.getKeyID(), issuerKeyId.get()));
        }
        if (issuerKeyId.isPresent() && issuerFingerprint.isPresent() && issuerFingerprint.get().getKeyVersion() == 4) {
            byte[] bKey = new byte[8];
            byte[] fingerprint = issuerFingerprint.get().getFingerprint();
            System.arraycopy(fingerprint, fingerprint.length - 8, bKey, 0, 8);
            BigInteger bigInteger = new BigInteger(bKey);
            if (bigInteger.longValue() != issuerKeyId.get().longValue()) {
                throw new PGPSignatureException(String.format("Signature IssuerFingerprint 0x%s not contains IssuerKeyID 0x%016X", HexUtils.fingerprintToString(fingerprint), issuerKeyId.get()));
            }
        }
        PGPKeyId pgpKeyId = issuerFingerprint.isPresent() ? PGPKeyId.from(issuerFingerprint.get().getFingerprint()) : (issuerKeyId.isPresent() ? PGPKeyId.from(issuerKeyId.get()) : PGPKeyId.from(signature.getKeyID()));
        return pgpKeyId;
    }
}

