/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.keysmap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.maven.artifact.Artifact;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.simplify4u.plugins.keysmap.ArtifactInfo;
import org.simplify4u.plugins.keysmap.KeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=KeysMap.class, instantiationStrategy="per-lookup")
public class KeysMap {
    private static final Logger LOG = LoggerFactory.getLogger(KeysMap.class);
    @Requirement
    private ResourceManager resourceManager;
    private final ArrayList<ArtifactInfo> keysMapList = new ArrayList();

    public void load(String locale) throws ResourceNotFoundException, IOException {
        if (locale != null && !locale.trim().isEmpty()) {
            try (InputStream inputStream = this.resourceManager.getResourceAsInputStream(locale);){
                this.loadKeysMap(inputStream);
            }
        }
        if (this.keysMapList.isEmpty()) {
            LOG.warn("No keysmap specified in configuration or keysmap contains no entries. PGPVerify will only check artifacts against their signature. File corruption will be detected. However, without a keysmap as a reference for trust, valid signatures of any public key will be accepted.");
        }
    }

    public boolean isEmpty() {
        return this.keysMapList.isEmpty();
    }

    public boolean isNoSignature(Artifact artifact) {
        return this.keysMapList.stream().filter(artifactInfo -> artifactInfo.isMatch(artifact)).anyMatch(ArtifactInfo::isNoSignature);
    }

    public boolean isBrokenSignature(Artifact artifact) {
        return this.keysMapList.stream().filter(artifactInfo -> artifactInfo.isMatch(artifact)).anyMatch(ArtifactInfo::isBrokenSignature);
    }

    public boolean isKeyMissing(Artifact artifact) {
        return this.keysMapList.stream().filter(artifactInfo -> artifactInfo.isMatch(artifact)).anyMatch(ArtifactInfo::isKeyMissing);
    }

    public boolean isWithKey(Artifact artifact) {
        for (ArtifactInfo artifactInfo : this.keysMapList) {
            if (!artifactInfo.isMatch(artifact)) continue;
            return !artifactInfo.isNoSignature();
        }
        return false;
    }

    public boolean isValidKey(Artifact artifact, PGPPublicKey key, PGPPublicKeyRing keyRing) {
        if (this.keysMapList.isEmpty()) {
            return true;
        }
        return this.keysMapList.stream().filter(artifactInfo -> artifactInfo.isMatch(artifact)).anyMatch(artifactInfo -> artifactInfo.isKeyMatch(key, keyRing));
    }

    private void loadKeysMap(InputStream inputStream) throws IOException {
        String currentLine;
        BufferedReader mapReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.US_ASCII));
        while ((currentLine = KeysMap.getNextLine(mapReader)) != null) {
            String[] parts = currentLine.split("=", 2);
            ArtifactInfo artifactInfo = KeysMap.createArtifactInfo(parts[0], parts.length == 1 ? "" : parts[1]);
            this.keysMapList.add(artifactInfo);
        }
    }

    private static String getNextLine(BufferedReader mapReader) throws IOException {
        String ret;
        String line;
        StringBuilder nextLine = new StringBuilder();
        while ((line = KeysMap.getNextNotEmptyLine(mapReader)) != null) {
            if (line.charAt(line.length() - 1) == '\\') {
                nextLine.append(line, 0, line.length() - 1);
                nextLine.append(" ");
                continue;
            }
            nextLine.append(line);
            break;
        }
        return (ret = nextLine.toString().trim()).length() == 0 ? null : ret;
    }

    private static String getNextNotEmptyLine(BufferedReader readLine) throws IOException {
        String line;
        String nextLine = null;
        while ((line = readLine.readLine()) != null && (nextLine = KeysMap.stripComments(line.trim())).isEmpty()) {
        }
        return nextLine == null || nextLine.length() == 0 ? null : nextLine;
    }

    private static String stripComments(String line) {
        if (line.length() < 1) {
            return line;
        }
        int hashIndex = line.indexOf(35);
        return hashIndex >= 0 ? line.substring(0, hashIndex).trim() : line;
    }

    private static ArtifactInfo createArtifactInfo(String strArtifact, String strKeys) {
        return new ArtifactInfo(strArtifact.trim(), new KeyInfo(strKeys.trim()));
    }
}

