/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.keyserver;

import com.google.common.io.ByteStreams;
import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.event.RetryEvent;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedRunnable;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.maven.settings.Proxy;
import org.simplify4u.plugins.keyserver.PGPKeyNotFound;
import org.simplify4u.plugins.keyserver.PGPKeysServerClientHttp;
import org.simplify4u.plugins.keyserver.PGPKeysServerClientHttps;
import org.simplify4u.plugins.keyserver.RoundRobinRouterPlaner;
import org.simplify4u.plugins.utils.ExceptionUtils;

abstract class PGPKeysServerClient {
    private final Proxy proxy;
    private static final int DEFAULT_CONNECT_TIMEOUT = 5000;
    private static final int DEFAULT_READ_TIMEOUT = 20000;
    public static final int DEFAULT_MAX_RETRIES = 10;
    private static final List<Class<? extends Throwable>> IGNORE_EXCEPTION_FOR_RETRY = Arrays.asList(PGPKeyNotFound.class, UnknownHostException.class);
    private final URI keyserver;
    private final int connectTimeout;
    private final int readTimeout;
    private final int maxAttempts;

    protected PGPKeysServerClient(URI keyserver, int connectTimeout, int readTimeout, int maxAttempts, Proxy proxy) {
        this.keyserver = keyserver;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.maxAttempts = maxAttempts;
        this.proxy = proxy;
    }

    static PGPKeysServerClient getClient(String keyServer, Proxy proxy) throws IOException {
        return PGPKeysServerClient.getClient(keyServer, proxy, 5000, 20000, 10);
    }

    static PGPKeysServerClient getClient(String keyServer, Proxy proxy, int connectTimeout, int readTimeout, int maxAttempts) throws IOException {
        String protocol;
        URI uri = (URI)Try.of((CheckedFunction0 & Serializable)() -> new URI(keyServer)).getOrElseThrow(IOException::new);
        switch (protocol = uri.getScheme().toLowerCase(Locale.ROOT)) {
            case "hkp": 
            case "http": {
                return new PGPKeysServerClientHttp(uri, connectTimeout, readTimeout, maxAttempts, proxy);
            }
            case "hkps": 
            case "https": {
                return new PGPKeysServerClientHttps(uri, connectTimeout, readTimeout, maxAttempts, proxy);
            }
        }
        throw new IOException("Unsupported protocol: " + protocol);
    }

    private String getQueryStringForGetKey(long keyID) {
        return String.format("op=get&options=mr&search=0x%016X", keyID);
    }

    URI getUriForGetKey(long keyID) {
        return (URI)Try.of((CheckedFunction0 & Serializable)() -> new URI(this.keyserver.getScheme(), this.keyserver.getUserInfo(), this.keyserver.getHost(), this.keyserver.getPort(), "/pks/lookup", this.getQueryStringForGetKey(keyID), null)).get();
    }

    private String getQueryStringForShowKey(long keyID) {
        return String.format("op=vindex&fingerprint=on&search=0x%016X", keyID);
    }

    URI getUriForShowKey(long keyID) {
        return (URI)Try.of((CheckedFunction0 & Serializable)() -> new URI(this.keyserver.getScheme(), this.keyserver.getUserInfo(), this.keyserver.getHost(), this.keyserver.getPort(), "/pks/lookup", this.getQueryStringForShowKey(keyID), null)).get();
    }

    void copyKeyToOutputStream(long keyId, OutputStream outputStream, OnRetryConsumer onRetryConsumer) throws IOException {
        URI keyUri = this.getUriForGetKey(keyId);
        HttpGet request = new HttpGet(keyUri);
        RoundRobinRouterPlaner planer = this.proxy == null ? new RoundRobinRouterPlaner() : this.getNewProxyRoutePlanner();
        RetryConfig config = RetryConfig.custom().maxAttempts(this.maxAttempts).waitDuration(Duration.ofMillis(500L)).intervalFunction(IntervalFunction.ofExponentialBackoff()).retryOnException(this::shouldRetryOnException).build();
        Retry retry = Retry.of((String)"id", (RetryConfig)config);
        retry.getEventPublisher().onRetry(event -> this.processOnRetry((RetryEvent)event, event.getWaitInterval(), planer, onRetryConsumer)).onError(event -> this.processOnRetry((RetryEvent)event, Duration.ZERO, planer, onRetryConsumer));
        CheckedRunnable checkedRunnable = Retry.decorateCheckedRunnable((Retry)retry, () -> this.lambda$copyKeyToOutputStream$2(planer, (HttpUriRequest)request, outputStream));
        try {
            checkedRunnable.run();
        }
        catch (PGPKeyNotFound e) {
            throw new PGPKeyNotFound("PGP server returned an error: HTTP/1.1 404 Not Found for: " + keyUri);
        }
        catch (Throwable e) {
            throw new IOException(ExceptionUtils.getMessage(e) + " for: " + keyUri, e);
        }
    }

    private HttpRoutePlanner getNewProxyRoutePlanner() {
        HttpHost httpHost = new HttpHost(this.proxy.getHost(), this.proxy.getPort());
        return new DefaultProxyRoutePlanner(httpHost);
    }

    private boolean shouldRetryOnException(Throwable throwable) {
        for (Throwable aThrowable = throwable; aThrowable != null; aThrowable = aThrowable.getCause()) {
            if (!IGNORE_EXCEPTION_FOR_RETRY.contains(aThrowable.getClass())) continue;
            return false;
        }
        return true;
    }

    private void processOnRetry(RetryEvent event, Duration waitInterval, HttpRoutePlanner planer, OnRetryConsumer onRetryConsumer) {
        InetAddress targetAddress = null;
        if (planer instanceof RoundRobinRouterPlaner) {
            HttpRoute httpRoute = ((RoundRobinRouterPlaner)planer).lastRouteCauseError();
            targetAddress = (InetAddress)Try.of((CheckedFunction0 & Serializable)() -> httpRoute.getTargetHost().getAddress()).getOrElse((Object)null);
        } else if (this.proxy != null) {
            targetAddress = (InetAddress)Try.of((CheckedFunction0 & Serializable)() -> InetAddress.getByName(this.proxy.getHost())).getOrElse((Object)null);
        }
        if (onRetryConsumer != null) {
            onRetryConsumer.onRetry(targetAddress, event.getNumberOfRetryAttempts(), waitInterval, event.getLastThrowable());
        }
    }

    protected abstract HttpClientBuilder createClientBuilder();

    private void processKeyResponse(CloseableHttpResponse response, OutputStream outputStream) throws IOException {
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() == 404) {
            throw new PGPKeyNotFound();
        }
        if (statusLine.getStatusCode() == 200) {
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity == null) {
                throw new IOException("No response body returned.");
            }
            try (InputStream inputStream = responseEntity.getContent();){
                ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
        } else {
            throw new IOException("PGP server returned an error: " + statusLine);
        }
    }

    private CloseableHttpClient buildClient(HttpRoutePlanner planer) {
        HttpClientBuilder clientBuilder = this.createClientBuilder();
        this.applyTimeouts(clientBuilder);
        clientBuilder.setRoutePlanner(planer);
        return clientBuilder.build();
    }

    private void applyTimeouts(HttpClientBuilder builder) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this.connectTimeout).setConnectTimeout(this.connectTimeout).setSocketTimeout(this.readTimeout).build();
        builder.setDefaultRequestConfig(requestConfig);
    }

    protected HttpClientBuilder setupProxy(HttpClientBuilder clientBuilder) {
        if (this.proxy == null) {
            return clientBuilder;
        }
        if (this.proxy.getUsername() != null && !this.proxy.getUsername().isEmpty() && this.proxy.getPassword() != null && !this.proxy.getPassword().isEmpty()) {
            clientBuilder.setProxyAuthenticationStrategy((AuthenticationStrategy)ProxyAuthenticationStrategy.INSTANCE);
            BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
            AuthScope proxyAuthScope = new AuthScope(this.proxy.getHost(), this.proxy.getPort());
            UsernamePasswordCredentials proxyAuthentication = new UsernamePasswordCredentials(this.proxy.getUsername(), this.proxy.getPassword());
            basicCredentialsProvider.setCredentials(proxyAuthScope, (Credentials)proxyAuthentication);
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
        }
        return clientBuilder;
    }

    public String toString() {
        return "{" + this.keyserver + "}";
    }

    private /* synthetic */ void lambda$copyKeyToOutputStream$2(HttpRoutePlanner planer, HttpUriRequest request, OutputStream outputStream) throws Throwable {
        try (CloseableHttpClient client = this.buildClient(planer);
             CloseableHttpResponse response = client.execute(request);){
            this.processKeyResponse(response, outputStream);
        }
    }

    @FunctionalInterface
    public static interface OnRetryConsumer {
        public void onRetry(InetAddress var1, int var2, Duration var3, Throwable var4);
    }
}

