/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins;

import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.simplify4u.plugins.AscArtifactHandler;
import org.simplify4u.plugins.skipfilters.CompositeSkipper;
import org.simplify4u.plugins.skipfilters.ScopeSkipper;
import org.simplify4u.plugins.skipfilters.SkipFilter;
import org.simplify4u.plugins.utils.MavenCompilerUtils;

final class ArtifactResolver {
    private static final VersionRange SUREFIRE_PLUGIN_VERSION_RANGE = (VersionRange)Try.of((CheckedFunction0 & Serializable)() -> VersionRange.createFromVersionSpec((String)"(2.999999999,4)")).getOrElseThrow(e -> new IllegalStateException("BUG: Failed to create version range.", (Throwable)e));
    private final Log log;
    private final RepositorySystem repositorySystem;
    private final ArtifactRepository localRepository;
    private final List<ArtifactRepository> remoteRepositories;
    private final List<ArtifactRepository> remoteRepositoriesIgnoreCheckSum;

    ArtifactResolver(Log log, RepositorySystem repositorySystem, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) {
        this.log = Objects.requireNonNull(log);
        this.repositorySystem = Objects.requireNonNull(repositorySystem);
        this.localRepository = Objects.requireNonNull(localRepository);
        this.remoteRepositories = Objects.requireNonNull(remoteRepositories);
        this.remoteRepositoriesIgnoreCheckSum = this.repositoriesIgnoreCheckSum(remoteRepositories);
    }

    private List<ArtifactRepository> repositoriesIgnoreCheckSum(List<ArtifactRepository> repositories) {
        return Optional.ofNullable(repositories).orElse(Collections.emptyList()).stream().map(this::repositoryIgnoreCheckSum).collect(Collectors.toList());
    }

    private ArtifactRepository repositoryIgnoreCheckSum(ArtifactRepository repository) {
        ArtifactRepository newRepository = this.repositorySystem.createArtifactRepository(repository.getId(), repository.getUrl(), repository.getLayout(), this.policyIgnoreCheckSum(repository.getSnapshots()), this.policyIgnoreCheckSum(repository.getReleases()));
        newRepository.setAuthentication(repository.getAuthentication());
        newRepository.setProxy(repository.getProxy());
        newRepository.setMirroredRepositories(this.repositoriesIgnoreCheckSum(repository.getMirroredRepositories()));
        return newRepository;
    }

    private ArtifactRepositoryPolicy policyIgnoreCheckSum(ArtifactRepositoryPolicy policy) {
        return new ArtifactRepositoryPolicy(policy.isEnabled(), policy.getUpdatePolicy(), "ignore");
    }

    Set<Artifact> resolveProjectArtifacts(MavenProject project, Configuration config) throws MojoExecutionException {
        LinkedHashSet<Artifact> allArtifacts = new LinkedHashSet<Artifact>(this.resolveArtifacts(project.getArtifacts(), config.dependencyFilter, null, config.verifyPomFiles, false));
        if (config.verifyPlugins) {
            for (Plugin plugin : project.getBuildPlugins()) {
                LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
                artifacts.add(this.repositorySystem.createPluginArtifact(plugin));
                artifacts.addAll(plugin.getDependencies().stream().map(arg_0 -> ((RepositorySystem)this.repositorySystem).createDependencyArtifact(arg_0)).collect(Collectors.toSet()));
                Set<Artifact> resolved = this.resolveArtifacts(artifacts, config.pluginFilter, config.dependencyFilter, config.verifyPomFiles, config.verifyPluginDependencies);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("Build plugin dependencies for " + plugin.getGroupId() + ":" + plugin.getArtifactId() + ":" + plugin.getVersion() + " " + resolved));
                }
                allArtifacts.addAll(resolved);
            }
            for (Plugin plugin : project.getReportArtifacts()) {
                Set<Artifact> resolved = this.resolveArtifacts(Collections.singleton(plugin), config.pluginFilter, config.dependencyFilter, config.verifyPomFiles, config.verifyPluginDependencies);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("Report plugin dependencies for " + plugin.getGroupId() + ":" + plugin.getArtifactId() + ":" + plugin.getVersion() + " " + resolved));
                }
                allArtifacts.addAll(resolved);
            }
        }
        if (config.verifyAtypical) {
            allArtifacts.addAll(this.resolveArtifacts(this.searchCompilerAnnotationProcessors(project), config.dependencyFilter, config.dependencyFilter, config.verifyPomFiles, config.verifyPluginDependencies));
            this.informSurefire3RuntimeDependencyLoadingLimitation(project);
        }
        return allArtifacts;
    }

    private Collection<Artifact> searchCompilerAnnotationProcessors(MavenProject project) {
        return project.getBuildPlugins().stream().filter(MavenCompilerUtils::checkCompilerPlugin).flatMap(p -> MavenCompilerUtils.extractAnnotationProcessors(this.repositorySystem, p).stream()).collect(Collectors.toList());
    }

    private void informSurefire3RuntimeDependencyLoadingLimitation(MavenProject project) {
        boolean surefireDynamicLoadingLikely = project.getBuildPlugins().stream().filter(p -> "org.apache.maven.plugins".equals(p.getGroupId())).filter(p -> "maven-surefire-plugin".equals(p.getArtifactId())).anyMatch(this::matchSurefireVersion);
        if (surefireDynamicLoadingLikely) {
            this.log.info((CharSequence)"NOTE: maven-surefire-plugin version 3 is present. This version is known to resolve and load dependencies for various unit testing frameworks (called \"providers\") during execution. These dependencies are not validated.");
        }
    }

    private boolean matchSurefireVersion(Plugin plugin) {
        ArtifactVersion version;
        try {
            version = this.repositorySystem.createPluginArtifact(plugin).getSelectedVersion();
        }
        catch (OverConstrainedVersionException e) {
            this.log.debug((CharSequence)"Found build plug-in with overly constrained version specification.", (Throwable)e);
            return false;
        }
        return SUREFIRE_PLUGIN_VERSION_RANGE.containsVersion(version);
    }

    Map<Artifact, Artifact> resolveSignatures(Iterable<Artifact> artifacts, SignatureRequirement requirement) throws MojoExecutionException {
        this.log.debug((CharSequence)"Start resolving ASC files");
        LinkedHashMap<Artifact, Artifact> artifactToAsc = new LinkedHashMap<Artifact, Artifact>();
        for (Artifact artifact : artifacts) {
            Artifact ascArtifact = this.resolveSignature(artifact, requirement);
            if (ascArtifact == null && requirement != SignatureRequirement.STRICT) continue;
            artifactToAsc.put(artifact, ascArtifact);
        }
        return artifactToAsc;
    }

    private Artifact resolveSignature(Artifact artifact, SignatureRequirement requirement) throws MojoExecutionException {
        Artifact aAsc = this.repositorySystem.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), artifact.getClassifier());
        aAsc.setArtifactHandler((ArtifactHandler)new AscArtifactHandler(aAsc));
        ArtifactResolutionResult ascResult = this.request(aAsc, this.remoteRepositoriesIgnoreCheckSum);
        if (ascResult.isSuccess()) {
            this.log.debug((CharSequence)(aAsc.toString() + " " + aAsc.getFile()));
            return aAsc;
        }
        switch (requirement) {
            case NONE: {
                this.log.warn((CharSequence)("No signature for " + artifact.getId()));
                break;
            }
            case STRICT: {
                this.log.debug((CharSequence)("No signature for " + artifact.getId()));
                break;
            }
            case REQUIRED: {
                this.log.error((CharSequence)("No signature for " + artifact.getId()));
                throw new MojoExecutionException("No signature for " + artifact.getId());
            }
            default: {
                throw new UnsupportedOperationException("Unsupported signature requirement.");
            }
        }
        return null;
    }

    private Set<Artifact> resolveArtifacts(Iterable<Artifact> artifacts, SkipFilter artifactFilter, SkipFilter dependenciesFilter, boolean verifyPom, boolean transitive) throws MojoExecutionException {
        LinkedHashSet<Artifact> collection = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            Artifact resolved = this.resolveArtifact(artifact);
            if (artifactFilter.shouldSkipArtifact(artifact)) {
                this.log.debug((CharSequence)("Skipping artifact: " + artifact));
                continue;
            }
            if (!resolved.isResolved()) {
                throw new MojoExecutionException("Failed to resolve artifact: " + artifact);
            }
            collection.add(resolved);
            if (!verifyPom) continue;
            Artifact resolvedPom = this.resolvePom(artifact);
            if (resolvedPom.isResolved()) {
                collection.add(resolvedPom);
                continue;
            }
            this.log.warn((CharSequence)("Failed to resolve pom artifact: " + resolvedPom));
        }
        if (transitive) {
            CompositeSkipper transitivesFilter = new CompositeSkipper(dependenciesFilter, new ScopeSkipper("runtime"));
            LinkedHashSet<Artifact> transitives = new LinkedHashSet<Artifact>();
            for (Artifact artifact : collection) {
                transitives.addAll(this.resolveTransitively(artifact, transitivesFilter, verifyPom));
            }
            collection.addAll(transitives);
        }
        return collection;
    }

    private Set<Artifact> resolveTransitively(Artifact artifact, SkipFilter dependencyFilter, boolean verifyPom) throws MojoExecutionException {
        ArtifactFilter requestFilter = a -> !dependencyFilter.shouldSkipArtifact(a);
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(artifact).setLocalRepository(this.localRepository).setRemoteRepositories(this.remoteRepositories).setResolutionFilter(requestFilter).setCollectionFilter(requestFilter).setResolveTransitively(true);
        ArtifactResolutionResult resolution = this.repositorySystem.resolve(request);
        if (!resolution.isSuccess()) {
            if (resolution.hasMissingArtifacts()) {
                this.log.warn((CharSequence)("Missing artifacts for " + artifact.getId() + ": " + resolution.getMissingArtifacts()));
            }
            resolution.getExceptions().forEach(e -> {
                this.log.warn((CharSequence)("Failed to resolve transitive dependencies for " + artifact.getId() + ": " + e.getMessage()));
                this.log.debug((Throwable)e);
            });
            throw new MojoExecutionException("Failed to resolve transitive dependencies.");
        }
        if (verifyPom) {
            LinkedHashSet<Artifact> resolved = new LinkedHashSet<Artifact>(resolution.getArtifacts());
            for (Artifact a2 : resolution.getArtifacts()) {
                resolved.add(this.resolvePom(a2));
            }
            return resolved;
        }
        return resolution.getArtifacts();
    }

    private Artifact resolvePom(Artifact artifact) {
        Artifact pomArtifact = this.repositorySystem.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        ArtifactResolutionResult result = this.request(pomArtifact, this.remoteRepositories);
        if (!result.isSuccess()) {
            result.getExceptions().forEach(e -> this.log.debug((CharSequence)("Failed to resolve pom " + pomArtifact.getId() + ": " + e.getMessage())));
        }
        return pomArtifact;
    }

    private Artifact resolveArtifact(Artifact artifact) {
        ArtifactResolutionResult result = this.request(artifact, this.remoteRepositories);
        if (!result.isSuccess()) {
            result.getExceptions().forEach(e -> {
                this.log.warn((CharSequence)("Failed to resolve " + artifact.getId() + ": " + e.getMessage()));
                this.log.debug((Throwable)e);
            });
        }
        return artifact;
    }

    private ArtifactResolutionResult request(Artifact artifact, List<ArtifactRepository> remoteRepositoriesToResolve) {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setResolveTransitively(false);
        request.setLocalRepository(this.localRepository);
        request.setRemoteRepositories(remoteRepositoriesToResolve);
        return this.repositorySystem.resolve(request);
    }

    public static final class Configuration {
        final SkipFilter dependencyFilter;
        final SkipFilter pluginFilter;
        final boolean verifyPomFiles;
        final boolean verifyPlugins;
        final boolean verifyPluginDependencies;
        final boolean verifyAtypical;

        public Configuration(SkipFilter dependencyFilter, SkipFilter pluginFilter, boolean verifyPomFiles, boolean verifyPlugins, boolean verifyPluginDependencies, boolean verifyAtypical) {
            this.dependencyFilter = Objects.requireNonNull(dependencyFilter);
            this.pluginFilter = Objects.requireNonNull(pluginFilter);
            this.verifyPomFiles = verifyPomFiles;
            this.verifyPlugins = verifyPlugins;
            this.verifyPluginDependencies = verifyPluginDependencies;
            this.verifyAtypical = verifyAtypical;
        }
    }

    static enum SignatureRequirement {
        NONE,
        STRICT,
        REQUIRED;

    }
}

