/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.keyserver;

import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.simplify4u.plugins.keyserver.PGPKeysServerClient;
import org.simplify4u.plugins.utils.ExceptionUtils;
import org.simplify4u.plugins.utils.PublicKeyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PGPKeysCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(PGPKeysCache.class);
    private static final String NL = System.lineSeparator();
    private final File cachePath;
    private final KeyServerList keyServerList;
    private static final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PGPKeysCache(File cachePath, List<PGPKeysServerClient> pgpKeysServerClients, boolean loadBalance) throws IOException {
        this.cachePath = cachePath;
        this.keyServerList = PGPKeysCache.createKeyServerList(pgpKeysServerClients, loadBalance);
        LOGGER.info("Key server(s) - {}", (Object)this.keyServerList);
        Object object = LOCK;
        synchronized (object) {
            if (this.cachePath.exists()) {
                if (!this.cachePath.isDirectory()) {
                    throw new IOException("PGP keys cache path exist but is not a directory: " + this.cachePath);
                }
            } else if (this.cachePath.mkdirs()) {
                LOGGER.info("Create cache directory for PGP keys: {}", (Object)this.cachePath);
            } else {
                throw new IOException("Cache directory create error");
            }
        }
    }

    public static List<PGPKeysServerClient> prepareClients(List<String> keyServers) {
        return keyServers.stream().map(keyserver -> (PGPKeysServerClient)Try.of((CheckedFunction0 & Serializable)() -> PGPKeysServerClient.getClient(keyserver)).get()).collect(Collectors.toList());
    }

    static KeyServerList createKeyServerList(List<PGPKeysServerClient> pgpKeysServerClients, boolean loadBalance) {
        if (pgpKeysServerClients == null || pgpKeysServerClients.isEmpty()) {
            throw new IllegalArgumentException("Not allowed empty key server clients list ");
        }
        KeyServerList ret = pgpKeysServerClients.size() == 1 ? new KeyServerListOne() : (loadBalance ? new KeyServerListLoadBalance() : new KeyServerListFallback());
        return ret.withClients(pgpKeysServerClients);
    }

    public String getUrlForShowKey(long keyID) {
        return this.keyServerList.getUriForShowKey(keyID).toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public PGPPublicKeyRing getKeyRing(long keyID) throws IOException, PGPException {
        Optional<Object> keyRing = Optional.empty();
        String path = String.format("%02X/%02X/%016X.asc", (byte)(keyID >> 56), (byte)(keyID >> 48 & 0xFFL), keyID);
        File keyFile = new File(this.cachePath, path);
        Object object = LOCK;
        synchronized (object) {
            if (!keyFile.exists()) {
                this.keyServerList.execute(keysServerClient -> this.receiveKey(keyFile, keyID, keysServerClient));
            }
            try {
                PGPPublicKeyRing pGPPublicKeyRing;
                try (FileInputStream keyFileStream = new FileInputStream(keyFile);){
                    keyRing = PublicKeyUtils.loadPublicKeyRing(keyFileStream, keyID);
                    pGPPublicKeyRing = (PGPPublicKeyRing)keyRing.orElseThrow(() -> new PGPException(String.format("Can't find public key 0x%016X in download file: %s", keyID, keyFile)));
                }
                return pGPPublicKeyRing;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (!keyRing.isPresent()) {
                    this.deleteFile(keyFile);
                }
            }
        }
    }

    private void receiveKey(File keyFile, long keyId, PGPKeysServerClient keysServerClient) throws IOException {
        File dir = keyFile.getParentFile();
        if (dir == null) {
            throw new IOException("No parent dir for: " + keyFile);
        }
        if (dir.exists() && !dir.isDirectory()) {
            throw new IOException("Path exist but it isn't directory: " + dir);
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Can't create directory: " + dir);
        }
        File partFile = File.createTempFile(String.valueOf(keyId), "pgp-public-key");
        try {
            try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(partFile));){
                keysServerClient.copyKeyToOutputStream(keyId, outputStream, this::onRetry);
            }
            Files.move(partFile.toPath(), keyFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            this.deleteFile(keyFile);
            this.deleteFile(partFile);
            throw e;
        }
        LOGGER.info("Receive key: {}{}\tto {}", new Object[]{keysServerClient.getUriForGetKey(keyId), NL, keyFile});
    }

    private void onRetry(InetAddress address, int numberOfRetryAttempts, Duration waitInterval, Throwable lastThrowable) {
        LOGGER.warn("[Retry #{} waiting: {}] Last address {} with problem: [{}] {}", new Object[]{numberOfRetryAttempts, waitInterval, address, lastThrowable.getClass().getName(), ExceptionUtils.getMessage(lastThrowable)});
    }

    private void deleteFile(File file) {
        Optional.ofNullable(file).map(File::toPath).ifPresent(filePath -> {
            try {
                Files.deleteIfExists(filePath);
            }
            catch (IOException e) {
                LOGGER.warn("Can't delete: {}", filePath);
            }
        });
    }

    static class KeyServerListLoadBalance
    extends KeyServerList {
        private int lastIndex = 0;

        KeyServerListLoadBalance() {
        }

        @Override
        String getName() {
            return "load balance";
        }

        @Override
        void execute(KeyServerExecutor executor) throws IOException {
            for (int i = 0; i < this.keysServerClients.size(); ++i) {
                PGPKeysServerClient client = (PGPKeysServerClient)this.keysServerClients.get(this.lastIndex);
                this.lastIndex = (this.lastIndex + 1) % this.keysServerClients.size();
                if (!this.isSuccessExecute(executor, client)) continue;
                return;
            }
            throw new IOException("All servers from list was failed");
        }
    }

    static class KeyServerListFallback
    extends KeyServerList {
        KeyServerListFallback() {
        }

        @Override
        String getName() {
            return "fallback";
        }

        @Override
        void execute(KeyServerExecutor executor) throws IOException {
            for (PGPKeysServerClient client : this.keysServerClients) {
                if (!this.isSuccessExecute(executor, client)) continue;
                return;
            }
            throw new IOException("All servers from list was failed");
        }
    }

    static class KeyServerListOne
    extends KeyServerList {
        KeyServerListOne() {
        }

        @Override
        String getName() {
            return "one item";
        }

        @Override
        void execute(KeyServerExecutor executor) throws IOException {
            executor.run(this.lastClient);
        }

        @Override
        public String toString() {
            return this.lastClient.toString();
        }
    }

    static abstract class KeyServerList {
        protected List<PGPKeysServerClient> keysServerClients = new ArrayList<PGPKeysServerClient>();
        protected PGPKeysServerClient lastClient;

        KeyServerList() {
        }

        KeyServerList withClients(List<PGPKeysServerClient> keysServerClients) {
            this.keysServerClients = keysServerClients;
            this.lastClient = keysServerClients.get(0);
            return this;
        }

        URI getUriForShowKey(long keyID) {
            return this.lastClient.getUriForShowKey(keyID);
        }

        boolean isSuccessExecute(KeyServerExecutor executor, PGPKeysServerClient client) {
            try {
                executor.run(client);
                this.lastClient = client;
                return true;
            }
            catch (IOException e) {
                LOGGER.warn("{} throw exception: {} - {} try next client", new Object[]{client, ExceptionUtils.getMessage(e), this.getName()});
                return false;
            }
        }

        public String toString() {
            return String.format("%s list: %s", this.getName(), this.keysServerClients);
        }

        abstract String getName();

        abstract void execute(KeyServerExecutor var1) throws IOException;
    }

    @FunctionalInterface
    static interface KeyServerExecutor {
        public void run(PGPKeysServerClient var1) throws IOException;
    }
}

