/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.simplify4u.plugins.ArtifactResolver;
import org.simplify4u.plugins.KeysMap;
import org.simplify4u.plugins.PGPSignatures;
import org.simplify4u.plugins.keyserver.PGPKeysCache;
import org.simplify4u.plugins.skipfilters.CompositeSkipper;
import org.simplify4u.plugins.skipfilters.ProvidedDependencySkipper;
import org.simplify4u.plugins.skipfilters.ReactorDependencySkipper;
import org.simplify4u.plugins.skipfilters.ScopeSkipper;
import org.simplify4u.plugins.skipfilters.SkipFilter;
import org.simplify4u.plugins.skipfilters.SnapshotDependencySkipper;
import org.simplify4u.plugins.skipfilters.SystemDependencySkipper;
import org.simplify4u.plugins.utils.PublicKeyUtils;

@Mojo(name="check", requiresProject=true, requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class PGPVerifyMojo
extends AbstractMojo {
    private static final String PGP_VERIFICATION_RESULT_FORMAT = "%s PGP Signature %s\n       %s UserIds: %s";
    private static final Pattern KEY_SERVERS_SPLIT_PATTERN = Pattern.compile("[;,\\s]");
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private KeysMap keysMap;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(property="pgpverify.keycache", defaultValue="${settings.localRepository}/pgpkeys-cache", required=true)
    private File pgpKeysCachePath;
    @Parameter(property="pgpverify.scope", defaultValue="test")
    private String scope;
    @Parameter(property="pgpverify.keyserver", defaultValue="hkps://hkps.pool.sks-keyservers.net", required=true)
    private String pgpKeyServer;
    @Parameter(property="pgpverify.keyserversLoadBalance", defaultValue="true")
    private boolean pgpKeyServerLoadBalance;
    @Parameter(property="pgpverify.failNoSignature", defaultValue="false")
    private boolean failNoSignature;
    @Parameter(property="pgpverify.strictNoSignature", defaultValue="false")
    private boolean strictNoSignature;
    @Parameter(property="pgpgverify.failWeakSignature", defaultValue="false")
    private boolean failWeakSignature;
    @Parameter(property="pgpverify.verifyPomFiles", defaultValue="true")
    private boolean verifyPomFiles;
    @Parameter(property="pgpverify.verifySnapshots", defaultValue="false")
    private boolean verifySnapshots;
    @Parameter(property="pgpverify.verifyPlugins", defaultValue="false")
    private boolean verifyPlugins;
    @Parameter(property="pgpverify.verifyAtypical", defaultValue="false")
    private boolean verifyAtypical;
    @Parameter(property="pgpverify.verifyProvidedDependencies", defaultValue="false")
    private boolean verifyProvidedDependencies;
    @Parameter(property="pgpverify.verifySystemDependencies", defaultValue="false")
    private boolean verifySystemDependencies;
    @Parameter(property="pgpverify.verifyReactorDependencies", defaultValue="false")
    private boolean verifyReactorDependencies;
    @Parameter(property="pgpverify.keysMapLocation", defaultValue="")
    private String keysMapLocation;
    @Parameter(property="pgpverify.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="pgpverify.quiet", defaultValue="false")
    private boolean quiet;
    private PGPKeysCache pgpKeysCache;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping pgpverify:check");
        } else {
            SkipFilter dependencyFilter = this.prepareDependencyFilters();
            SkipFilter pluginFilter = this.preparePluginFilters();
            this.prepareForKeys();
            ArtifactResolver resolver = new ArtifactResolver(this.getLog(), this.repositorySystem, this.localRepository, this.remoteRepositories);
            ArtifactResolver.Configuration config = new ArtifactResolver.Configuration(dependencyFilter, pluginFilter, this.verifyPomFiles, this.verifyPlugins, this.verifyAtypical);
            Set<Artifact> artifacts = resolver.resolveProjectArtifacts(this.project, config);
            ArtifactResolver.SignatureRequirement signaturePolicy = this.determineSignaturePolicy();
            Map<Artifact, Artifact> artifactMap = resolver.resolveSignatures(artifacts, signaturePolicy);
            this.verifyArtifactSignatures(artifactMap);
        }
    }

    private ArtifactResolver.SignatureRequirement determineSignaturePolicy() {
        if (this.failNoSignature) {
            return ArtifactResolver.SignatureRequirement.REQUIRED;
        }
        if (this.strictNoSignature) {
            return ArtifactResolver.SignatureRequirement.STRICT;
        }
        return ArtifactResolver.SignatureRequirement.NONE;
    }

    private SkipFilter prepareDependencyFilters() {
        LinkedList<SkipFilter> filters = new LinkedList<SkipFilter>();
        filters.add(new ScopeSkipper(this.scope));
        if (!this.verifySnapshots) {
            filters.add(new SnapshotDependencySkipper());
        }
        if (!this.verifyProvidedDependencies) {
            filters.add(new ProvidedDependencySkipper());
        }
        if (!this.verifySystemDependencies) {
            filters.add(new SystemDependencySkipper());
        }
        if (!this.verifyReactorDependencies) {
            filters.add(new ReactorDependencySkipper(this.project, this.session));
        }
        return new CompositeSkipper(filters);
    }

    private SkipFilter preparePluginFilters() {
        LinkedList<SkipFilter> filters = new LinkedList<SkipFilter>();
        if (!this.verifySnapshots) {
            filters.add(new SnapshotDependencySkipper());
        }
        return new CompositeSkipper(filters);
    }

    private void prepareForKeys() throws MojoFailureException, MojoExecutionException {
        this.initCache();
        try {
            this.keysMap.load(this.keysMapLocation);
        }
        catch (IOException | ResourceNotFoundException e) {
            throw new MojoExecutionException("load keys map", (Exception)e);
        }
    }

    private void initCache() throws MojoFailureException {
        List<String> keyServerList = Arrays.stream(KEY_SERVERS_SPLIT_PATTERN.split(this.pgpKeyServer)).map(String::trim).filter(s -> s.length() > 0).collect(Collectors.toList());
        try {
            this.pgpKeysCache = new PGPKeysCache(this.pgpKeysCachePath, PGPKeysCache.prepareClients(keyServerList), this.pgpKeyServerLoadBalance);
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private void verifyArtifactSignatures(Map<Artifact, Artifact> artifactToAsc) throws MojoFailureException, MojoExecutionException {
        boolean isAllSigOk = true;
        for (Map.Entry<Artifact, Artifact> artifactEntry : artifactToAsc.entrySet()) {
            Artifact artifact = artifactEntry.getKey();
            Artifact ascArtifact = artifactEntry.getValue();
            boolean isLastOk = this.verifyPGPSignature(artifact, ascArtifact);
            isAllSigOk = isAllSigOk && isLastOk;
        }
        if (!isAllSigOk) {
            throw new MojoExecutionException("PGP signature error");
        }
    }

    private boolean verifyPGPSignature(Artifact artifact, Artifact ascArtifact) throws MojoFailureException {
        if (ascArtifact == null) {
            return this.verifySignatureUnavailable(artifact);
        }
        File artifactFile = artifact.getFile();
        File signatureFile = ascArtifact.getFile();
        ImmutableMap weakSignatures = ImmutableMap.builder().put((Object)1, (Object)"MD5").put((Object)4, (Object)"DOUBLE_SHA").put((Object)5, (Object)"MD2").put((Object)6, (Object)"TIGER_192").put((Object)7, (Object)"HAVAL_5_160").put((Object)11, (Object)"SHA224").build();
        this.getLog().debug((CharSequence)("Artifact file: " + artifactFile));
        this.getLog().debug((CharSequence)("Artifact sign: " + signatureFile));
        try {
            long sigKeyID;
            PGPPublicKeyRing publicKeyRing;
            PGPPublicKey publicKey;
            InputStream sigInputStream = PGPUtil.getDecoderStream((InputStream)new FileInputStream(signatureFile));
            PGPObjectFactory pgpObjectFactory = new PGPObjectFactory(sigInputStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            PGPSignatureList sigList = (PGPSignatureList)pgpObjectFactory.nextObject();
            if (sigList == null) {
                throw new MojoFailureException("Invalid signature file: " + signatureFile);
            }
            PGPSignature pgpSignature = sigList.get(0);
            if (weakSignatures.containsKey(pgpSignature.getHashAlgorithm())) {
                String logMessageWeakSignature = "Weak signature algorithm used: " + (String)weakSignatures.get(pgpSignature.getHashAlgorithm());
                if (this.failWeakSignature) {
                    this.getLog().error((CharSequence)logMessageWeakSignature);
                    throw new MojoFailureException(logMessageWeakSignature);
                }
                this.getLog().warn((CharSequence)logMessageWeakSignature);
            }
            if (!this.keysMap.isValidKey(artifact, publicKey = (publicKeyRing = this.pgpKeysCache.getKeyRing(sigKeyID = pgpSignature.getKeyID())).getPublicKey(sigKeyID), publicKeyRing)) {
                String msg = String.format("%s = %s", ArtifactUtils.key((Artifact)artifact), PublicKeyUtils.fingerprintForMaster(publicKey, publicKeyRing));
                String keyUrl = this.pgpKeysCache.getUrlForShowKey(publicKey.getKeyID());
                this.getLog().error((CharSequence)String.format("Not allowed artifact %s and keyID:%n\t%s%n\t%s", artifact.getId(), msg, keyUrl));
                return false;
            }
            pgpSignature.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), publicKey);
            PGPSignatures.readFileContentInto(pgpSignature, artifactFile);
            this.getLog().debug((CharSequence)("signature.KeyAlgorithm: " + pgpSignature.getKeyAlgorithm() + " signature.hashAlgorithm: " + pgpSignature.getHashAlgorithm()));
            if (pgpSignature.verify()) {
                String logMessageOK = String.format(PGP_VERIFICATION_RESULT_FORMAT, artifact.getId(), "OK", PublicKeyUtils.keyIdDescription(publicKey, publicKeyRing), PublicKeyUtils.getUserIDs(publicKey, publicKeyRing));
                if (this.quiet) {
                    this.getLog().debug((CharSequence)logMessageOK);
                } else {
                    this.getLog().info((CharSequence)logMessageOK);
                }
                return true;
            }
            this.getLog().warn((CharSequence)String.format(PGP_VERIFICATION_RESULT_FORMAT, artifact.getId(), "ERROR", PublicKeyUtils.keyIdDescription(publicKey, publicKeyRing), PublicKeyUtils.getUserIDs(publicKey, publicKeyRing)));
            this.getLog().warn((CharSequence)artifactFile.toString());
            this.getLog().warn((CharSequence)signatureFile.toString());
            return false;
        }
        catch (IOException | PGPException e) {
            throw new MojoFailureException("Failed to process signature '" + signatureFile + "' for artifact " + artifact.getId(), e);
        }
    }

    private boolean verifySignatureUnavailable(Artifact artifact) {
        if (this.keysMap.isNoKey(artifact)) {
            String logMessage = String.format("%s PGP Signature unavailable, consistent with keys map.", artifact.getId());
            if (this.quiet) {
                this.getLog().debug((CharSequence)logMessage);
            } else {
                this.getLog().info((CharSequence)logMessage);
            }
            return true;
        }
        this.getLog().error((CharSequence)("Unsigned artifact not listed in keys map: " + artifact.getId()));
        return false;
    }
}

