/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Optional;
import org.apache.maven.plugin.logging.Log;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.simplify4u.plugins.PGPKeysServerClient;

public class PGPKeysCache {
    private final Log log;
    private final File cachePath;
    private final PGPKeysServerClient keysServerClient;
    private static final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PGPKeysCache(Log log, File cachePath, String keyServer) throws IOException {
        this.log = log;
        this.cachePath = cachePath;
        this.keysServerClient = PGPKeysServerClient.getClient(keyServer);
        Object object = LOCK;
        synchronized (object) {
            if (this.cachePath.exists()) {
                if (!this.cachePath.isDirectory()) {
                    throw new IOException("PGP keys cache path exist but is not a directory: " + this.cachePath);
                }
            } else if (this.cachePath.mkdirs()) {
                this.log.info((CharSequence)("Create cache directory for PGP keys: " + this.cachePath));
            } else {
                throw new IOException("Cache directory create error");
            }
        }
    }

    String getUrlForShowKey(long keyID) {
        return this.keysServerClient.getUriForShowKey(keyID).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PGPPublicKey getKey(long keyID) throws IOException, PGPException {
        PGPPublicKey key = null;
        String path = String.format("%02X/%02X/%016X.asc", (byte)(keyID >> 56), (byte)(keyID >> 48 & 0xFFL), keyID);
        File keyFile = new File(this.cachePath, path);
        Object object = LOCK;
        synchronized (object) {
            if (!keyFile.exists()) {
                this.receiveKey(keyFile, keyID);
            }
            try (InputStream keyIn = PGPUtil.getDecoderStream((InputStream)new FileInputStream(keyFile));){
                PGPPublicKeyRingCollection pgpRing = new PGPPublicKeyRingCollection(keyIn, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                key = pgpRing.getPublicKey(keyID);
                if (key == null) {
                    throw new PGPException(String.format("Can't find public key in download file: %s", keyFile));
                }
            }
            finally {
                if (key == null) {
                    this.deleteFile(keyFile);
                }
            }
        }
        return key;
    }

    private void receiveKey(File keyFile, long keyId) throws IOException {
        File dir = keyFile.getParentFile();
        if (dir == null) {
            throw new IOException("No parent dir for: " + keyFile);
        }
        if (dir.exists() && !dir.isDirectory()) {
            throw new IOException("Path exist but it isn't directory: " + dir);
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Can't create directory: " + dir);
        }
        File partFile = File.createTempFile(String.valueOf(keyId), "pgp-public-key");
        try {
            try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(partFile));){
                this.keysServerClient.copyKeyToOutputStream(keyId, outputStream, this::onRetry);
            }
            Files.move(partFile.toPath(), keyFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            this.deleteFile(keyFile);
            this.deleteFile(partFile);
            throw e;
        }
        this.log.info((CharSequence)String.format("Receive key: %s%n\tto %s", this.keysServerClient.getUriForGetKey(keyId), keyFile));
    }

    private void onRetry(InetAddress address, int numberOfRetryAttempts, Throwable lastThrowable) {
        this.log.warn((CharSequence)String.format("[Retry #%d] Last address %s with problem: %s", numberOfRetryAttempts, address, lastThrowable));
    }

    private void deleteFile(File file) {
        Optional.ofNullable(file).map(File::toPath).ifPresent(filePath -> {
            try {
                Files.deleteIfExists(filePath);
            }
            catch (IOException e) {
                this.log.warn((CharSequence)("Can't delete: " + filePath));
            }
        });
    }
}

