/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.openpgp.PGPPublicKey;

public class KeyInfo {
    private final boolean matchAny;
    private final List<byte[]> keysID = new ArrayList<byte[]>();

    public KeyInfo(String strKeys) {
        if ("*".equals(strKeys) || "any".equalsIgnoreCase(strKeys)) {
            this.matchAny = true;
            return;
        }
        this.matchAny = false;
        if (strKeys == null) {
            throw new IllegalArgumentException("null key not allowed");
        }
        if (strKeys.trim().isEmpty()) {
            return;
        }
        for (String key : strKeys.split(",")) {
            if (!(key = key.trim()).startsWith("0x")) {
                throw new IllegalArgumentException("Invalid keyID " + key + " must start with 0x");
            }
            byte[] bytes = this.strKeyToBytes(key.substring(2));
            this.keysID.add(bytes);
        }
    }

    private byte[] strKeyToBytes(String key) {
        BigInteger bigInteger = new BigInteger(key.replace(" ", ""), 16);
        byte[] bytes = bigInteger.toByteArray();
        if (bytes[0] == 0) {
            bytes = Arrays.copyOfRange(bytes, 1, bytes.length);
        }
        if (bytes.length < 8 || bytes.length > 20) {
            throw new IllegalArgumentException(String.format("Key length for = 0x%s is %d bits, should be between 64 and 160 bits", key, bytes.length * 8));
        }
        return bytes;
    }

    public boolean isKeyMatch(PGPPublicKey pgpPublicKeyey) {
        if (this.matchAny) {
            return true;
        }
        byte[] fingerprint = pgpPublicKeyey.getFingerprint();
        for (byte[] keyBytes : this.keysID) {
            if (!this.compareArrays(keyBytes, fingerprint)) continue;
            return true;
        }
        return false;
    }

    private boolean compareArrays(byte[] keyBytes, byte[] fingerprint) {
        for (int i = 1; i <= keyBytes.length && i <= fingerprint.length; ++i) {
            if (keyBytes[keyBytes.length - i] == fingerprint[fingerprint.length - i]) continue;
            return false;
        }
        return true;
    }

    public boolean isNoKey() {
        return this.keysID.isEmpty();
    }
}

