/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.maven.plugin.logging.Log;
import org.simplify4u.plugins.NullLogger;

public class PGPServerRetryHandler
implements HttpRequestRetryHandler,
ServiceUnavailableRetryStrategy {
    public static final int DEFAULT_MAX_RETRIES = 10;
    public static final int DEFAULT_BACKOFF_INTERVAL = 750;
    private final RequestRetryStrategy requestRetryHandler;
    private final ServiceRetryStrategy serviceRetryHandler;
    private final Log logger;

    public PGPServerRetryHandler() {
        this(10);
    }

    public PGPServerRetryHandler(Log logger) {
        this(logger, 10, 750L);
    }

    public PGPServerRetryHandler(int maxRetries) {
        this(new NullLogger(), maxRetries, 750L);
    }

    public PGPServerRetryHandler(Log logger, int maxRetries, long backoffInterval) {
        this.requestRetryHandler = new RequestRetryStrategy(maxRetries);
        this.serviceRetryHandler = new ServiceRetryStrategy(maxRetries, backoffInterval);
        this.logger = logger;
    }

    public boolean retryRequest(IOException cause, int executionCount, HttpContext requestContext) {
        boolean shouldRetry = this.requestRetryHandler.retryRequest(cause, executionCount, requestContext);
        long backoffDelay = this.serviceRetryHandler.getBackoffScalar() * (long)executionCount;
        this.dispatchRetry(shouldRetry, cause.toString(), executionCount, backoffDelay, requestContext);
        if (shouldRetry && backoffDelay > 0L) {
            try {
                Thread.sleep(backoffDelay);
            }
            catch (InterruptedException ex) {
                throw new IllegalStateException("Interrupted during request back-off", ex);
            }
        }
        return shouldRetry;
    }

    public boolean retryRequest(HttpResponse errorResponse, int executionCount, HttpContext requestContext) {
        boolean shouldRetry = this.serviceRetryHandler.retryRequest(errorResponse, executionCount, requestContext);
        this.dispatchRetry(shouldRetry, errorResponse.getStatusLine().toString(), executionCount, this.getRetryInterval(), requestContext);
        return shouldRetry;
    }

    public long getRetryInterval() {
        return this.serviceRetryHandler.getRetryInterval();
    }

    protected void onRetry(String retryReason, int retryCount, long backoffDelay, HttpContext requestContext) {
    }

    private void dispatchRetry(boolean shouldRetry, String retryReason, int retryCount, long backoffDelay, HttpContext requestContext) {
        if (shouldRetry) {
            this.logRetry(retryReason, retryCount, backoffDelay, requestContext);
            this.onRetry(retryReason, retryCount, backoffDelay, requestContext);
        }
    }

    private void logRetry(String retryReason, int retryCount, long backoffDelay, HttpContext requestContext) {
        HttpHost host = (HttpHost)requestContext.getAttribute("http.target_host");
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((CharSequence)String.format("[Retry %d of %d] Waiting %d milliseconds before retrying key request from %s after last request failed: %s", retryCount, this.requestRetryHandler.getRetryCount(), backoffDelay, this.describeHost(host), retryReason));
        }
    }

    private String describeHost(HttpHost host) {
        String description;
        try {
            InetAddress address = host.getAddress();
            if (address == null) {
                address = InetAddress.getByName(host.getHostName());
            }
            description = address.toString();
        }
        catch (UnknownHostException ex) {
            description = "(unknown)";
        }
        return description;
    }

    private static class ServiceRetryStrategy
    implements ServiceUnavailableRetryStrategy {
        private static final List<Integer> RETRYABLE_STATUS_CODES = ImmutableList.of((Object)408, (Object)500, (Object)502, (Object)503, (Object)504);
        private final int maxRetries;
        private final long backoffScalar;
        private final AtomicLong currentRetryCount;

        ServiceRetryStrategy(int maxRetries, long backoffScalar) {
            Args.positive((int)maxRetries, (String)"Max retries");
            Args.positive((long)backoffScalar, (String)"Back-off scalar interval");
            this.maxRetries = maxRetries;
            this.backoffScalar = backoffScalar;
            this.currentRetryCount = new AtomicLong(0L);
        }

        public long getBackoffScalar() {
            return this.backoffScalar;
        }

        public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
            boolean shouldRetry;
            boolean bl = shouldRetry = executionCount <= this.maxRetries && RETRYABLE_STATUS_CODES.contains(response.getStatusLine().getStatusCode());
            if (shouldRetry) {
                this.currentRetryCount.incrementAndGet();
            }
            return shouldRetry;
        }

        public long getRetryInterval() {
            return this.currentRetryCount.get() * this.backoffScalar;
        }
    }

    private static class RequestRetryStrategy
    extends DefaultHttpRequestRetryHandler {
        private static final List<Class<? extends IOException>> IGNORED_EXCEPTIONS = Collections.singletonList(SSLException.class);

        RequestRetryStrategy(int maxRetries) {
            super(maxRetries, false, IGNORED_EXCEPTIONS);
            Args.positive((int)maxRetries, (String)"Max retries");
        }
    }
}

