/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.CertificateException;
import java.util.Locale;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.simplify4u.plugins.PGPKeysServerClientHttp;
import org.simplify4u.plugins.PGPKeysServerClientHttps;
import org.simplify4u.plugins.PGPServerRetryHandler;

abstract class PGPKeysServerClient {
    private static final int DEFAULT_CONNECT_TIMEOUT = 5000;
    private static final int DEFAULT_READ_TIMEOUT = 20000;
    private final URI keyserver;
    private final int connectTimeout;
    private final int readTimeout;

    protected PGPKeysServerClient(URI keyserver, int connectTimeout, int readTimeout) throws URISyntaxException {
        this.keyserver = this.prepareKeyServerURI(keyserver);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    static PGPKeysServerClient getClient(String keyServer) throws URISyntaxException, CertificateException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        return PGPKeysServerClient.getClient(keyServer, 5000, 20000);
    }

    static PGPKeysServerClient getClient(String keyServer, int connectTimeout, int readTimeout) throws URISyntaxException, CertificateException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        String protocol;
        URI uri = new URI(keyServer);
        switch (protocol = uri.getScheme().toLowerCase(Locale.ROOT)) {
            case "hkp": 
            case "http": {
                return new PGPKeysServerClientHttp(uri, connectTimeout, readTimeout);
            }
            case "hkps": 
            case "https": {
                return new PGPKeysServerClientHttps(uri, connectTimeout, readTimeout);
            }
        }
        throw new URISyntaxException(keyServer, "Unsupported protocol: " + protocol);
    }

    private String getQueryStringForGetKey(long keyID) {
        return String.format("op=get&options=mr&search=0x%016X", keyID);
    }

    URI getUriForGetKey(long keyID) {
        try {
            return new URI(this.keyserver.getScheme(), this.keyserver.getUserInfo(), this.keyserver.getHost(), this.keyserver.getPort(), "/pks/lookup", this.getQueryStringForGetKey(keyID), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("URI exception for keyId 0x%016X", keyID), e);
        }
    }

    private String getQueryStringForShowKey(long keyID) {
        return String.format("op=vindex&fingerprint=on&search=0x%016X", keyID);
    }

    URI getUriForShowKey(long keyID) {
        try {
            return new URI(this.keyserver.getScheme(), this.keyserver.getUserInfo(), this.keyserver.getHost(), this.keyserver.getPort(), "/pks/lookup", this.getQueryStringForShowKey(keyID), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("URI exception for keyId 0x%016X", keyID), e);
        }
    }

    void copyKeyToOutputStream(long keyId, OutputStream outputStream, PGPServerRetryHandler retryHandler) throws IOException {
        this.copyKeyToOutputStream(keyId, outputStream, retryHandler, retryHandler);
    }

    void copyKeyToOutputStream(long keyId, OutputStream outputStream, HttpRequestRetryHandler requestRetryHandler, ServiceUnavailableRetryStrategy serviceRetryHandler) throws IOException {
        URI keyUri = this.getUriForGetKey(keyId);
        HttpGet request = new HttpGet(keyUri);
        try (CloseableHttpClient client = this.buildClient(requestRetryHandler, serviceRetryHandler);
             CloseableHttpResponse response = client.execute((HttpUriRequest)request);){
            this.processKeyResponse(response, outputStream);
        }
    }

    protected abstract HttpClientBuilder createClientBuilder();

    protected abstract URI prepareKeyServerURI(URI var1) throws URISyntaxException;

    private void processKeyResponse(CloseableHttpResponse response, OutputStream outputStream) throws IOException {
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() == 200) {
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity == null) {
                throw new IOException("No response body returned.");
            }
            try (InputStream inputStream = responseEntity.getContent();){
                ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
        } else {
            throw new IOException("PGP server returned an error: " + statusLine);
        }
    }

    private CloseableHttpClient buildClient(HttpRequestRetryHandler requestRetryHandler, ServiceUnavailableRetryStrategy serviceRetryHandler) {
        Security.setProperty("networkaddress.cache.ttl", "1");
        HttpClientBuilder clientBuilder = this.createClientBuilder();
        this.applyTimeouts(clientBuilder);
        clientBuilder.setRetryHandler(requestRetryHandler).setServiceUnavailableRetryStrategy(serviceRetryHandler);
        return clientBuilder.build();
    }

    private void applyTimeouts(HttpClientBuilder builder) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this.connectTimeout).setConnectTimeout(this.connectTimeout).setSocketTimeout(this.readTimeout).build();
        builder.setDefaultRequestConfig(requestConfig);
    }
}

