/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.pgp;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.simplify4u.plugins.pgp.ArtifactInfo;
import org.simplify4u.plugins.pgp.KeyInfo;
import org.simplify4u.plugins.pgp.SignatureInfo;
import org.simplify4u.plugins.pgp.SignatureStatus;

public final class SignatureCheckResult {
    @NonNull
    private final ArtifactInfo artifact;
    private final KeyInfo key;
    private final String keyShowUrl;
    private final SignatureInfo signature;
    @NonNull
    private final SignatureStatus status;
    @JsonIgnore
    private final Throwable errorCause;

    public String getErrorMessage() {
        return Optional.ofNullable(this.errorCause).map(Throwable::getMessage).orElse(null);
    }

    @ConstructorProperties(value={"artifact", "key", "keyShowUrl", "signature", "status", "errorCause"})
    @Generated
    SignatureCheckResult(@NonNull ArtifactInfo artifact, KeyInfo key, String keyShowUrl, SignatureInfo signature, @NonNull SignatureStatus status, Throwable errorCause) {
        if (artifact == null) {
            throw new NullPointerException("artifact is marked non-null but is null");
        }
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        this.artifact = artifact;
        this.key = key;
        this.keyShowUrl = keyShowUrl;
        this.signature = signature;
        this.status = status;
        this.errorCause = errorCause;
    }

    @Generated
    public static SignatureCheckResultBuilder builder() {
        return new SignatureCheckResultBuilder();
    }

    @NonNull
    @Generated
    public ArtifactInfo getArtifact() {
        return this.artifact;
    }

    @Generated
    public KeyInfo getKey() {
        return this.key;
    }

    @Generated
    public String getKeyShowUrl() {
        return this.keyShowUrl;
    }

    @Generated
    public SignatureInfo getSignature() {
        return this.signature;
    }

    @NonNull
    @Generated
    public SignatureStatus getStatus() {
        return this.status;
    }

    @Generated
    public Throwable getErrorCause() {
        return this.errorCause;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignatureCheckResult)) {
            return false;
        }
        SignatureCheckResult other = (SignatureCheckResult)o;
        ArtifactInfo this$artifact = this.getArtifact();
        ArtifactInfo other$artifact = other.getArtifact();
        if (this$artifact == null ? other$artifact != null : !((Object)this$artifact).equals(other$artifact)) {
            return false;
        }
        KeyInfo this$key = this.getKey();
        KeyInfo other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        String this$keyShowUrl = this.getKeyShowUrl();
        String other$keyShowUrl = other.getKeyShowUrl();
        if (this$keyShowUrl == null ? other$keyShowUrl != null : !this$keyShowUrl.equals(other$keyShowUrl)) {
            return false;
        }
        SignatureInfo this$signature = this.getSignature();
        SignatureInfo other$signature = other.getSignature();
        if (this$signature == null ? other$signature != null : !((Object)this$signature).equals(other$signature)) {
            return false;
        }
        SignatureStatus this$status = this.getStatus();
        SignatureStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        Throwable this$errorCause = this.getErrorCause();
        Throwable other$errorCause = other.getErrorCause();
        return !(this$errorCause == null ? other$errorCause != null : !this$errorCause.equals(other$errorCause));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ArtifactInfo $artifact = this.getArtifact();
        result = result * 59 + ($artifact == null ? 43 : ((Object)$artifact).hashCode());
        KeyInfo $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        String $keyShowUrl = this.getKeyShowUrl();
        result = result * 59 + ($keyShowUrl == null ? 43 : $keyShowUrl.hashCode());
        SignatureInfo $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : ((Object)$signature).hashCode());
        SignatureStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        Throwable $errorCause = this.getErrorCause();
        result = result * 59 + ($errorCause == null ? 43 : $errorCause.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SignatureCheckResult(artifact=" + this.getArtifact() + ", key=" + this.getKey() + ", keyShowUrl=" + this.getKeyShowUrl() + ", signature=" + this.getSignature() + ", status=" + (Object)((Object)this.getStatus()) + ", errorCause=" + this.getErrorCause() + ")";
    }

    @Generated
    public static class SignatureCheckResultBuilder {
        @Generated
        private ArtifactInfo artifact;
        @Generated
        private KeyInfo key;
        @Generated
        private String keyShowUrl;
        @Generated
        private SignatureInfo signature;
        @Generated
        private SignatureStatus status;
        @Generated
        private Throwable errorCause;

        @Generated
        SignatureCheckResultBuilder() {
        }

        @Generated
        public SignatureCheckResultBuilder artifact(@NonNull ArtifactInfo artifact) {
            if (artifact == null) {
                throw new NullPointerException("artifact is marked non-null but is null");
            }
            this.artifact = artifact;
            return this;
        }

        @Generated
        public SignatureCheckResultBuilder key(KeyInfo key) {
            this.key = key;
            return this;
        }

        @Generated
        public SignatureCheckResultBuilder keyShowUrl(String keyShowUrl) {
            this.keyShowUrl = keyShowUrl;
            return this;
        }

        @Generated
        public SignatureCheckResultBuilder signature(SignatureInfo signature) {
            this.signature = signature;
            return this;
        }

        @Generated
        public SignatureCheckResultBuilder status(@NonNull SignatureStatus status) {
            if (status == null) {
                throw new NullPointerException("status is marked non-null but is null");
            }
            this.status = status;
            return this;
        }

        @JsonIgnore
        @Generated
        public SignatureCheckResultBuilder errorCause(Throwable errorCause) {
            this.errorCause = errorCause;
            return this;
        }

        @Generated
        public SignatureCheckResult build() {
            return new SignatureCheckResult(this.artifact, this.key, this.keyShowUrl, this.signature, this.status, this.errorCause);
        }

        @Generated
        public String toString() {
            return "SignatureCheckResult.SignatureCheckResultBuilder(artifact=" + this.artifact + ", key=" + this.key + ", keyShowUrl=" + this.keyShowUrl + ", signature=" + this.signature + ", status=" + (Object)((Object)this.status) + ", errorCause=" + this.errorCause + ")";
        }
    }
}

