/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.pgp;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import lombok.NonNull;
import org.simplify4u.plugins.pgp.SignatureCheckResult;

@Named
@Singleton
public class ReportsUtils {
    private final ObjectMapper objectMapper = new ObjectMapper();

    protected ReportsUtils() {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.objectMapper.setDateFormat((DateFormat)new StdDateFormat().withColonInTimeZone(true));
    }

    public void writeReportAsJson(File reportFile, @NonNull Collection<SignatureCheckResult> checkResults) throws IOException {
        if (checkResults == null) {
            throw new NullPointerException("checkResults is marked non-null but is null");
        }
        Optional.ofNullable(reportFile.getParentFile()).ifPresent(File::mkdirs);
        this.objectMapper.writeValue(reportFile, checkResults);
    }
}

