/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.simplify4u.plugins.AbstractPGPMojo;
import org.simplify4u.plugins.PGPMojoException;
import org.simplify4u.plugins.pgp.ArtifactInfo;
import org.simplify4u.plugins.pgp.KeyInfo;
import org.simplify4u.plugins.pgp.SignatureCheckResult;
import org.simplify4u.plugins.pgp.SignatureInfo;
import org.simplify4u.plugins.pgp.SignatureStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="show", requiresOnline=true, requiresProject=false)
public class ShowMojo
extends AbstractPGPMojo {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ShowMojo.class);
    public static final String MOJO_NAME = "show";
    @Inject
    private RepositorySystem repositorySystem;
    @Parameter(property="showPom", defaultValue="false")
    protected boolean showPom;
    @Parameter(property="artifact", required=true)
    private String artifact;

    @Override
    protected String getMojoName() {
        return MOJO_NAME;
    }

    @Override
    protected void executeConfiguredMojo() {
        Artifact artifactToCheck = this.prepareArtifactToCheck();
        List<Artifact> resolveArtifacts = this.artifactResolver.resolveArtifact(artifactToCheck, this.showPom);
        Map<Artifact, Artifact> artifactMap = this.artifactResolver.resolveSignatures(resolveArtifacts);
        Boolean result = artifactMap.entrySet().stream().map(this::processArtifact).reduce(true, (a, b) -> a != false && b != false);
        if (Boolean.FALSE.equals(result)) {
            throw new PGPMojoException("Some of artifact can't be checked");
        }
    }

    private boolean processArtifact(Map.Entry<Artifact, Artifact> artifactEntry) {
        Artifact artifactToCheck = artifactEntry.getKey();
        Artifact sig = artifactEntry.getValue();
        SignatureCheckResult signatureCheckResult = this.signatureUtils.checkSignature(artifactToCheck, sig, this.pgpKeysCache);
        MessageBuilder messageBuilder = MessageUtils.buffer();
        messageBuilder.newline();
        messageBuilder.newline();
        ArtifactInfo artifactInfo = signatureCheckResult.getArtifact();
        messageBuilder.a((CharSequence)"Artifact:").newline();
        messageBuilder.a((CharSequence)"\tgroupId:     ").strong((Object)artifactInfo.getGroupId()).newline();
        messageBuilder.a((CharSequence)"\tartifactId:  ").strong((Object)artifactInfo.getArtifactId()).newline();
        messageBuilder.a((CharSequence)"\ttype:        ").strong((Object)artifactInfo.getType()).newline();
        Optional.ofNullable(artifactInfo.getClassifier()).ifPresent(classifier -> messageBuilder.a((CharSequence)"\tclassifier:  ").strong(classifier).newline());
        messageBuilder.a((CharSequence)"\tversion:     ").strong((Object)artifactInfo.getVersion()).newline();
        if (signatureCheckResult.getStatus() == SignatureStatus.ARTIFACT_NOT_RESOLVED) {
            messageBuilder.a((CharSequence)"\t").failure((Object)"artifact was not resolved  - try mvn -U ...").newline();
        }
        messageBuilder.newline();
        SignatureInfo signature = signatureCheckResult.getSignature();
        if (signature != null) {
            messageBuilder.a((CharSequence)"PGP signature:").newline();
            messageBuilder.a((CharSequence)"\tversion:     ").strong((Object)signature.getVersion()).newline();
            messageBuilder.a((CharSequence)"\talgorithm:   ").strong((Object)(this.signatureUtils.digestName(signature.getHashAlgorithm()) + " with " + this.signatureUtils.keyAlgorithmName(signature.getKeyAlgorithm()))).newline();
            messageBuilder.a((CharSequence)"\tkeyId:       ").strong((Object)signature.getKeyId()).newline();
            messageBuilder.a((CharSequence)"\tcreate date: ").strong((Object)signature.getDate()).newline();
            messageBuilder.a((CharSequence)"\tstatus:      ");
            if (signatureCheckResult.getStatus() == SignatureStatus.SIGNATURE_VALID) {
                messageBuilder.success((Object)"valid");
            } else {
                messageBuilder.failure((Object)"invalid");
            }
            messageBuilder.newline();
        } else if (signatureCheckResult.getStatus() == SignatureStatus.SIGNATURE_NOT_RESOLVED) {
            messageBuilder.a((CharSequence)"\t").failure((Object)"PGP signature was not resolved - try mvn -U ...").newline();
        }
        messageBuilder.newline();
        KeyInfo key = signatureCheckResult.getKey();
        if (key != null) {
            messageBuilder.a((CharSequence)"PGP key:").newline();
            messageBuilder.a((CharSequence)"\tversion:     ").strong((Object)key.getVersion()).newline();
            messageBuilder.a((CharSequence)"\talgorithm:   ").strong((Object)this.signatureUtils.keyAlgorithmName(key.getAlgorithm())).newline();
            messageBuilder.a((CharSequence)"\tbits:        ").strong((Object)key.getBits()).newline();
            messageBuilder.a((CharSequence)"\tfingerprint: ").strong((Object)key.getFingerprint()).newline();
            Optional.ofNullable(key.getMaster()).ifPresent(masterKey -> messageBuilder.a((CharSequence)"\tmaster key:  ").strong(masterKey).newline());
            messageBuilder.a((CharSequence)"\tcreate date: ").strong((Object)key.getDate()).newline();
            messageBuilder.a((CharSequence)"\tuids:        ").strong(key.getUids()).newline();
        }
        messageBuilder.newline();
        Optional.ofNullable(signatureCheckResult.getErrorMessage()).ifPresent(errorMessage -> messageBuilder.failure(errorMessage).newline());
        LOGGER.info(messageBuilder.build());
        return signatureCheckResult.getStatus() == SignatureStatus.SIGNATURE_VALID;
    }

    private Artifact prepareArtifactToCheck() {
        String[] aItems = Optional.ofNullable(this.artifact).map(String::trim).map(s -> s.split(":")).filter(a -> ((String[])a).length >= 3 && ((String[])a).length <= 5).orElseThrow(() -> new PGPMojoException("The parameters 'artifact' is miss or in invalid format - groupId:artifactId:version[:packaging[:classifier]]"));
        return this.repositorySystem.createArtifactWithClassifier(aItems[0], aItems[1], aItems[2], ShowMojo.getItem(aItems, 3, "jar"), ShowMojo.getItem(aItems, 4, null));
    }

    private static String getItem(String[] items, int index, String defaultValue) {
        if (items.length > index) {
            return items[index];
        }
        return defaultValue;
    }

    @Generated
    void setShowPom(boolean showPom) {
        this.showPom = showPom;
    }

    @Generated
    void setArtifact(String artifact) {
        this.artifact = artifact;
    }
}

