/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.keyserver;

import com.google.common.io.ByteStreams;
import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.event.RetryEvent;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedRunnable;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.maven.settings.Proxy;
import org.simplify4u.plugins.keyserver.KeyServerClientSettings;
import org.simplify4u.plugins.keyserver.PGPKeyNotFound;
import org.simplify4u.plugins.keyserver.PGPKeysServerClientHttp;
import org.simplify4u.plugins.keyserver.PGPKeysServerClientHttps;
import org.simplify4u.plugins.keyserver.RoundRobinRouterPlaner;
import org.simplify4u.plugins.pgp.KeyId;
import org.simplify4u.plugins.utils.ExceptionUtils;

class PGPKeysServerClient {
    private static final List<Class<? extends Throwable>> IGNORE_EXCEPTION_FOR_RETRY = Arrays.asList(PGPKeyNotFound.class, UnknownHostException.class);
    private final KeyServerClientSettings keyServerClientSettings;
    private final URI keyserver;

    protected PGPKeysServerClient(URI keyserver, KeyServerClientSettings keyServerClientSettings) {
        this.keyserver = keyserver;
        this.keyServerClientSettings = keyServerClientSettings;
    }

    static PGPKeysServerClient getClient(String keyServer, KeyServerClientSettings keyServerClientSettings) throws IOException {
        String protocol;
        URI uri = (URI)Try.of((CheckedFunction0 & Serializable)() -> new URI(keyServer)).getOrElseThrow(IOException::new);
        switch (protocol = uri.getScheme().toLowerCase(Locale.ROOT)) {
            case "hkp": 
            case "http": {
                return new PGPKeysServerClientHttp(uri, keyServerClientSettings);
            }
            case "hkps": 
            case "https": {
                return new PGPKeysServerClientHttps(uri, keyServerClientSettings);
            }
        }
        throw new IOException("Unsupported protocol: " + protocol);
    }

    private static String getQueryStringForGetKey(KeyId keyID) {
        return String.format("op=get&options=mr&search=%s", keyID);
    }

    URI getUriForGetKey(KeyId keyID) {
        return (URI)Try.of((CheckedFunction0 & Serializable)() -> new URI(this.keyserver.getScheme(), this.keyserver.getUserInfo(), this.keyserver.getHost(), this.keyserver.getPort(), "/pks/lookup", PGPKeysServerClient.getQueryStringForGetKey(keyID), null)).get();
    }

    private static String getQueryStringForShowKey(KeyId keyID) {
        return String.format("op=vindex&fingerprint=on&search=%s", keyID);
    }

    URI getUriForShowKey(KeyId keyID) {
        return (URI)Try.of((CheckedFunction0 & Serializable)() -> new URI(this.keyserver.getScheme(), this.keyserver.getUserInfo(), this.keyserver.getHost(), this.keyserver.getPort(), "/pks/lookup", PGPKeysServerClient.getQueryStringForShowKey(keyID), null)).get();
    }

    void copyKeyToOutputStream(KeyId keyId, OutputStream outputStream, OnRetryConsumer onRetryConsumer) throws IOException {
        URI keyUri = this.getUriForGetKey(keyId);
        if (this.keyServerClientSettings.isOffline()) {
            throw new IOException("Not possible to download key: " + keyUri + " in offline mode.");
        }
        HttpGet request = new HttpGet(keyUri);
        HttpRoutePlanner planer = this.keyServerClientSettings.getProxy().map(PGPKeysServerClient::getNewProxyRoutePlanner).orElseGet(RoundRobinRouterPlaner::new);
        RetryConfig config = RetryConfig.custom().maxAttempts(this.keyServerClientSettings.getMaxRetries()).intervalFunction(IntervalFunction.ofExponentialBackoff()).retryOnException(PGPKeysServerClient::shouldRetryOnException).build();
        Retry retry = Retry.of((String)"id", (RetryConfig)config);
        retry.getEventPublisher().onRetry(event -> this.processOnRetry((RetryEvent)event, event.getWaitInterval(), planer, onRetryConsumer)).onError(event -> this.processOnRetry((RetryEvent)event, Duration.ZERO, planer, onRetryConsumer));
        CheckedRunnable checkedRunnable = Retry.decorateCheckedRunnable((Retry)retry, () -> this.lambda$copyKeyToOutputStream$2(planer, (HttpUriRequest)request, outputStream));
        try {
            checkedRunnable.run();
        }
        catch (PGPKeyNotFound e) {
            throw new PGPKeyNotFound("PGP server returned an error: HTTP/1.1 404 Not Found for: " + keyUri);
        }
        catch (Throwable e) {
            throw new IOException(ExceptionUtils.getMessage(e) + " for: " + keyUri, e);
        }
    }

    private static HttpRoutePlanner getNewProxyRoutePlanner(Proxy proxy) {
        HttpHost httpHost = new HttpHost(proxy.getHost(), proxy.getPort());
        return new DefaultProxyRoutePlanner(httpHost);
    }

    private static boolean shouldRetryOnException(Throwable throwable) {
        for (Throwable aThrowable = throwable; aThrowable != null; aThrowable = aThrowable.getCause()) {
            if (!IGNORE_EXCEPTION_FOR_RETRY.contains(aThrowable.getClass())) continue;
            return false;
        }
        return true;
    }

    private void processOnRetry(RetryEvent event, Duration waitInterval, HttpRoutePlanner planer, OnRetryConsumer onRetryConsumer) {
        InetAddress targetAddress = null;
        if (planer instanceof RoundRobinRouterPlaner) {
            HttpRoute httpRoute = ((RoundRobinRouterPlaner)planer).lastRouteCauseError();
            targetAddress = (InetAddress)Try.of((CheckedFunction0 & Serializable)() -> httpRoute.getTargetHost().getAddress()).getOrElse((Object)null);
        } else if (planer instanceof DefaultProxyRoutePlanner) {
            targetAddress = this.keyServerClientSettings.getProxy().map(Proxy::getHost).map(host -> (InetAddress)Try.of((CheckedFunction0 & Serializable)() -> InetAddress.getByName(host)).getOrNull()).orElse(null);
        }
        if (onRetryConsumer != null) {
            onRetryConsumer.onRetry(targetAddress, event.getNumberOfRetryAttempts(), waitInterval, event.getLastThrowable());
        }
    }

    protected HttpClientBuilder createClientBuilder() {
        return this.setupProxy(HttpClientBuilder.create());
    }

    private static void processKeyResponse(CloseableHttpResponse response, OutputStream outputStream) throws IOException {
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() == 404) {
            throw new PGPKeyNotFound();
        }
        if (statusLine.getStatusCode() == 200) {
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity == null) {
                throw new IOException("No response body returned.");
            }
            try (InputStream inputStream = responseEntity.getContent();){
                ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
        } else {
            throw new IOException("PGP server returned an error: " + statusLine);
        }
    }

    private CloseableHttpClient buildClient(HttpRoutePlanner planer) {
        HttpClientBuilder clientBuilder = this.createClientBuilder();
        this.applyTimeouts(clientBuilder);
        clientBuilder.setRoutePlanner(planer);
        return clientBuilder.build();
    }

    private void applyTimeouts(HttpClientBuilder builder) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this.keyServerClientSettings.getConnectTimeout()).setConnectTimeout(this.keyServerClientSettings.getConnectTimeout()).setSocketTimeout(this.keyServerClientSettings.getReadTimeout()).build();
        builder.setDefaultRequestConfig(requestConfig);
    }

    protected HttpClientBuilder setupProxy(HttpClientBuilder clientBuilder) {
        Optional<Proxy> optProxy = this.keyServerClientSettings.getProxy();
        if (!optProxy.isPresent()) {
            return clientBuilder;
        }
        Proxy proxy = optProxy.get();
        if (proxy.getUsername() != null && !proxy.getUsername().isEmpty() && proxy.getPassword() != null && !proxy.getPassword().isEmpty()) {
            clientBuilder.setProxyAuthenticationStrategy((AuthenticationStrategy)ProxyAuthenticationStrategy.INSTANCE);
            BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
            AuthScope proxyAuthScope = new AuthScope(proxy.getHost(), proxy.getPort());
            UsernamePasswordCredentials proxyAuthentication = new UsernamePasswordCredentials(proxy.getUsername(), proxy.getPassword());
            basicCredentialsProvider.setCredentials(proxyAuthScope, (Credentials)proxyAuthentication);
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
        }
        return clientBuilder;
    }

    public String toString() {
        return "{" + this.keyserver + "}";
    }

    private /* synthetic */ void lambda$copyKeyToOutputStream$2(HttpRoutePlanner planer, HttpUriRequest request, OutputStream outputStream) throws Throwable {
        try (CloseableHttpClient client = this.buildClient(planer);
             CloseableHttpResponse response = client.execute(request);){
            PGPKeysServerClient.processKeyResponse(response, outputStream);
        }
    }

    @FunctionalInterface
    public static interface OnRetryConsumer {
        public void onRetry(InetAddress var1, int var2, Duration var3, Throwable var4);
    }
}

