/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.simplify4u.plugins.ArtifactResolver;
import org.simplify4u.plugins.keyserver.KeyServerClientSettings;
import org.simplify4u.plugins.keyserver.PGPKeysCache;
import org.simplify4u.plugins.pgp.SignatureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPGPMojo
extends AbstractMojo {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPGPMojo.class);
    @Inject
    protected ArtifactResolver artifactResolver;
    @Inject
    protected PGPKeysCache pgpKeysCache;
    @Inject
    protected SignatureUtils signatureUtils;
    @Inject
    protected MavenSession session;
    @Parameter(property="pgpverify.keycache", required=true, defaultValue="${settings.localRepository}/pgpkeys-cache")
    private File pgpKeysCachePath;
    @Parameter(property="pgpverify.keyserver", required=true, defaultValue="hkps://keyserver.ubuntu.com, hkps://keys.openpgp.org, hkps://pgp.mit.edu")
    private String pgpKeyServer;
    @Parameter(property="pgpverify.proxyName")
    private String proxyName;
    @Parameter(property="pgpverify.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="pgpverify.keyserversLoadBalance", defaultValue="false")
    private boolean pgpKeyServerLoadBalance;
    @Parameter(property="pgpverify.quiet", defaultValue="false")
    private boolean quiet;

    public final Log getLog() {
        throw new UnsupportedOperationException("SLF4J should be used directly");
    }

    protected abstract String getMojoName();

    protected abstract void executeConfiguredMojo() throws MojoExecutionException, MojoFailureException;

    protected void checkDeprecated() {
    }

    protected void setupMojo() throws MojoFailureException {
        KeyServerClientSettings clientSettings = KeyServerClientSettings.builder().mavenSession(this.session).proxyName(this.proxyName).build();
        try {
            this.pgpKeysCache.init(this.pgpKeysCachePath, this.pgpKeyServer, this.pgpKeyServerLoadBalance, clientSettings);
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            LOGGER.info("Skipping pgpverify:{}", (Object)this.getMojoName());
            return;
        }
        this.setupMojo();
        this.checkDeprecated();
        this.executeConfiguredMojo();
    }

    protected void logInfoWithQuiet(String message) {
        if (this.quiet) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(message);
            }
        } else {
            LOGGER.info(message);
        }
    }

    protected void logInfoWithQuiet(String message, Supplier<?> ... args) {
        if (this.quiet) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(message, Arrays.stream(args).map(Supplier::get).toArray());
            }
        } else {
            LOGGER.info(message, Arrays.stream(args).map(Supplier::get).toArray());
        }
    }

    protected void logWarnWithQuiet(String message, Supplier<?> ... args) {
        if (this.quiet) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(message, Arrays.stream(args).map(Supplier::get).toArray());
            }
        } else {
            LOGGER.warn(message, Arrays.stream(args).map(Supplier::get).toArray());
        }
    }

    @Generated
    void setSkip(boolean skip) {
        this.skip = skip;
    }
}

