/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.utils;

import lombok.Generated;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;

public final class HexUtils {
    public static String fingerprintToString(byte[] bytes) {
        StringBuilder ret = new StringBuilder();
        ret.append("0x");
        for (byte b : bytes) {
            ret.append(String.format("%02X", b));
        }
        return ret.toString();
    }

    public static byte[] stringToFingerprint(String key) {
        byte[] bytes;
        try {
            bytes = Hex.decode((String)key.substring(2));
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException("Malformed keyID hex string " + key, e);
        }
        if (bytes.length < 8 || bytes.length > 20) {
            throw new IllegalArgumentException(String.format("Key length for = %s is %d bits, should be between 64 and 160 bits", key, bytes.length * 8));
        }
        return bytes;
    }

    @Generated
    private HexUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

