/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins;

import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.simplify4u.plugins.AscArtifactHandler;
import org.simplify4u.plugins.skipfilters.CompositeSkipper;
import org.simplify4u.plugins.skipfilters.ScopeSkipper;
import org.simplify4u.plugins.skipfilters.SkipFilter;
import org.simplify4u.plugins.utils.MavenCompilerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ArtifactResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ArtifactResolver.class);
    private static final VersionRange SUREFIRE_PLUGIN_VERSION_RANGE = (VersionRange)Try.of((CheckedFunction0 & Serializable)() -> VersionRange.createFromVersionSpec((String)"(2.999999999,4)")).getOrElseThrow(e -> new IllegalStateException("BUG: Failed to create version range.", (Throwable)e));
    private final RepositorySystem repositorySystem;
    private final ArtifactRepository localRepository;
    private final List<ArtifactRepository> remoteRepositories;
    private final List<ArtifactRepository> remoteRepositoriesIgnoreCheckSum;

    @Inject
    ArtifactResolver(RepositorySystem repositorySystem, MavenSession session) {
        this.repositorySystem = Objects.requireNonNull(repositorySystem);
        this.localRepository = Objects.requireNonNull(session.getLocalRepository());
        this.remoteRepositories = Objects.requireNonNull(session.getCurrentProject().getRemoteArtifactRepositories());
        this.remoteRepositoriesIgnoreCheckSum = this.repositoriesIgnoreCheckSum(this.remoteRepositories);
    }

    private List<ArtifactRepository> repositoriesIgnoreCheckSum(List<ArtifactRepository> repositories) {
        return Optional.ofNullable(repositories).orElse(Collections.emptyList()).stream().map(this::repositoryIgnoreCheckSum).collect(Collectors.toList());
    }

    private ArtifactRepository repositoryIgnoreCheckSum(ArtifactRepository repository) {
        ArtifactRepository newRepository = this.repositorySystem.createArtifactRepository(repository.getId(), repository.getUrl(), repository.getLayout(), ArtifactResolver.policyIgnoreCheckSum(repository.getSnapshots()), ArtifactResolver.policyIgnoreCheckSum(repository.getReleases()));
        newRepository.setAuthentication(repository.getAuthentication());
        newRepository.setProxy(repository.getProxy());
        newRepository.setMirroredRepositories(this.repositoriesIgnoreCheckSum(repository.getMirroredRepositories()));
        return newRepository;
    }

    private static ArtifactRepositoryPolicy policyIgnoreCheckSum(ArtifactRepositoryPolicy policy) {
        return new ArtifactRepositoryPolicy(policy.isEnabled(), policy.getUpdatePolicy(), "ignore");
    }

    Set<Artifact> resolveProjectArtifacts(MavenProject project, Configuration config) throws MojoExecutionException {
        LinkedHashSet<Artifact> allArtifacts = new LinkedHashSet<Artifact>(this.resolveArtifacts(project.getArtifacts(), config.dependencyFilter, null, config.verifyPomFiles, false));
        if (config.verifyPlugins) {
            for (Plugin plugin : project.getBuildPlugins()) {
                LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
                artifacts.add(this.repositorySystem.createPluginArtifact(plugin));
                artifacts.addAll(plugin.getDependencies().stream().map(arg_0 -> ((RepositorySystem)this.repositorySystem).createDependencyArtifact(arg_0)).collect(Collectors.toSet()));
                Set<Artifact> resolved = this.resolveArtifacts(artifacts, config.pluginFilter, config.dependencyFilter, config.verifyPomFiles, config.verifyPluginDependencies);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Build plugin dependencies for {}:{}:{} {}", new Object[]{plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion(), resolved});
                }
                allArtifacts.addAll(resolved);
            }
            for (Plugin plugin : project.getReportArtifacts()) {
                Set<Artifact> resolved = this.resolveArtifacts(Collections.singleton(plugin), config.pluginFilter, config.dependencyFilter, config.verifyPomFiles, config.verifyPluginDependencies);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Report plugin dependencies for {}:{}:{} {}", new Object[]{plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion(), resolved});
                }
                allArtifacts.addAll(resolved);
            }
        }
        if (config.verifyAtypical) {
            allArtifacts.addAll(this.resolveArtifacts(this.searchCompilerAnnotationProcessors(project), config.dependencyFilter, config.dependencyFilter, config.verifyPomFiles, config.verifyPluginDependencies));
            this.informSurefire3RuntimeDependencyLoadingLimitation(project);
        }
        return allArtifacts;
    }

    private Collection<Artifact> searchCompilerAnnotationProcessors(MavenProject project) {
        return project.getBuildPlugins().stream().filter(MavenCompilerUtils::checkCompilerPlugin).flatMap(p -> MavenCompilerUtils.extractAnnotationProcessors(this.repositorySystem, p).stream()).collect(Collectors.toList());
    }

    private void informSurefire3RuntimeDependencyLoadingLimitation(MavenProject project) {
        boolean surefireDynamicLoadingLikely = project.getBuildPlugins().stream().filter(p -> "org.apache.maven.plugins".equals(p.getGroupId())).filter(p -> "maven-surefire-plugin".equals(p.getArtifactId())).anyMatch(this::matchSurefireVersion);
        if (surefireDynamicLoadingLikely) {
            LOG.info("NOTE: maven-surefire-plugin version 3 is present. This version is known to resolve and load dependencies for various unit testing frameworks (called \"providers\") during execution. These dependencies are not validated.");
        }
    }

    private boolean matchSurefireVersion(Plugin plugin) {
        return (Boolean)Try.of((CheckedFunction0 & Serializable)() -> this.repositorySystem.createPluginArtifact(plugin).getSelectedVersion()).map(arg_0 -> ((VersionRange)SUREFIRE_PLUGIN_VERSION_RANGE).containsVersion(arg_0)).onFailure(e -> LOG.debug("Found build plug-in with overly constrained version specification.", e)).getOrElse((Object)false);
    }

    Map<Artifact, Artifact> resolveSignatures(Collection<Artifact> artifacts) {
        return artifacts.stream().collect(Collectors.toMap(Function.identity(), this::resolveSignature));
    }

    private Artifact resolveSignature(Artifact artifact) {
        Artifact aAsc = this.repositorySystem.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), artifact.getClassifier());
        aAsc.setArtifactHandler((ArtifactHandler)new AscArtifactHandler(aAsc));
        ArtifactResolutionResult ascResult = this.request(aAsc, this.remoteRepositoriesIgnoreCheckSum);
        if (!ascResult.isSuccess()) {
            ascResult.getExceptions().forEach(e -> LOG.debug("Failed to resolve asc {}: {}", (Object)aAsc.getId(), (Object)e.getMessage()));
        }
        return aAsc;
    }

    private Set<Artifact> resolveArtifacts(Iterable<Artifact> artifacts, SkipFilter artifactFilter, SkipFilter dependenciesFilter, boolean verifyPom, boolean transitive) throws MojoExecutionException {
        LinkedHashSet<Artifact> collection = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            Artifact resolved = this.resolveArtifact(artifact);
            if (artifactFilter.shouldSkipArtifact(artifact)) {
                LOG.debug("Skipping artifact: {}", (Object)artifact);
                continue;
            }
            if (!resolved.isResolved()) {
                throw new MojoExecutionException("Failed to resolve artifact: {}" + artifact);
            }
            collection.add(resolved);
            if (!verifyPom) continue;
            Artifact resolvedPom = this.resolvePom(artifact);
            if (resolvedPom.isResolved()) {
                collection.add(resolvedPom);
                continue;
            }
            LOG.warn("Failed to resolve pom artifact: {}", (Object)resolvedPom);
        }
        if (transitive) {
            CompositeSkipper transitivesFilter = new CompositeSkipper(dependenciesFilter, new ScopeSkipper("runtime"));
            LinkedHashSet<Artifact> transitives = new LinkedHashSet<Artifact>();
            for (Artifact artifact : collection) {
                transitives.addAll(this.resolveTransitively(artifact, transitivesFilter, verifyPom));
            }
            collection.addAll(transitives);
        }
        return collection;
    }

    private Set<Artifact> resolveTransitively(Artifact artifact, SkipFilter dependencyFilter, boolean verifyPom) throws MojoExecutionException {
        ArtifactFilter requestFilter = a -> !dependencyFilter.shouldSkipArtifact(a);
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(artifact).setLocalRepository(this.localRepository).setRemoteRepositories(this.remoteRepositories).setResolutionFilter(requestFilter).setCollectionFilter(requestFilter).setResolveTransitively(true);
        ArtifactResolutionResult resolution = this.repositorySystem.resolve(request);
        if (!resolution.isSuccess()) {
            if (resolution.hasMissingArtifacts()) {
                LOG.warn("Missing artifacts for {}: {}", (Object)artifact.getId(), (Object)resolution.getMissingArtifacts());
            }
            resolution.getExceptions().forEach(e -> LOG.warn("Failed to resolve transitive dependencies for {}: {}", (Object)artifact.getId(), (Object)e.getMessage()));
            throw new MojoExecutionException("Failed to resolve transitive dependencies.");
        }
        if (verifyPom) {
            LinkedHashSet<Artifact> resolved = new LinkedHashSet<Artifact>(resolution.getArtifacts());
            for (Artifact a2 : resolution.getArtifacts()) {
                resolved.add(this.resolvePom(a2));
            }
            return resolved;
        }
        return resolution.getArtifacts();
    }

    public Artifact resolvePom(Artifact artifact) {
        Artifact pomArtifact = this.repositorySystem.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        ArtifactResolutionResult result = this.request(pomArtifact, this.remoteRepositories);
        if (!result.isSuccess()) {
            result.getExceptions().forEach(e -> LOG.debug("Failed to resolve pom {}: {}", (Object)pomArtifact.getId(), (Object)e.getMessage()));
        }
        return pomArtifact;
    }

    public Artifact resolveArtifact(Artifact artifact) {
        ArtifactResolutionResult result = this.request(artifact, this.remoteRepositories);
        if (!result.isSuccess()) {
            result.getExceptions().forEach(e -> LOG.warn("Failed to resolve {}: {}", (Object)artifact.getId(), (Object)e.getMessage()));
        }
        return artifact;
    }

    private ArtifactResolutionResult request(Artifact artifact, List<ArtifactRepository> remoteRepositoriesToResolve) {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setResolveTransitively(false);
        request.setLocalRepository(this.localRepository);
        request.setRemoteRepositories(remoteRepositoriesToResolve);
        return this.repositorySystem.resolve(request);
    }

    public static final class Configuration {
        final SkipFilter dependencyFilter;
        final SkipFilter pluginFilter;
        final boolean verifyPomFiles;
        final boolean verifyPlugins;
        final boolean verifyPluginDependencies;
        final boolean verifyAtypical;

        public Configuration(SkipFilter dependencyFilter, SkipFilter pluginFilter, boolean verifyPomFiles, boolean verifyPlugins, boolean verifyPluginDependencies, boolean verifyAtypical) {
            this.dependencyFilter = Objects.requireNonNull(dependencyFilter);
            this.pluginFilter = Objects.requireNonNull(pluginFilter);
            this.verifyPomFiles = verifyPomFiles;
            this.verifyPlugins = verifyPlugins || verifyPluginDependencies;
            this.verifyPluginDependencies = verifyPluginDependencies;
            this.verifyAtypical = verifyAtypical;
        }
    }
}

