/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins;

import io.vavr.control.Try;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.simplify4u.plugins.AbstractPGPMojo;
import org.simplify4u.plugins.ArtifactResolver;
import org.simplify4u.plugins.PGPMojoException;
import org.simplify4u.plugins.ValidationChecksum;
import org.simplify4u.plugins.keyserver.PGPKeyNotFound;
import org.simplify4u.plugins.keysmap.KeysMap;
import org.simplify4u.plugins.keysmap.KeysMapLocationConfig;
import org.simplify4u.plugins.skipfilters.CompositeSkipper;
import org.simplify4u.plugins.skipfilters.ProvidedDependencySkipper;
import org.simplify4u.plugins.skipfilters.ReactorDependencySkipper;
import org.simplify4u.plugins.skipfilters.ScopeSkipper;
import org.simplify4u.plugins.skipfilters.SkipFilter;
import org.simplify4u.plugins.skipfilters.SnapshotDependencySkipper;
import org.simplify4u.plugins.skipfilters.SystemDependencySkipper;
import org.simplify4u.plugins.utils.PGPKeyId;
import org.simplify4u.plugins.utils.PGPSignatureException;
import org.simplify4u.plugins.utils.PublicKeyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="check", requiresProject=true, requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class PGPVerifyMojo
extends AbstractPGPMojo {
    private static final Logger LOGGER = LoggerFactory.getLogger(PGPVerifyMojo.class);
    public static final String MOJO_NAME = "check";
    private static final String PGP_VERIFICATION_RESULT_FORMAT = "{} PGP Signature {}\n       {} UserIds: {}";
    @Inject
    protected KeysMap keysMap;
    @Parameter(property="pgpverify.scope", defaultValue="test")
    private String scope;
    @Parameter(property="pgpverify.failNoSignature", defaultValue="false")
    private boolean failNoSignature;
    @Deprecated
    @Parameter(property="pgpverify.strictNoSignature")
    private Boolean strictNoSignature;
    @Parameter(property="pgpgverify.failWeakSignature", defaultValue="false")
    private boolean failWeakSignature;
    @Parameter(property="pgpverify.verifyPomFiles", defaultValue="true")
    private boolean verifyPomFiles;
    @Parameter(property="pgpverify.verifySnapshots", defaultValue="false")
    private boolean verifySnapshots;
    @Parameter(property="pgpverify.verifyPlugins", defaultValue="false")
    private boolean verifyPlugins;
    @Parameter(property="pgpverify.verifyPluginDependencies", defaultValue="false")
    private boolean verifyPluginDependencies;
    @Parameter(property="pgpverify.verifyAtypical", defaultValue="false")
    private boolean verifyAtypical;
    @Parameter(property="pgpverify.verifyProvidedDependencies", defaultValue="false")
    private boolean verifyProvidedDependencies;
    @Parameter(property="pgpverify.verifySystemDependencies", defaultValue="false")
    private boolean verifySystemDependencies;
    @Parameter(property="pgpverify.verifyReactorDependencies", defaultValue="false")
    private boolean verifyReactorDependencies;
    @Parameter(property="pgpverify.disableChecksum", defaultValue="false")
    private boolean disableChecksum;
    @Parameter(property="pgpverify.keysMapLocation", alias="keysMapLocations")
    private List<KeysMapLocationConfig> keysMapLocation = new ArrayList<KeysMapLocationConfig>();

    @Override
    protected String getMojoName() {
        return MOJO_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeConfiguredMojo() throws MojoExecutionException, MojoFailureException {
        this.initKeysMap();
        this.checkDeprecated();
        File mavenBuildDir = new File(this.session.getCurrentProject().getBuild().getDirectory());
        SkipFilter dependencyFilter = this.prepareDependencyFilters();
        SkipFilter pluginFilter = this.preparePluginFilters();
        long artifactResolutionStart = System.nanoTime();
        ArtifactResolver.Configuration config = new ArtifactResolver.Configuration(dependencyFilter, pluginFilter, this.verifyPomFiles, this.verifyPlugins, this.verifyPluginDependencies, this.verifyAtypical);
        Set<Artifact> artifacts = this.artifactResolver.resolveProjectArtifacts(this.session.getCurrentProject(), config);
        LOGGER.info("Resolved {} artifact(s) in {}", (Object)artifacts.size(), (Object)Duration.ofNanos(System.nanoTime() - artifactResolutionStart));
        ValidationChecksum validationChecksum = new ValidationChecksum.Builder().destination(mavenBuildDir).artifacts(artifacts).disabled(this.disableChecksum).build();
        if (validationChecksum.checkValidation()) {
            this.logWithQuiet("Artifacts were already validated in a previous run. Execution finished early as the checksum for the collection of artifacts has not changed.");
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Discovered project artifacts: {}", artifacts);
        }
        long signatureResolutionStart = System.nanoTime();
        ArtifactResolver.SignatureRequirement signaturePolicy = this.determineSignaturePolicy();
        Map<Artifact, Artifact> artifactMap = this.artifactResolver.resolveSignatures(artifacts, signaturePolicy);
        LOGGER.info("Resolved {} signature(s) in {}", (Object)artifactMap.size(), (Object)Duration.ofNanos(System.nanoTime() - signatureResolutionStart));
        long artifactValidationStart = System.nanoTime();
        try {
            this.verifyArtifactSignatures(artifactMap);
        }
        finally {
            LOGGER.info("Finished {} artifact(s) validation in {}", (Object)artifactMap.size(), (Object)Duration.ofNanos(System.nanoTime() - artifactValidationStart));
        }
        validationChecksum.saveChecksum();
    }

    private void checkDeprecated() {
        if (this.strictNoSignature != null) {
            LOGGER.warn("strictNoSignature is deprecated - this requirement can be expressed through the keysMap");
        }
    }

    private void initKeysMap() {
        LOGGER.debug("keysMapLocation={}", this.keysMapLocation);
        this.keysMapLocation.forEach(location -> {
            Void cfr_ignored_0 = (Void)Try.run(() -> this.keysMap.load((KeysMapLocationConfig)location)).getOrElseThrow(e -> new PGPMojoException(e.getMessage(), e));
        });
        if (this.keysMap.isEmpty()) {
            LOGGER.warn("No keysmap specified in configuration or keysmap contains no entries. PGPVerify will only check artifacts against their signature. File corruption will be detected. However, without a keysmap as a reference for trust, valid signatures of any public key will be accepted.");
        }
    }

    private ArtifactResolver.SignatureRequirement determineSignaturePolicy() {
        if (this.failNoSignature) {
            return ArtifactResolver.SignatureRequirement.REQUIRED;
        }
        return ArtifactResolver.SignatureRequirement.NONE;
    }

    private SkipFilter prepareDependencyFilters() {
        LinkedList<SkipFilter> filters = new LinkedList<SkipFilter>();
        filters.add(new ScopeSkipper(this.scope));
        if (!this.verifySnapshots) {
            filters.add(new SnapshotDependencySkipper());
        }
        if (!this.verifyProvidedDependencies) {
            filters.add(new ProvidedDependencySkipper());
        }
        if (!this.verifySystemDependencies) {
            filters.add(new SystemDependencySkipper());
        }
        if (!this.verifyReactorDependencies) {
            filters.add(new ReactorDependencySkipper(this.session));
        }
        return new CompositeSkipper(filters);
    }

    private SkipFilter preparePluginFilters() {
        LinkedList<SkipFilter> filters = new LinkedList<SkipFilter>();
        if (!this.verifySnapshots) {
            filters.add(new SnapshotDependencySkipper());
        }
        return new CompositeSkipper(filters);
    }

    private void verifyArtifactSignatures(Map<Artifact, Artifact> artifactToAsc) throws MojoFailureException, MojoExecutionException {
        boolean isAllSigOk = true;
        for (Map.Entry<Artifact, Artifact> artifactEntry : artifactToAsc.entrySet()) {
            Artifact artifact = artifactEntry.getKey();
            Artifact ascArtifact = artifactEntry.getValue();
            boolean isLastOk = this.verifyPGPSignature(artifact, ascArtifact);
            isAllSigOk = isAllSigOk && isLastOk;
        }
        if (!isAllSigOk) {
            throw new MojoExecutionException("PGP signature error");
        }
    }

    private boolean verifyPGPSignature(Artifact artifact, Artifact ascArtifact) throws MojoFailureException {
        if (ascArtifact == null) {
            return this.verifySignatureUnavailable(artifact);
        }
        File artifactFile = artifact.getFile();
        File signatureFile = ascArtifact.getFile();
        LOGGER.debug("Artifact file: {}", (Object)artifactFile);
        LOGGER.debug("Artifact sign: {}", (Object)signatureFile);
        PGPKeyId sigKeyID = null;
        try {
            PGPSignature pgpSignature;
            try (FileInputStream input = new FileInputStream(signatureFile);){
                pgpSignature = this.pgpSignatureUtils.loadSignature(input);
            }
            this.verifyWeakSignature(pgpSignature);
            sigKeyID = this.pgpSignatureUtils.retrieveKeyId(pgpSignature);
            PGPPublicKeyRing publicKeyRing = this.pgpKeysCache.getKeyRing(sigKeyID);
            PGPPublicKey publicKey = sigKeyID.getKeyFromRing(publicKeyRing);
            if (!this.keysMap.isValidKey(artifact, publicKey, publicKeyRing)) {
                String msg = String.format("%s = %s", ArtifactUtils.key((Artifact)artifact), PublicKeyUtils.fingerprintForMaster(publicKey, publicKeyRing));
                String keyUrl = this.pgpKeysCache.getUrlForShowKey(sigKeyID);
                LOGGER.error("Not allowed artifact {} and keyID:\n\t{}\n\t{}", new Object[]{artifact.getId(), msg, keyUrl});
                return false;
            }
            pgpSignature.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), publicKey);
            this.pgpSignatureUtils.readFileContentInto(pgpSignature, artifactFile);
            LOGGER.debug("signature.KeyAlgorithm: {} signature.hashAlgorithm: {}", (Object)pgpSignature.getKeyAlgorithm(), (Object)pgpSignature.getHashAlgorithm());
            return this.verifySignatureStatus(pgpSignature.verify(), artifact, publicKey, publicKeyRing);
        }
        catch (PGPKeyNotFound e) {
            if (this.keysMap.isKeyMissing(artifact)) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = () -> ((Artifact)artifact).getId();
                this.logWithQuiet("{} PGP key not found on keyserver, consistent with keys map.", supplierArray);
                return true;
            }
            LOGGER.error("PGP key {} not found on keyserver for artifact {}", (Object)this.pgpKeysCache.getUrlForShowKey(sigKeyID), (Object)artifact.getId());
            return false;
        }
        catch (PGPSignatureException e) {
            if (this.keysMap.isBrokenSignature(artifact)) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = () -> ((Artifact)artifact).getId();
                this.logWithQuiet("{} PGP Signature is broken, consistent with keys map.", supplierArray);
                return true;
            }
            LOGGER.error("Failed to process signature '{}' for artifact {} - {}", new Object[]{signatureFile, artifact.getId(), e.getMessage()});
            return false;
        }
        catch (IOException | PGPException e) {
            throw new MojoFailureException("Failed to process signature '" + signatureFile + "' for artifact " + artifact.getId(), e);
        }
    }

    private void verifyWeakSignature(PGPSignature pgpSignature) throws MojoFailureException {
        String weakHashAlgorithm = this.pgpSignatureUtils.checkWeakHashAlgorithm(pgpSignature);
        if (weakHashAlgorithm == null) {
            return;
        }
        String logMessage = "Weak signature algorithm used: " + weakHashAlgorithm;
        if (this.failWeakSignature) {
            LOGGER.error(logMessage);
            throw new MojoFailureException(logMessage);
        }
        LOGGER.warn(logMessage);
    }

    private boolean verifySignatureUnavailable(Artifact artifact) {
        if (this.keysMap.isEmpty()) {
            LOGGER.warn("No signature for {}", (Object)artifact.getId());
            return true;
        }
        if (this.keysMap.isNoSignature(artifact)) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((Artifact)artifact).getId();
            this.logWithQuiet("{} PGP Signature unavailable, consistent with keys map.", supplierArray);
            return true;
        }
        if (this.keysMap.isWithKey(artifact)) {
            LOGGER.error("Unsigned artifact is listed with key in keys map: {}", (Object)artifact.getId());
        } else {
            LOGGER.error("Unsigned artifact not listed in keys map: {}", (Object)artifact.getId());
        }
        return false;
    }

    private boolean verifySignatureStatus(boolean signatureStatus, Artifact artifact, PGPPublicKey publicKey, PGPPublicKeyRing publicKeyRing) {
        if (signatureStatus) {
            Supplier[] supplierArray = new Supplier[4];
            supplierArray[0] = () -> ((Artifact)artifact).getId();
            supplierArray[1] = () -> "OK";
            supplierArray[2] = () -> PublicKeyUtils.keyIdDescription(publicKey, publicKeyRing);
            supplierArray[3] = () -> PublicKeyUtils.getUserIDs(publicKey, publicKeyRing);
            this.logWithQuiet(PGP_VERIFICATION_RESULT_FORMAT, supplierArray);
            return true;
        }
        if (this.keysMap.isBrokenSignature(artifact)) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((Artifact)artifact).getId();
            this.logWithQuiet("{} PGP Signature is broken, consistent with keys map.", supplierArray);
            return true;
        }
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error(PGP_VERIFICATION_RESULT_FORMAT, new Object[]{artifact.getId(), "INVALID", PublicKeyUtils.keyIdDescription(publicKey, publicKeyRing), PublicKeyUtils.getUserIDs(publicKey, publicKeyRing)});
        }
        return false;
    }
}

